/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.advert.DeepBidControl;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlFactors;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpcFactorParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidControl {
    private static final Logger log = LoggerFactory.getLogger(BidControl.class);
    public static List<Long> tradeList = Arrays.asList(15L, 16L);

    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {
        HashMap<String, AdBidResultDo> ret = new HashMap<String, AdBidResultDo>();
        for (Map.Entry<String, AdBidInputDo> entry : advertMap.entrySet()) {
            String key = entry.getKey();
            AdBidInputDo adBidInputDo = entry.getValue();
            AdBidResultDo adBidResultDo = BidControl.bidControl(adBidInputDo, paramsModel);
            adBidResultDo.setKey(key);
            ret.put(key, adBidResultDo);
        }
        return ret;
    }

    public static AdBidResultDo bidControl(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel) {
        AdBidResultDo adBidResultDo = new AdBidResultDo();
        adBidResultDo.setAdvertId(adBidInputDo.getAdvertId());
        adBidResultDo.setPackageId(adBidInputDo.getPackageId());
        adBidResultDo.setSlotId(adBidInputDo.getSlotId());
        adBidResultDo.setReservePriceGiveUp(false);
        adBidResultDo.setReserveFee(adBidInputDo.getReserveFee());
        if (adBidInputDo.getChargeType() == null) {
            adBidInputDo.setChargeType(0);
        }
        adBidResultDo.setChargeType(adBidInputDo.getChargeType());
        adBidResultDo.setIsSupport(adBidInputDo.getIsSupport());
        adBidResultDo.setCtr(adBidInputDo.getCtr());
        adBidResultDo.setAccountId(adBidInputDo.getAccountId());
        if (adBidInputDo.getChargeType() == 1) {
            adBidResultDo.setFee(adBidInputDo.getFee());
            AdBidParamsDo cpcAdBidParamsDo = new AdBidParamsDo();
            cpcAdBidParamsDo.setIsNewOTest(adBidInputDo.getIsNewOTest());
            cpcAdBidParamsDo.setNewOAbTestId(adBidInputDo.getNewOAbTestId());
            adBidResultDo.setAdBidParamsDo(cpcAdBidParamsDo);
        }
        if (adBidInputDo.getChargeType() == 2) {
            AdBidParamsDo adBidParamsDo;
            long fee = BidControl.getOcpcFee(adBidInputDo.getCvr(), adBidInputDo.getAFee(), adBidInputDo.getAppAFee(), adBidInputDo.getSpecialAccountWeight());
            adBidResultDo.setFee(fee);
            adBidResultDo.setFactor(1.0);
            adBidResultDo.setDeepFeeFactor(1.0);
            if (AssertUtil.isNotEmpty((Object)paramsModel) && AssertUtil.isNotEmpty((Object)(adBidParamsDo = BidControl.getBidParams(adBidInputDo, paramsModel, fee)))) {
                adBidResultDo.setFee(adBidParamsDo.getFee());
                adBidResultDo.setFactor(adBidParamsDo.getFactor());
                adBidResultDo.setAdBidParamsDo(adBidParamsDo);
                adBidResultDo.setReservePriceGiveUp(adBidParamsDo.getIsGiveUp());
                adBidResultDo.setDcvrGiveUp(adBidParamsDo.getDcvrGiveUp());
                adBidResultDo.setDeepFeeFactor(adBidParamsDo.getDeepFeeFactor());
            }
        }
        return adBidResultDo;
    }

    public static AdBidParamsDo getBidParams(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel, long fee) {
        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();
        Long advertId = adBidInputDo.getAdvertId();
        Long packageId = adBidInputDo.getPackageId();
        Long slotId = adBidInputDo.getSlotId();
        Long cpcFee = adBidInputDo.getFee();
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setOriginalFee(fee);
        adBidParamsDo.setAdvertId(advertId);
        adBidParamsDo.setNewTradeId(adBidInputDo.getNewTradeTagId());
        adBidParamsDo.setSlotId(slotId);
        adBidParamsDo.setPackageId(packageId);
        adBidParamsDo.setAFee(adBidInputDo.getAFee());
        adBidParamsDo.setAppAFee(adBidInputDo.getAppAFee());
        adBidParamsDo.setDeepFee(adBidInputDo.getDeepFee());
        adBidParamsDo.setDcvrLowerBound(adBidInputDo.getDcvrLowerBound());
        adBidParamsDo.setChargeType(adBidInputDo.getChargeType());
        adBidParamsDo.setCvrType(adBidInputDo.getCvrType());
        adBidParamsDo.setDeepCvrType(adBidInputDo.getDeepCvrType());
        adBidParamsDo.setPreDcvr(adBidInputDo.getPreDcvr());
        adBidParamsDo.setFactor(1.0);
        adBidParamsDo.setReserveFee(adBidInputDo.getReserveFee());
        adBidParamsDo.setReservePriceWhite(adBidInputDo.getReservePriceWhite());
        adBidParamsDo.setIsAutoTarget(adBidInputDo.getIsAutoTarget());
        adBidParamsDo.setAbTestId(adBidInputDo.getAbTestId());
        adBidParamsDo.setFastAbTestId(adBidInputDo.getFastAbTestId());
        adBidParamsDo.setIsNewOTest(adBidInputDo.getIsNewOTest());
        adBidParamsDo.setNewOAbTestId(adBidInputDo.getNewOAbTestId());
        adBidParamsDo.setIsColdTest(adBidInputDo.getIsColdTest());
        adBidParamsDo.setColdAbTestId(adBidInputDo.getColdAbTestId());
        adBidParamsDo.setDeepControlType(adBidInputDo.getDeepControlType());
        adBidParamsDo.setDoubleMode(adBidInputDo.getDoubleMode());
        adBidParamsDo.setBidControlType(adBidInputDo.getBidControlType());
        adBidParamsDo.setDeepAllEffect(adBidInputDo.getDeepAllEffect());
        adBidParamsDo.setReleaseTarget(adBidInputDo.getReleaseTarget());
        adBidParamsDo.setDeepDelayType(adBidInputDo.getDeepDelayType());
        adBidParamsDo.setAppLimitReleaseMark(adBidInputDo.getAppLimitReleaseMark());
        adBidParamsDo.setPriceRiseMark(adBidInputDo.getPriceRiseMark());
        adBidParamsDo.setEeAbTestId(adBidInputDo.getEeAbTestId());
        adBidParamsDo.setUpSpeedAbTestId(adBidInputDo.getUpSpeedAbTestId());
        OcpxControlSubModel pModel = adBidInputDo.getOcpxControlSubModel();
        if (pModel != null) {
            int costParamsType = 1;
            if (adBidParamsDo.getDeepControlType() == null || adBidParamsDo.getAbTestId() == null || adBidParamsDo.getAbTestId().equals(2)) {
                // empty if block
            }
            BidControl.costControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType));
            BidControl.deepControl(adBidParamsDo, pModel.getDeepControlParams(costParamsType), pModel.getDeepControlParams(costParamsType, slotId), pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId));
            BidControl.protectControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType), costParamsType);
        }
        return adBidParamsDo;
    }

    public static void costControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams) {
        Long factorType = null;
        Double factor = 1.0;
        Double pcFactor = 1.0;
        Double fcFactor = 1.0;
        String updateTime = null;
        Long fee = adBidParamsDo.getFee();
        Integer resetType = OcpxControlParams.getResetType(pkParams);
        OcpcFactorParams slotFactorParams = OcpxControlParams.getOcpcFactors(slotParams);
        OcpcFactorParams pkFactorParams = OcpxControlParams.getOcpcFactors(pkParams);
        OcpcFactorParams atPkFactorParams = OcpxControlParams.getOcpcFactors(atPkParams);
        Double slotFactor = slotFactorParams.getFactor();
        Double pkFactor = pkFactorParams.getFactor();
        Double atPkFactor = atPkFactorParams.getFactor();
        if (pkFactor != null) {
            factorType = 1L;
            factor = pkFactor;
            pcFactor = pkFactorParams.getPcFactor();
            fcFactor = pkFactorParams.getFcFactor();
            updateTime = OcpxControlParams.getUpdateTime(pkParams);
        }
        if (slotFactor != null) {
            factorType = 2L;
            factor = slotFactor;
            pcFactor = slotFactorParams.getPcFactor();
            fcFactor = slotFactorParams.getFcFactor();
            updateTime = OcpxControlParams.getUpdateTime(slotParams);
        } else if (Math.random() < 1.0E-4) {
            log.info("All param is null. pkId is " + adBidParamsDo.getPackageId() + "slotId is " + adBidParamsDo.getSlotId() + "abTest id is " + adBidParamsDo.getAbTestId());
        }
        Long feeNew = Math.round((double)fee.longValue() * factor);
        adBidParamsDo.setResetType(resetType);
        adBidParamsDo.setFactorType(factorType);
        adBidParamsDo.setFactor(factor * adBidParamsDo.getFactor());
        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setKbFee(feeNew);
        adBidParamsDo.setPcFactor(pcFactor);
        adBidParamsDo.setFcFactor(fcFactor);
        adBidParamsDo.setUpdateTime(updateTime);
    }

    public static void deepControl(AdBidParamsDo adBidParamsDo, DeepControlParams pkParams, DeepControlParams slotParams, OcpxControlParams pkCostParams, OcpxControlParams slotCostParams) {
        Long fee = adBidParamsDo.getFee();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adBidParamsDo.getDeepControlType(), adBidParamsDo.getDeepFee(), adBidParamsDo.getDeepCvrType()})) {
            return;
        }
        boolean deepStatus = true;
        if (adBidParamsDo.getNewTradeId() != null && (adBidParamsDo.getNewTradeId().equals(15L) || adBidParamsDo.getNewTradeId().equals(1L) || adBidParamsDo.getNewTradeId().equals(16L))) {
            deepStatus = false;
            if (adBidParamsDo.getAbTestId() != null && adBidParamsDo.getAbTestId().equals(2)) {
                deepStatus = true;
            }
        }
        if (adBidParamsDo.getNewTradeId() == null) {
            deepStatus = false;
            if (adBidParamsDo.getAbTestId() != null && adBidParamsDo.getAbTestId().equals(2)) {
                deepStatus = true;
            }
        }
        DeepControlParams useParams = new DeepControlParams();
        OcpxControlParams useCostParams = new OcpxControlParams();
        if (slotParams.getDeepFactor() != null) {
            useParams = slotParams;
            useCostParams = slotCostParams;
        } else if (pkParams.getDeepFactor() != null) {
            useParams = pkParams;
            useCostParams = pkCostParams;
        }
        DeepControlFactors useFactorDto = DeepBidControl.getDeepFactor(useCostParams, useParams, adBidParamsDo);
        if (deepStatus && useFactorDto.getDeepFactor() != null) {
            adBidParamsDo.setFee(Math.round((double)fee.longValue() * useFactorDto.getDeepFactor()));
            adBidParamsDo.setDeepControlFactor(useFactorDto.getDeepFactor());
            adBidParamsDo.setDeepFeeFactor(useFactorDto.getDeepFeeFactor());
            adBidParamsDo.setDcvrLowerBound(useFactorDto.getDcvrLowerBound());
        }
        adBidParamsDo.setPkStatDcvr(useParams.getPkStatDcvr());
        adBidParamsDo.setSlotStatDcvr(useParams.getSlotStatDcvr());
        adBidParamsDo.setDeepConfWeight(useParams.getConfWeight());
        adBidParamsDo.setStatDeepFactor(useFactorDto.getStatDeepFactor());
        adBidParamsDo.setPreDeepFactor(useFactorDto.getPreDeepFactor());
    }

    public static void coldControl(AdBidParamsDo adBidParamsDo, AdControlParams adControlParams, SlotControlParams slotControlParams, Long cpcFee) {
        Boolean coldProject = null;
        Long coldProjectFeeDiff = null;
        Long fee = adBidParamsDo.getFee();
        if (slotControlParams != null && (adControlParams == null || adControlParams.getIsColdStart() == null || adControlParams.getIsColdStart().booleanValue())) {
            coldProject = true;
            Long feeNew = SlotControlParams.getFee(fee, cpcFee, slotControlParams);
            coldProjectFeeDiff = fee - feeNew;
            fee = feeNew;
        }
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setDefaultFee(cpcFee);
        adBidParamsDo.setColdProject(coldProject);
        adBidParamsDo.setColdProjectFeeDiff(coldProjectFeeDiff);
    }

    public static void protectControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams, int costParamsType) {
        Boolean secondPriceProject = null;
        Double secondProtectPriceFactor = null;
        Double extraCFactor = 1.0;
        Integer extraCSwitch = 0;
        Long costReplase = null;
        Long costDiff = null;
        if (atPkParams != null && atPkParams.getCFactor() != null) {
            secondProtectPriceFactor = atPkParams.getCFactor();
            extraCFactor = atPkParams.getExtraCFactor();
            extraCSwitch = atPkParams.getExtraCSwitch();
            costReplase = atPkParams.getCostReplase();
            costDiff = atPkParams.getCostDiff();
        } else if (slotParams != null && slotParams.getCFactor() != null) {
            secondProtectPriceFactor = slotParams.getCFactor();
            extraCFactor = slotParams.getExtraCFactor();
            extraCSwitch = slotParams.getExtraCSwitch();
            costReplase = slotParams.getCostReplase();
            costDiff = slotParams.getCostDiff();
        } else if (pkParams != null && pkParams.getCFactor() != null) {
            secondProtectPriceFactor = pkParams.getCFactor();
            extraCFactor = pkParams.getExtraCFactor();
            extraCSwitch = pkParams.getExtraCSwitch();
            costReplase = pkParams.getCostReplase();
            costDiff = pkParams.getCostDiff();
        }
        if (secondProtectPriceFactor != null) {
            secondPriceProject = true;
        }
        adBidParamsDo.setSecondPriceProject(secondPriceProject);
        adBidParamsDo.setCFactor(secondProtectPriceFactor);
        adBidParamsDo.setExtraCFactor(extraCFactor);
        adBidParamsDo.setExtraCSwitch(extraCSwitch);
        adBidParamsDo.setCostDiff(costDiff);
        adBidParamsDo.setCostReplase(costReplase);
    }

    public static void floorPriceControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Boolean isGiveUp = null;
        if (adBidParamsDo.getReservePriceWhite() != null && adBidParamsDo.getReservePriceWhite().booleanValue()) {
            adBidParamsDo.setReservePriceWhite(true);
            return;
        }
        Long giveUpFee = null;
        Double giveUpRatio = null;
        if (slotParams != null && slotParams.getFConf() != null && slotParams.getFConf().booleanValue()) {
            giveUpFee = slotParams.getFPriceThre();
            giveUpRatio = slotParams.getFGiveUpProb();
        } else if (pkParams != null && pkParams.getFConf() != null) {
            giveUpFee = pkParams.getFPriceThre();
            giveUpRatio = pkParams.getFGiveUpProb();
        } else {
            return;
        }
        double rate = Math.random();
        if (giveUpRatio != null && giveUpFee != null && rate < giveUpRatio && adBidParamsDo.getFee() <= giveUpFee) {
            isGiveUp = true;
        }
        adBidParamsDo.setIsGiveUp(isGiveUp);
        adBidParamsDo.setGiveUpFee(giveUpFee);
        adBidParamsDo.setGiveUpRatio(giveUpRatio);
    }

    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {
        OcpxControlParams ocpxControlParams;
        OcpxControlSubModel ocpxControlSubModel;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertId, packageId, type, paramsModel}) && (ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId)) != null && (ocpxControlParams = ocpxControlSubModel.getOcpxControlParams()) != null) {
            ocpxControlParams.setResetType(type);
        }
    }

    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlSubModel ocpxControlSubModel) {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertId, packageId, type, ocpxControlSubModel}) && ocpxControlSubModel != null) {
            OcpxControlParams ocpxControlParams3;
            OcpxControlParams ocpxControlParams2;
            OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();
            if (ocpxControlParams != null) {
                ocpxControlParams.setResetType(type);
            }
            if ((ocpxControlParams2 = ocpxControlSubModel.getOcpxControlParams(2)) != null) {
                ocpxControlParams2.setResetType(type);
            }
            if ((ocpxControlParams3 = ocpxControlSubModel.getOcpxControlParams(3)) != null) {
                ocpxControlParams3.setResetType(type);
            }
        }
    }

    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {
        if (AssertUtil.isEmpty((Object)top1)) {
            return bidResultTop1;
        }
        if (bidResultTop1 != null) {
            bidResultTop1.setFee(top1.getFee());
        }
        if (bidResultTop1 != null && bidResultTop1.getAdBidParamsDo() != null) {
            Long reserveFee;
            Boolean isSecondPriceProject = bidResultTop1.getAdBidParamsDo().getSecondPriceProject();
            Double protectPriceFactor = bidResultTop1.getAdBidParamsDo().getCFactor();
            Long costReplase = bidResultTop1.getAdBidParamsDo().getCostReplase();
            Long costDiff = bidResultTop1.getAdBidParamsDo().getCostDiff();
            Double extraCFactor = bidResultTop1.getAdBidParamsDo().getExtraCFactor();
            Integer extraCSwitch = bidResultTop1.getAdBidParamsDo().getExtraCSwitch();
            if (extraCSwitch != null && extraCSwitch == 1 && extraCFactor != null && !AssertUtil.isEmpty((Object)top2)) {
                top2.setFee(Math.round(extraCFactor * (double)top2.getFee().longValue()));
                if (Math.random() < 0.001) {
                    log.info("extraCFactor " + extraCFactor.toString() + " extraCSwitch" + extraCSwitch.toString() + " advertId " + top1.getAdvertId() + " pkId " + top1.getPackageId());
                }
            }
            if ((reserveFee = bidResultTop1.getReserveFee()) == null) {
                reserveFee = 1L;
            }
            if (isSecondPriceProject != null && isSecondPriceProject.booleanValue() && protectPriceFactor != null && top1.getFee() > reserveFee) {
                long protectFee;
                if (protectPriceFactor > 1.0) {
                    protectFee = Math.round((double)top1.getFee().longValue() * protectPriceFactor);
                    bidResultTop1.setFee(protectFee);
                } else {
                    protectFee = Math.round((double)top1.getFee().longValue() * protectPriceFactor);
                    long secondFee = protectFee = Math.max(protectFee, reserveFee);
                    if (!AssertUtil.isEmpty((Object)top2)) {
                        secondFee = BidControl.getSecondFee(top1.getCtr(), top2.getCtr(), top2.getFee());
                    }
                    long feeNew = Math.max(secondFee, protectFee);
                    feeNew = Math.min(top1.getFee(), feeNew);
                    bidResultTop1.setFee(feeNew);
                    bidResultTop1.getAdBidParamsDo().setOriginalFee(top1.getFee());
                }
            }
            if (costReplase != null && costReplase > 0L) {
                bidResultTop1.setFee(costReplase);
            } else if (costDiff != null) {
                Long feeNew = bidResultTop1.getFee() + costDiff;
                bidResultTop1.setFee(Math.max(feeNew, 1L));
            }
        }
        return bidResultTop1;
    }

    public static AdFeeDo reRank(AdFeeDo top1, List<AdFeeDo> coldAdList) {
        if (AssertUtil.isEmpty(coldAdList)) {
            return top1;
        }
        Random r = new Random();
        int idx = r.nextInt(coldAdList.size());
        AdFeeDo coldAd = coldAdList.get(idx);
        double ctr_rate = 1.0;
        if (top1.getCtr() != null && coldAd.getCtr() != null) {
            ctr_rate = (top1.getCtr() + 0.01) / (coldAd.getCtr() + 0.01);
        }
        ctr_rate = MathUtil.stdwithBoundary((double)ctr_rate, (double)0.8, (double)1.2);
        double coldAd_fee = top1.getFee().doubleValue() * ctr_rate;
        coldAd.setFee(new Double(coldAd_fee).longValue());
        return coldAd;
    }

    private static long getSecondFee(double ctr1, double ctr2, long fee2) {
        double feeNew = ctr2 * (double)fee2 / ctr1;
        return Math.round(feeNew) + 1L;
    }

    private static long getOcpcFee(double cvr, long afee, Long appFee, Double specialAccountWeight) {
        return appFee == null ? BidControl.getOcpcFee(cvr, afee, specialAccountWeight) : BidControl.getOcpcFee(cvr, appFee, specialAccountWeight);
    }

    private static long getOcpcFee(double cvr, long afee, Double specialAccountWeight) {
        if (specialAccountWeight == null) {
            specialAccountWeight = 1.0;
        }
        return Math.round(cvr * (double)afee * specialAccountWeight);
    }
}

