/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.AdvertRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlFactors;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepBidControl {
    private static final Logger log = LoggerFactory.getLogger(DeepBidControl.class);
    static Double targetCost = 1.0;

    public static DeepControlFactors calculateNormal(Long deepFee, Long aFee, Double preDcvr, Double confWeight, Double preMergeWeight, Double statFactor, Double preMergeDiffU, Double preMergeDiffL, Double preDeepCalibrate, Double deepSupportFactor) {
        DeepControlFactors retDto = new DeepControlFactors();
        if (preDeepCalibrate == null) {
            preDeepCalibrate = 1.0;
        }
        Double preFactor = targetCost * (double)deepFee.longValue() * Math.min(preDcvr * preDeepCalibrate, 1.0) / (double)aFee.longValue();
        if (preDcvr < 1.0E-7) {
            preMergeWeight = 0.0;
        }
        Double factor = confWeight * preMergeWeight * preFactor + (1.0 - confWeight * preMergeWeight) * statFactor;
        Double deepFeeFactor = factor = Double.valueOf(MathUtil.formatDouble((double)MathUtil.stdwithBoundary((double)factor, (double)0.6, (double)1.1), (int)4));
        if (factor > 1.0) {
            deepFeeFactor = 1.0 + (factor - 1.0) * deepSupportFactor;
        }
        if (factor <= 1.0 && factor >= 0.8) {
            factor = 1.0;
            deepFeeFactor = 1.0;
        }
        if (preDcvr != null && preDcvr < 0.8 && preDcvr > 0.1) {
            factor = 1.0;
            deepFeeFactor = 1.0;
        }
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        retDto.setDeepFactor(factor);
        retDto.setDeepFeeFactor(deepFeeFactor);
        return retDto;
    }

    public static DeepControlFactors calculate(Long deepFee, Long aFee, Double preDcvr, Double statDcvr, Double confWeight, double deepSupportFactor, double dcvrLowerBound) {
        DeepControlFactors retDto = new DeepControlFactors();
        Double preFactor = 1.0;
        double preWeight = 0.0;
        if (preDcvr != null && preDcvr > 1.0E-5) {
            preFactor = MathUtil.formatDouble((double)(targetCost * (double)deepFee.longValue() * Math.min(preDcvr, 1.0) / (double)aFee.longValue()), (int)5);
            preWeight = 1.0;
        }
        Double statFactor = 1.0;
        double statWeight = 0.0;
        if (statDcvr != null && statDcvr > 1.0E-6) {
            statFactor = MathUtil.formatDouble((double)(targetCost * (double)deepFee.longValue() * Math.min(statDcvr, 1.0) / (double)aFee.longValue()), (int)5);
            statWeight = 1.0;
        }
        if (confWeight == null) {
            confWeight = 0.5;
        }
        Double deepFactor = confWeight * preWeight * preFactor + (1.0 - confWeight * preWeight) * statFactor;
        double lowB = 1.0;
        double upB = 1.1;
        if (preDcvr != null && preDcvr > 1.0E-5 && preDcvr < dcvrLowerBound) {
            lowB = 0.6;
        }
        deepFactor = MathUtil.formatDouble((double)MathUtil.stdwithBoundary((double)deepFactor, (double)lowB, (double)upB), (int)5);
        Double deepFeeFactor = 1.0 + (deepFactor - 1.0) * deepSupportFactor;
        if (preDcvr != null && preDcvr > 1.0E-5 && preDcvr < dcvrLowerBound) {
            deepFactor = 0.5 * deepFactor;
            deepFeeFactor = 0.5 * deepFeeFactor;
        }
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        retDto.setDeepFactor(deepFactor);
        retDto.setDeepFeeFactor(deepFeeFactor);
        return retDto;
    }

    public static DeepControlFactors getDeepFactor(OcpxControlParams costParams, DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Long deepFee = adBidParamsDo.getDeepFee();
        if (params.getDeepAFee() != null) {
            deepFee = params.getDeepAFee();
        }
        Long aFee = adBidParamsDo.getAFee();
        Long appAFee = adBidParamsDo.getAppAFee();
        Long usefulAfee = aFee;
        if (appAFee != null && appAFee > 0L) {
            usefulAfee = appAFee;
        }
        Double preDcvr = adBidParamsDo.getPreDcvr();
        DeepControlFactors retDto = new DeepControlFactors();
        if (params == null || params.getDeepFactor() == null) {
            return retDto;
        }
        Double statFactor = params.getDeepFactor();
        retDto.setDeepFactor(statFactor);
        retDto.setStatDeepFactor(statFactor);
        Double confWeight = params.getConfWeight();
        Double slotStatDcvr = params.getSlotStatDcvr();
        Double pkSlotStatDcvr = params.getPkStatDcvr();
        if (slotStatDcvr == null) {
            slotStatDcvr = pkSlotStatDcvr;
        }
        Double preMergeWeight = params.getPreMergeWeight();
        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();
        Double dcvrLowerBound = adBidParamsDo.getDcvrLowerBound();
        if (dcvrLowerBound == null) {
            dcvrLowerBound = 1.0E-4;
        }
        double deepSupportFactor = params.getDeepSupportFactor();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{confWeight, preDcvr, deepFee, usefulAfee, preMergeWeight, preMergeDiffU, preMergeDiffL, statFactor})) {
            retDto = DeepBidControl.calculate(deepFee, usefulAfee, preDcvr, slotStatDcvr, confWeight, deepSupportFactor, dcvrLowerBound);
        }
        retDto.setUsedDeepAFee(deepFee);
        retDto.setDcvrLowerBound(dcvrLowerBound);
        return retDto;
    }

    public static Boolean dcvrConstrain(DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Boolean result = false;
        return result;
    }

    public static void main(String[] args) {
        String str2 = "[{\"ctr\":0.190892,\"t_tag\":\"15\",\"ad\":79991,\"fee\":4,\"rankScore\":0.7636,\"preDcvr\":0.0,\"cy\":3,\"scvr\":0.0017,\"arpu\":0.7636,\"pk\":0,\"pre_ctr\":0.15726,\"sctr\":0.493581,\"pre_cvr\":0.0026,\"cvr\":0.00251},{\"ctr\":0.114657,\"t_tag\":\"1\",\"ad\":80651,\"fee\":5,\"rankScore\":0.5733,\"preDcvr\":0.0,\"cy\":3,\"scvr\":0.01,\"arpu\":0.5733,\"pk\":198617,\"pre_ctr\":0.07141,\"sctr\":0.50388,\"pre_cvr\":0.00053,\"cvr\":0.001477}]";
        List ret = JSON.parseArray((String)str2, AdvertRcmdDo.class);
        DeepControlFactors retDto = DeepBidControl.calculate(1435L, 1200L, 0.77, 0.75, 0.5, 0.5, 0.85);
        System.out.println(JSON.toJSONString((Object)retDto));
    }
}

