/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.material;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MaterialSelectModel {
    public Long advertId;
    public double randomWeight = 0.15;
    public String updateTime;
    public Set<Long> pkgSet = new HashSet<Long>();
    public Map<String, Long> bestMaterialIdMap = new HashMap<String, Long>();

    public Long getBestMaterial(Long pkgId, Long appId) {
        Long ret = null;
        Long pkgBestMaterialIdOnApp = this.getBestMaterialWithInfo(pkgId, appId);
        Long pkgBestMaterialId = this.getBestMaterialWithInfo(pkgId, null);
        Long adBestMaterialIdOnApp = this.getBestMaterialWithInfo(null, appId);
        Long adBestMaterialId = this.getBestMaterialWithInfo(null, null);
        if (pkgBestMaterialIdOnApp != null) {
            return pkgBestMaterialIdOnApp;
        }
        if (pkgBestMaterialId != null) {
            return pkgBestMaterialId;
        }
        if (adBestMaterialIdOnApp != null) {
            return adBestMaterialIdOnApp;
        }
        if (adBestMaterialId != null) {
            return adBestMaterialId;
        }
        return ret;
    }

    public String getKey(Long pkgId, Long appId) {
        return this.advertId + "_" + pkgId + "_" + appId;
    }

    public Long getBestMaterialWithInfo(Long pkgId, Long appId) {
        String key = this.getKey(pkgId, appId);
        return this.bestMaterialIdMap.get(key);
    }

    public Long getAdvertId() {
        return this.advertId;
    }

    public double getRandomWeight() {
        return this.randomWeight;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Set<Long> getPkgSet() {
        return this.pkgSet;
    }

    public Map<String, Long> getBestMaterialIdMap() {
        return this.bestMaterialIdMap;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public void setRandomWeight(double randomWeight) {
        this.randomWeight = randomWeight;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setPkgSet(Set<Long> pkgSet) {
        this.pkgSet = pkgSet;
    }

    public void setBestMaterialIdMap(Map<String, Long> bestMaterialIdMap) {
        this.bestMaterialIdMap = bestMaterialIdMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialSelectModel)) {
            return false;
        }
        MaterialSelectModel other = (MaterialSelectModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$advertId = this.getAdvertId();
        Long other$advertId = other.getAdvertId();
        if (this$advertId == null ? other$advertId != null : !((Object)this$advertId).equals(other$advertId)) {
            return false;
        }
        if (Double.compare(this.getRandomWeight(), other.getRandomWeight()) != 0) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        Set<Long> this$pkgSet = this.getPkgSet();
        Set<Long> other$pkgSet = other.getPkgSet();
        if (this$pkgSet == null ? other$pkgSet != null : !((Object)this$pkgSet).equals(other$pkgSet)) {
            return false;
        }
        Map<String, Long> this$bestMaterialIdMap = this.getBestMaterialIdMap();
        Map<String, Long> other$bestMaterialIdMap = other.getBestMaterialIdMap();
        return !(this$bestMaterialIdMap == null ? other$bestMaterialIdMap != null : !((Object)this$bestMaterialIdMap).equals(other$bestMaterialIdMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialSelectModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $advertId = this.getAdvertId();
        result = result * 59 + ($advertId == null ? 43 : ((Object)$advertId).hashCode());
        long $randomWeight = Double.doubleToLongBits(this.getRandomWeight());
        result = result * 59 + (int)($randomWeight >>> 32 ^ $randomWeight);
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        Set<Long> $pkgSet = this.getPkgSet();
        result = result * 59 + ($pkgSet == null ? 43 : ((Object)$pkgSet).hashCode());
        Map<String, Long> $bestMaterialIdMap = this.getBestMaterialIdMap();
        result = result * 59 + ($bestMaterialIdMap == null ? 43 : ((Object)$bestMaterialIdMap).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialSelectModel(advertId=" + this.getAdvertId() + ", randomWeight=" + this.getRandomWeight() + ", updateTime=" + this.getUpdateTime() + ", pkgSet=" + this.getPkgSet() + ", bestMaterialIdMap=" + this.getBestMaterialIdMap() + ")";
    }
}

