/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.landpage;

import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandpgModel {
    private static final Logger logger = LoggerFactory.getLogger(LandpgModel.class);
    private E2ELocalTFModel Model;
    private DeepModelV2 deepModelV2;
    private LocalTFModelV2 localTFModelV2;

    public <T> Map<T, Double> predict(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map ret = this.Model.predict(modelInput);
            return ret;
        }
        catch (Exception e) {
            logger.error("LandpageRecommend.predictScore error{}, Model{}", (Object)e, (Object)this.Model);
            return Collections.emptyMap();
        }
    }

    public E2ELocalTFModel getModel() {
        return this.Model;
    }

    public DeepModelV2 getDeepModelV2() {
        return this.deepModelV2;
    }

    public LocalTFModelV2 getLocalTFModelV2() {
        return this.localTFModelV2;
    }

    public void setModel(E2ELocalTFModel Model2) {
        this.Model = Model2;
    }

    public void setDeepModelV2(DeepModelV2 deepModelV2) {
        this.deepModelV2 = deepModelV2;
    }

    public void setLocalTFModelV2(LocalTFModelV2 localTFModelV2) {
        this.localTFModelV2 = localTFModelV2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LandpgModel)) {
            return false;
        }
        LandpgModel other = (LandpgModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        E2ELocalTFModel this$Model = this.getModel();
        E2ELocalTFModel other$Model = other.getModel();
        if (this$Model == null ? other$Model != null : !this$Model.equals(other$Model)) {
            return false;
        }
        DeepModelV2 this$deepModelV2 = this.getDeepModelV2();
        DeepModelV2 other$deepModelV2 = other.getDeepModelV2();
        if (this$deepModelV2 == null ? other$deepModelV2 != null : !this$deepModelV2.equals(other$deepModelV2)) {
            return false;
        }
        LocalTFModelV2 this$localTFModelV2 = this.getLocalTFModelV2();
        LocalTFModelV2 other$localTFModelV2 = other.getLocalTFModelV2();
        return !(this$localTFModelV2 == null ? other$localTFModelV2 != null : !this$localTFModelV2.equals(other$localTFModelV2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LandpgModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        E2ELocalTFModel $Model = this.getModel();
        result = result * 59 + ($Model == null ? 43 : $Model.hashCode());
        DeepModelV2 $deepModelV2 = this.getDeepModelV2();
        result = result * 59 + ($deepModelV2 == null ? 43 : $deepModelV2.hashCode());
        LocalTFModelV2 $localTFModelV2 = this.getLocalTFModelV2();
        result = result * 59 + ($localTFModelV2 == null ? 43 : $localTFModelV2.hashCode());
        return result;
    }

    public String toString() {
        return "LandpgModel(Model=" + this.getModel() + ", deepModelV2=" + this.getDeepModelV2() + ", localTFModelV2=" + this.getLocalTFModelV2() + ")";
    }
}

