package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

@Data
public class AdxBidRet {

    /**
     * 创意计划ID
     */
    private Long ideaId;

    /**
     * 创意素材ID
     */
    private Long ideaUnitId;

    /**
     * 算法出价
     */
    private Long adxAlgoPrice;

    /**
     * 维稳因子
     */
    private Double factor;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * 融合ctr
     */
    private Double ctr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 融合每pv发券
     */
    private Double launchPv;

    /**
     * 点击价值
     */
    private Double clickValue;

    /**
     * 统计arpu值
     */
    private Double arpu;

    /**
     * 预估arpu值
     */
    private Double preArpu;

    /**
     * 融合arpu值
     */
    private Double mixArpu;

    /**
     * 精排排序分
     */
    private Double rankScore;

    /**
     * 探价分桶，0=base桶，1=探价桶，2=探价指导桶
     */
    private int level;

    /**
     * 投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价
     */
    private Integer exploreType;

    /**
     * 底价/分
     */
    private Double basePrice;

    /**
     * 算法判断--计划创意来源池：true-冷启动池，false-优选池
     */
    private Boolean isNew;

    /**
     * 当前是否开启计划冷启动探价 0=关闭, 1-开启
     */
    private Boolean isColdStart;

    /**
     * 流量是否放弃（PD/PDB流量专用）
     * PD流量：0--不放弃；1--放弃
     * PDB流量：0--不放弃
     * RTB流量：不使用
     */
    private Integer isGiveUp;

    //首发券相关

    /**
     * 首发券广告ID
     */
    private Long flcAdvertId;

    /**
     * 预估cvr
     */
    private Double preCvr;

    /**
     * 统计cvr
     */
    private Double statCvr;

    /**
     * 融合cvr
     */
    private Double mergeCvr;

    /**
     * 预估clickPv
     */
    private Double preClickPv;

    /**
     * 统计clickPv
     */
    private Double statClickPv;

    /**
     * 融合clickPv
     */
    private Double mergeClickPv;

    /**
     * 预估adCpc
     */
    private Double preAdCpc;

    /**
     * 统计adCpc
     */
    private Double statAdCpc;

    /**
     * 融合adCpc
     */
    private Double mergeAdCpc;

    /**
     * 融合 launchPv/clickPv
     */
    private Double launchOrClickPv;

    /**
     * 融合 arpu/adCpc
     */
    private Double arpuOrAdCpc;

    /**
     * 用户打分模型打分
     */
    private Double userScore;

    /**
     * 用户打分模型打分V2
     */
    private Double userScoreV2;

    /**
     * 预估价值分层，按预估曝光价值/点击价值 分层，0-8
     */
    private int preInterval;

    /**
     * 预估曝光价值
     */
    private Double preEcpm;

    /**
     * 预估点击价值
     */
    private Double preEcpc;


    /**
     * 低价值过滤
     */
    private Integer isEcpmGiveUp;

    /**
     *竞价阈值
     *
     */
    private Double bidEcpmThreadhold;

    /**
     * 资源位ID
     */
    private Long resId;

    /**
     * 7.13 提价策略新增字段，素材曝光维度打印日志会新增以下字段，分别表示提价系数、维度描述、系数更新时间、分桶id、目标roi
     */
    private AdxBidPrint adxBidPrint;
}
