package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

@Data
public class CalibrateParams {
    /**
     * 校准因子相关参数，因为维度和时间范围不同，单独一套参数
     * 维度： <广告>统计数据 <广告,广告位> 统计数据
     * 时间：1小时，2小时，3小时，6小时
     */
    private Long cvrCnt; // 累计的转化pv

    private Double pcvrSum; // 累加的pcvr

    private Double pcvrBias; // 预估偏差

//    private Double MergedPcvrBias; //最终融合的预估偏差

    private Double confidenceWeight; // 数据的置信程度,(实际消耗的量级大小)

    private Double pcFactor = 1.0; //预估值校准因子

    private Long senCvrCnt; // 灵敏拿量的累积转化pv，30分钟下的<广告，广告位>统计数据

    private Double senPcvrSum; //灵敏拿量的累加pcvr，30分钟下的<广告，广告位>统计数据

    private Double senPcvrBias; //灵敏拿量的预估偏差，30分钟下的<广告，广告位>统计数据

    private Double senPcFactor = 1.0; //灵敏拿量的预估校准因子，30分钟下的<广告，广告位>统计数据

}
