package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Data
public class CalibrateSubModel {

    // 广告维度下的统计获得校准参数
    CalibrateParams AdCalParams = new CalibrateParams();

    // <广告, 广告位>维度下的统计获得校准参数
    Map<Long, CalibrateParams> AdSlotCalParams = new ConcurrentHashMap<>();


    public CalibrateParams getCalibrateParams(Long slotId) {
        // 12.1 注释
        if (slotId == null) {
            slotId = -1L;
        }
        CalibrateParams param = AdSlotCalParams.get(slotId);
        if (param == null) {
            CalibrateParams backUpParam = new CalibrateParams();
            AdSlotCalParams.put(slotId, backUpParam);
            return backUpParam;
        }
        return param;
    }

}
