package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Data
public class CalibrateSubModel {

    // 广告维度下的统计获得校准参数
    CalibrateParams AdCalParams = new CalibrateParams();

    // <广告, 广告位>维度下的统计获得校准参数
    Map<Long, CalibrateParams> AdSlotCalParams = new ConcurrentHashMap<>();

    // 30分钟，<广告，广告位>维度下的统计校准参数, 灵敏拿量配置校准的独立参数。
    Map<Long, CalibrateParams> AdSlotSenCalParams = new ConcurrentHashMap<>();


    /**
     *
     * @param slotId 广告位id
     * @param paramsType 参数类型，1-正常校准因子，2-灵敏拿量配置的校准因子
     * @return
     */
    public CalibrateParams getCalibrateParams(Long slotId, Integer paramsType) {
        // 12.1 注释
        if (slotId == null) {
            slotId = -1L;
        }
        CalibrateParams param;
        if (paramsType == 1) {
            param = AdSlotCalParams.get(slotId);
            if (param == null) {
                CalibrateParams backUpParam = new CalibrateParams();
                AdSlotCalParams.put(slotId, backUpParam);
                return backUpParam;
            }
        }
        else {
            param = AdSlotSenCalParams.get(slotId);
            if (param == null) {
                CalibrateParams backUpParam = new CalibrateParams();
                AdSlotSenCalParams.put(slotId, backUpParam);
                return backUpParam;
            }
        }
        return param;
    }

}
