package cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 强定向媒体探索的配置项，支持热更新
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class STEParams {

    // 数据置信最小维度上统计CVR的阈值 => 用于辅助判断是走哪套扶持参数
    private Double minDimStatsCvrThreshold = 0.01;

    // 数据置信最小维度上统计CVR大于设定的阈值
    private Integer clickConfidenceThreshold = 5000;       // 数据充分阈值(点击数，用于辅助判断数据置信的最小维度)
    private Integer sepStageThreshold = 300;               // 冷启动和起量两阶段的划分阈值
    private Integer coldStartThreshold1 = 50;              // 冷启动阶段阈值1
    private Integer coldStartThreshold2 = 100;             // 冷启动阶段阈值2
    private Integer coldStartThreshold3 = 150;             // 冷启动阶段阈值3
    private Integer exposeConfidenceThreshold2 = 600;     // 数据充分阈值(曝光数，用于辅助判断是否用f(曝光次数加权))

    // 数据置信最小维度上统计CVR小于设定的阈值 => 参数与上个块中相同
    private Integer clickConfidenceThresholdSet2 = 20000;
    private Integer sepStageThresholdSet2 = 1200;
    private Integer coldStartThresholdSet4 = 200;
    private Integer coldStartThresholdSet5 = 400;
    private Integer coldStartThresholdSet6 = 600;
    private Integer exposeConfidenceThresholdSet5 = 2000;

    // 因子上限设置
    private Double exposureUpperBound1 = 1.21;                   // 第一套系数曝光加权因子上限
    private Double exposureK1 = -3.5 * Math.pow(10, -4);         // 第一套系数曝光加权因子函数的斜率
    private Double exposureUpperBound2 = 1.20;                  // 第二套系数曝光加权因子上限
    private Double exposureK2 = -1 * Math.pow(10, -4);          // 第二套系数曝光加权因子函数的斜率

    // 衰减函数相关参数（candis中扶持因子随序衰减）
    private double alpha = 0.6;
    private double beta = 1.1;
    private double bias = 0.0;

}
