package cn.com.duiba.nezha.alg.alg.adxhd.model;

import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.Map;


@Data
public class AHModel {
    private static final Logger logger = LoggerFactory.getLogger(AHModel.class);

    public static void main(String[] args) {
        System.out.println("test");
    }

    /**
     * ctr模型
     */
    private DeepModelV2 ctrCodeModel;    // 点击模型，编码器
    private LocalTFModelV2 ctrTFModel;  // 点击模型，TF模型

    /**
     * cvr模型
     */
    private DeepModelV2 cvrCodeModel;    // 转化模型，编码器
    private LocalTFModelV2 cvrTFModel;   // 转化模型，TF模型


    public <T> Map<T, Double> predictCtr(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<T, Double> ret;
            ret = ctrCodeModel.predictWithLocalTFV2(featureMap, ctrTFModel);
            return ret;
        } catch (Exception e) {
            logger.error("AHModel.predictCtr error{} ctrModel{}", e, ctrCodeModel.getModelId());
        }
        return Collections.emptyMap();
    }

    public <T> Map<T, Double> predictCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<T, Double> ret;
            ret = cvrCodeModel.predictWithLocalTFV2(featureMap, cvrTFModel);
            return ret;
        } catch (Exception e) {
            logger.error("AHModel.predictCvr error{} cvrModel{}", e, cvrCodeModel.getModelId());
        }
        return Collections.emptyMap();
    }

}