package cn.com.duiba.nezha.alg.alg.adxhd.parse;

import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.*;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.dmp.*;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSONObject;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class AHDeviceFeatureParse extends BaseParse {


    public static Map<String, String> parse(DmpFeatureDto dmpFeatureDto, TBDmpAppPackageDiDto appPackageDiDto) throws Exception {
        Map<String, String> retMap = new HashMap<>(64);


        if (dmpFeatureDto == null) {
            return retMap;
        }

        //DMP用户标签（只包含真实设备号）
        Map<String, String> labelDtoMap = parseTBDeviceLabelDiDto(dmpFeatureDto.getLabelDto());
        retMap.putAll(labelDtoMap);

        //实时特征（真实设备号+虚拟设备号）
        Map<String, String> featureOnlineDtoMap = parseTBDeviceFeatureOnlineDiDto(dmpFeatureDto.getFeatureOnlineDto());
        retMap.putAll(featureOnlineDtoMap);

        //离线特征-最近7天（真实设备号+虚拟设备号）
        Map<String, String> featureOffline7dDtoMap = parseTBDeviceFeatureOffline7dDiDto(dmpFeatureDto.getFeatureOffline7dDto());
        retMap.putAll(featureOffline7dDtoMap);

        //离线特征-最近30天（只包含真实设备号）
        Map<String, String> featureOffline30dDtoMap = parseTBDeviceFeatureOffline30dDiDto(dmpFeatureDto.getFeatureOffline30dDto());
        retMap.putAll(featureOffline30dDtoMap);
        //离线特征-最近180天（只包含真实设备号）
        Map<String, String> featureOffline180dDtoMap = parseTBDeviceFeatureOffline180dDiDto(dmpFeatureDto.getFeatureOffline180dDto());
        retMap.putAll(featureOffline180dDtoMap);

        //全局特征-媒体包数据
        Map<String, String> appPackageDtoMap = parseAppPackageDto(appPackageDiDto);
        retMap.putAll(appPackageDtoMap);

        return retMap;

    }

    private static Map<String, String> parseTBDeviceLabelDiDto(TBDeviceLabelDiDto data) throws Exception {
        Map<String, String> retMap = new HashMap<>(24);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1001", data.getT1001());//性别 多渠道融合
        putMap(retMap, "fd_1002", data.getT1002());//年龄
        putMap(retMap, "fd_1003", data.getT1003());//婚育情况
        putMap(retMap, "fd_1005", data.getT1005());//用户安装的AppList
        putMap(retMap, "fd_1006", data.getT1006());//App一级分类
        putMap(retMap, "fd_1007", data.getT1007());//App二级分类
        putMap(retMap, "fd_1008", data.getT1008());//百度新版标签
        putMap(retMap, "fd_1010", data.getT1010());//手机号码归属的省份,例如 "浙江"
        putMap(retMap, "fd_1011", data.getT1011());//手机号码归属的城市,例如 "杭州"

        // 新增两个加工特征，用户安装AppList是否包含淘宝、用户按转AppList是否包含支付宝
        if (data.getT1005() == null) {
            putMap(retMap, "fd_1014", 1); //用户安装的AppList中是否包含淘宝, 1表示AppList为空
            putMap(retMap, "fd_1015", 1); //用户安装的AppList中是否包含支付宝, 1表示AppList为空
        } else {
            // AppList中包含淘宝App
            if (data.getT1005().contains("1")) {
                putMap(retMap, "fd_1014", 2); // 用户安装的AppList中包含淘宝App
            } else {
                putMap(retMap, "fd_1014", 3); // 用户安装的AppList中不包含淘宝App
            }

            if (data.getT1005().contains("10")) {
                putMap(retMap, "fd_1015", 2); // 用户安装的AppList中包含支付宝App
            } else {
                putMap(retMap, "fd_1015", 3); //用户安装的AppList中不包含支付宝App
            }
            
        }
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOnlineDiDto(TBDeviceFeatureOnlineDiDto data) throws Exception {
        Map<String, String> retMap = new HashMap<>(16);

        if (data == null) {
            return retMap;
        }
        putMap(retMap, "fd_1103", log2p(data.getT1103()));//adx曝光PV
        putMap(retMap, "fd_1104", log2p(data.getT1104()));//adx入口素材点击PV
        putMap(retMap, "fd_1105", log2p(data.getT1105()));//广告位访问PV
        putMap(retMap, "fd_1107", log2p(data.getT1107()));//券曝光PV
        putMap(retMap, "fd_1108", log2p(data.getT1108()));//券有效点击PV

        putMap(retMap, "fd_1116", data.getT1116());//券是否点击 0:没有点击 1:点击 (最新订单)


        Long s = parseTimeDiffBucket(data.getT1124());
        putMap(retMap, "fd_1123", bucket(parseTimeDiffBucket(data.getT1123()), timeDiffBucket));//最近1次adx曝光时间，unix时间戳(秒)
        putMap(retMap, "fd_1124", bucket(parseTimeDiffBucket(data.getT1124()), timeDiffBucket)); //最近1次adx点击时间，unix时间戳(秒)
        putMap(retMap, "fd_1125", log2p(data.getT1125())); //广告券-目标转化PV
        putMap(retMap, "fd_1126", bucket(data.getT1126(), costBucket)); //广告券-理论消耗
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline7dDiDto(TBDeviceFeatureOffline7dDiDto data) throws Exception {
        Map<String, String> retMap = new HashMap<>(16);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1703", log2p(data.getT1703()));//adx曝光PV
        putMap(retMap, "fd_1704", log2p(data.getT1704()));//adx入口素材点击PV
        putMap(retMap, "fd_1705", log2p(data.getT1705()));//广告位访问PV
        putMap(retMap, "fd_1707", log2p(data.getT1707()));//券曝光PV
        putMap(retMap, "fd_1708", log2p(data.getT1708()));//券有效点击PV


        putMap(retMap, "fd_1712", log2p(data.getT1712())); //广告券-目标转化PV
        putMap(retMap, "fd_1713", bucket(data.getT1713(), costBucket)); //广告券-理论消耗

        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline30dDiDto(TBDeviceFeatureOffline30dDiDto data) throws Exception {
        Map<String, String> retMap = new HashMap<>(16);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1803", log2p(data.getT1803()));//adx曝光PV
        putMap(retMap, "fd_1804", log2p(data.getT1804()));//adx入口素材点击PV
        putMap(retMap, "fd_1805", log2p(data.getT1805()));//广告位访问PV
        putMap(retMap, "fd_1807", log2p(data.getT1807()));//券曝光PV
        putMap(retMap, "fd_1808", log2p(data.getT1808()));//券有效点击PV

        putMap(retMap, "fd_1813", log2p(data.getT1813())); //被启航拉活次数
        putMap(retMap, "fd_1817", log2p(data.getT1817())); //被美团拉活次数
        putMap(retMap, "fd_1818", data.getT1818()); // 启航返回的素材标题列表


        putMap(retMap, "fd_1819", log2p(data.getT1819())); //广告券-目标转化PV
        putMap(retMap, "fd_1820", bucket(data.getT1820(), costBucket)); //广告券-理论消耗

        return retMap;
    }


    private static Map<String, String> parseTBDeviceFeatureOffline180dDiDto(TBDeviceFeatureOffline180dDiDto data) throws Exception {
        Map<String, String> retMap = new HashMap<>(16);

        if (data == null) {
            return retMap;
        }

        putMap(retMap, "fd_1303", log2p(data.getT1303()));//adx曝光PV
        putMap(retMap, "fd_1304", log2p(data.getT1304()));//adx入口素材点击PV
        putMap(retMap, "fd_1305", log2p(data.getT1305()));//广告位访问PV
        putMap(retMap, "fd_1307", log2p(data.getT1307()));//券曝光PV
        putMap(retMap, "fd_1308", log2p(data.getT1308()));//券有效点击PV


        putMap(retMap, "fd_1312", log2p(data.getT1312())); //广告券-目标转化PV
        putMap(retMap, "fd_1313", bucket(data.getT1313(), costBucket)); //广告券-理论消耗

        return retMap;
    }

    public static Map<String, String> parseAppPackageDto(TBDmpAppPackageDiDto data) throws Exception {
        Map<String, String> retMap = new HashMap<>(10);

        if (data == null) {
            return retMap;
        }
        putMap(retMap, "fd_1605", log2p(data.getT1605()));//adx曝光PV
        putMap(retMap, "fd_1606", log2p(data.getT1606()));//adx入口素材点击PV
        putMap(retMap, "fd_1607", log2p(data.getT1607()));//广告位访问PV
        putMap(retMap, "fd_1608", log2p(data.getT1608()));//券曝光PV
        putMap(retMap, "fd_1609", log2p(data.getT1609()));//券有效点击PV


        putMap(retMap, "fd_1610", log2p(data.getT1610())); //广告券-目标转化PV
        putMap(retMap, "fd_1611", bucket(data.getT1611(), costBucket)); //广告券-理论消耗


        return retMap;
    }


}
