package cn.com.duiba.nezha.alg.alg.adxhd.stat;

import cn.com.duiba.nezha.alg.alg.adxhd.parse.AHStatParse;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import lombok.Data;

@Data
public class AHStatDto {
    private static final long serialVersionUID = 4481088624505592801L;


    private Long ideaId;


    private String appPkgName;

    /**
     * 近20分钟统计数据
     */
    private AHSubStatDto last20MinStat;


    /**
     * 近1小时统计数据
     */
    private AHSubStatDto last1HourStat;

    /**
     * 近3小时统计数据
     */
    private AHSubStatDto last3HourStat;

    /**
     * 近1天统计数据
     */
    private AHSubStatDto last1DayStat;


    /**
     * 近3天统计数据
     */
    private AHSubStatDto last3DayStat;


    /**
     * 计算结果 缓存
     */
    private AHStatCalcDto ahStatCalculateDo;


    /**
     * 获取计算结果
     *
     * @return
     */
    public AHStatCalcDto initAHStatCalcDto(Double targetRoi) throws Exception{

        if (AssertUtil.isEmpty(ahStatCalculateDo)) {
            this.ahStatCalculateDo = AHStatParse.parse(this,targetRoi);
        }

        return this.ahStatCalculateDo;
    }


}
