package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.common.util.MathUtil;

import java.util.*;

public class SimpleTest {

    /**
     * 调权因子加权函数
     *
     */
    public static List<Double> functionOfRectifyFac(int size) {
        List<Double> res = new ArrayList<>();
        double weight = 1.0;
        double rankUpperBound = 1.2;

        if (rankUpperBound <= 1.0) {
            for (int i=0; i<size; i++) {
                res.add(1.0);
            }
        }else {
            double inflectionPoint1 = rankUpperBound;
//            double inflectionPoint2 = rankUpperBound - (rankUpperBound - 1.0) * 0.6;
            double inflectionPoint2 = 0.4 * rankUpperBound + 0.6;
            Map<String, Double> KBMap1 = calculateKAndB(0, (int) (0.1 * size), inflectionPoint1, inflectionPoint2);     // 给予top10部分更大的斜率，让头部的加权因子有较快衰减==>top1的加权因子远大于其余部分，让其更易曝光
            Map<String, Double> KBMap2 = calculateKAndB((int) (0.1 * size), (int) (0.2 * size), inflectionPoint2, 1.0);
            double k1 = KBMap1.get("K");
            double k2 = KBMap2.get("K");
            double b1 = KBMap1.get("B");
            double b2 = KBMap1.get("B");

            for (int i=0; i<size; i++) {
                if (i <= (int) (0.1 * size)) {
                    weight = k1 * i + b1;
                }else if((int) (0.1 * size) < i && i <= (int) (0.2 * size)) {
                    weight = k2 * i + b2;
                }else { weight = 1.0; }

                weight = Math.round(weight * 1e6) / 1e6;
                res.add(Math.max(weight, 1.0));
            }
        }

        return res;
    }



    /**
     * 调权因子加权函数斜率及偏置的计算
     */
    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        Map<String, Double> res = new HashMap<>();

        double k = MathUtil.division(y1 - y0, x1 - x0, 6);
        double b = y0 - k * x0;
        res.put("K", k);
        res.put("B", b);

        return res;
    }

    public static void main(String[] args) {
//        List<Double> res = new ArrayList<>();
//        int size = 10;
//        res = functionOfRectifyFac(size);
//        System.out.println(res);
//        System.out.println((int) (0.2 * 10));
        String str = "f1001@@10,,,f1002@@20,,,f1003@@30";
        String[] res = str.split(",,,");
        System.out.println(Arrays.toString(res));

     }
}


