package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import lombok.Data;

import java.util.List;
import java.util.Optional;


@Data
public class IdeaUnitDo {

    /**
     * 创意素材ID
     */
    private Long ideaUnitId;

    /**
     * 创意计划ID
     */
    private Long adIdeaId;

    /**
     * 素材ID
     */
    private List<Long> materialIds;

    /**
     * 创意比例区间
     */
    private Integer ratioType;

    /**
     * 创意素材类型
     */
    private Long type;

    /**
     * 出价
     */
    private Double price;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * ctr
     */
    private Double ctr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 每pv发券
     */
    private Double launchPv;

    /**
     * arpu
     */
    private Double arpu;

    /**
     * 预估arpu
     */
    private Double preArpu;

    /**
     * 创意统计数据
     */
    private AdxStatsDo adxStatsDo;

    /**
     * 统计广告ecpm(广告消耗/adx曝光*1000)
     */
    private Double adEcpm;

    /**
     * 算法判断--计划创意来源池：true-冷启动池，false-优选池
     */
    private Boolean isNew = true;

    /**
     * 近7d曝光次数(包含当天)
     */
    private Long lt7DExp;

    /**
     * 近7d广告消耗/分(包含当天)
     */
    private Long lt7DAdCost;

    /**
     * 当天曝光次数
     */
    private Long lt1DExp;

    /**
     * 当天广告消耗/分
     */
    private Long lt1DAdCost;


    public static Double getStatEcpm(IdeaUnitDo ideaUnitDo){
        Double ret = null;
        if(ideaUnitDo != null) {
            AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
            AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
            ret = AdxIndexStatDo.getStatEcpm(last1DayStat);
        }
        if(ret == null) {ret = 10000.0;}
        return ret;

    }



    /**
     * 判断创意来源池：true-冷启动池，false-优选池
     */
    public static boolean getNewStatus(IdeaUnitDo ideaUnitDo){

        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());

        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last7DayStat = adxStatsDo.getLast7DayStat();
        Long last1DayExp = AdxIndexStatDo.getExpCnt(last1DayStat);
        Long last7DayExp = AdxIndexStatDo.getExpCnt(last7DayStat);
        Long last1DayAdxCost = AdxIndexStatDo.getAdxCost(last1DayStat);
        Long last7DayAdxCost = AdxIndexStatDo.getAdxCost(last7DayStat);

        if (last7DayAdxCost > 10000L || last7DayExp > 5000L) {
            return false;
        } if (last1DayAdxCost > 5000L || last1DayExp > 2000L) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * 判断创意来源池：true-冷启动池，false-优选池
     *
     * @param ideaUnitDto 创意维度 当天/近3天/近7天
     * @param resoDto 资源位+创意维度 当天/近3天/近7天
     *
     */
    public static boolean getNewStatus(AdxStatsDo ideaUnitDto, AdxStatsDo resoDto){

        ideaUnitDto = Optional.ofNullable(ideaUnitDto).orElse(new AdxStatsDo());
        resoDto = Optional.ofNullable(resoDto).orElse(new AdxStatsDo());

        AdxIndexStatDo ideaUnit7DayStat = ideaUnitDto.getLast7DayStat();
        AdxIndexStatDo reso7DayStat = resoDto.getLast7DayStat();
        Long ideaUnit7DayExp = AdxIndexStatDo.getExpCnt(ideaUnit7DayStat);
        Long ideaUnit7DayAdxCost = AdxIndexStatDo.getAdxCost(ideaUnit7DayStat);
        Long reso7DayExp = AdxIndexStatDo.getExpCnt(reso7DayStat);
        Long reso7DayAdxCost = AdxIndexStatDo.getAdxCost(reso7DayStat);

        if (ideaUnit7DayExp > 5000L || ideaUnit7DayAdxCost > 5000L) {
            return false;
        } if (reso7DayExp > 3000L || reso7DayAdxCost > 3000L) {
            return false;
        } else {
            return true;
        }
    }


    /**
     * 计算曝光次数，选择时间维度timeType
     */
    public static Long countExpCnt(IdeaUnitDo ideaUnitDo, int timeType){
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        return AdxStatsDo.getExpCnt(adxStatsDo, timeType);
    }


    /**
     * 计算广告消耗/分，选择时间维度timeType
     */
    public static Long countAdCost(IdeaUnitDo ideaUnitDo, int timeType){
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        return AdxStatsDo.getAdCost(adxStatsDo, timeType);
    }



    /**
     * 融合计算统计广告ecpm(广告消耗/adx曝光*1000)
     */
    public static Double mergeStatAdEcpm(IdeaUnitDo ideaUnitDo, long limit, int mergeType){

        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());

        return AdxStatsDo.mergeStatAdEcpm(adxStatsDo, limit, mergeType);
    }




}
