package cn.com.duiba.nezha.alg.alg.adxhd.dto;

import cn.com.duiba.nezha.alg.alg.adxhd.enums.AHBidType;
import cn.com.duiba.nezha.alg.alg.adxhd.enums.ConvertType;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatCalcDto;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatDto;
import lombok.Data;


@Data
public class AHIdeaBidReqDto {

    /**
     * 创意计划ID
     */
    public Long ideaId;

    /**
     * 资源位ID
     */
    private Long resId;

    /**
     * 推广组ID
     */
    private Long groupId;


    /**
     * 目标出价 ，单位：元
     */
    private Double targetPrice;
    /**
     * 目标roi
     */
    private Double roi;

    /**
     * 出价计费方式：1-算法cpm、2-算法ocpm、3-算法ocpc
     */
    private AHBidType ahBidType;

    /**
     * 转化类型：1-入口素材点击，2-算法目标转化
     */
    private ConvertType convertType;

    /**
     * 创意素材ID
     */
//    private Long materialIds;//暂不提供


    /**
     * 创意，统计数据
     * 备注：大数据计算，读取，缓存5分钟
     */
    private AHStatCalcDto ideaStatCalcDto;

    /**
     * 创意+媒体包，统计数据
     * 备注：大数据计算，读取，缓存5分钟
     */
    private AHStatCalcDto ideaPkgStatCalcDto;

}

