package cn.com.duiba.nezha.alg.alg.adxhd.dto;

import cn.com.duiba.nezha.alg.alg.adxhd.enums.AHBidType;
import cn.com.duiba.nezha.alg.alg.adxhd.enums.ConvertType;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatCalcDto;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

import java.util.Map;
import java.util.Optional;

@Data
public class AHIdeaBidResDto {

    /**
     * 创意计划ID
     */
    public Long ideaId;

    /**
     * 出价计费方式：1-other其他互动出价类型、2-算法ocpm、3-算法ocpc
     */
    private AHBidType ahBidType;

    /**
     * 出价
     * cpc计费：分/单次点击
     * cpm计费：分/千次曝光
     * <p>
     * 备注：部分情况下返回空，工程按出价下限出（需采样告警）
     * 1、当出价异常
     * 2、模型和统计都获取失败
     */
    /**
     * 算法出价，单位：分
     */
    private Double algPrice;
    /**
     * 目标出价 ，单位：分
     */
    private Double targetPrice;
    /**
     * 转化类型：1-入口素材点击，2-算法目标转化
     */
    private ConvertType convertType;


    /**
     * 预估ctr
     */
    public Double pCtr;

    /**
     * 预估cvr
     */
    public Double pCvr;

    /**
     * 统计ctr
     */
    public Double sCtr;

    /**
     * 统计cvr
     */
    public Double sCvr;


    /**
     * 融合ctr
     */
    public Double ctr;

    /**
     * 融合ctr
     */
    public Double cvr;

    /**
     * roi成本控制因子
     */
    public Double cFactor;

    /**
     * 预估ecpm
     */
    public Double ecpm;

    /**
     * 创意 统计参数
     */
    public AHStatCalcDto ideaStatDoStatCalcDo;

    /**
     * 创意+媒体包 统计参数
     */
    public AHStatCalcDto ideaPkgStatDoStatCalcDo;

    /**
     * 特征Map
     */
    public Map<String, String> featureMap;


    /**
     * @param ideaBidReqDto
     * @param featureMap
     * @param pCtr
     * @param pCvr
     */
    public void updatePrice(AHIdeaBidReqDto ideaBidReqDto, Map<String, String> featureMap, Double pCtr, Double pCvr) throws Exception {

        this.featureMap = featureMap;

        this.ideaStatDoStatCalcDo = Optional.ofNullable(ideaBidReqDto.getIdeaStatCalcDto()).orElse(new AHStatCalcDto());
        this.ideaPkgStatDoStatCalcDo = Optional.ofNullable(ideaBidReqDto.getIdeaPkgStatCalcDto()).orElse(new AHStatCalcDto());

        this.pCtr = pCtr;
        this.pCvr = pCvr;


        Double cFactor1 = ideaPkgStatDoStatCalcDo.getCFactor();//创意+媒体包维度
        Double sCtr1 = ideaPkgStatDoStatCalcDo.getSCtr();
        Double sCvr1 = ideaPkgStatDoStatCalcDo.getSCvr();

        Double cFactor2 = ideaStatDoStatCalcDo.getCFactor();//创意维度
        Double sCtr2 = ideaStatDoStatCalcDo.getSCtr();
        Double sCvr2 = ideaStatDoStatCalcDo.getSCvr();


        /**
         * 计算融合CTR、CVR、cFactor
         */
        this.sCtr = sCtr1 != null ? sCtr1 : sCtr2;
        this.sCvr = sCvr1 != null ? sCvr1 : sCvr2;
        this.cFactor = cFactor1 != null ? cFactor1 : cFactor2;
        // 成本控制因子 上下限 设为 [0.7, 1.2]
        this.cFactor = Math.max(Math.min(this.cFactor, 0.8), 1.1);
        this.ctr = getMergeCxr(pCtr, sCtr, 0.5, 0.5, 2.0);
        this.cvr = getMergeCxr(pCvr, sCvr, 0.5, 0.5, 2.0);

        /**
         * 算法ocpm出价
         * 单位：分/千次曝光
         */
        if (AHBidType.ALG_OCPM.equals(ahBidType)) {
            if (AssertUtil.isAllNotEmpty(ctr, cvr, this.targetPrice, this.convertType)) {
                if (ConvertType.ALG_CLICK.equals(convertType)) {
                    this.algPrice = DataUtil.formatDouble(ctr * this.targetPrice * 1000 * this.cFactor,5);
                    this.ecpm = DataUtil.formatDouble(ctr * this.targetPrice * 1000,5);
                }
                else if (ConvertType.ALG_TARGET.equals(convertType)) {
                    this.algPrice = DataUtil.formatDouble(ctr * cvr * this.targetPrice * 1000 * this.cFactor,5);
                    this.ecpm = DataUtil.formatDouble(ctr * cvr * this.targetPrice * 1000,5);
                }
            }
        }
        /**
         * 算法ocpc出价
         * 单位：分/次点击
         */
        if (AHBidType.ALG_OCPC.equals(ahBidType)) {
            if (AssertUtil.isAllNotEmpty(ctr, cvr, this.targetPrice, this.convertType)) {
                if (ConvertType.ALG_CLICK.equals(convertType)) {
                    this.algPrice = DataUtil.formatDouble(this.targetPrice * this.cFactor,5);
                    this.ecpm = DataUtil.formatDouble(ctr * this.targetPrice * 1000,5);
                }
                else if (ConvertType.ALG_TARGET.equals(convertType)) {
                    this.algPrice = DataUtil.formatDouble(cvr * this.targetPrice * this.cFactor,5);
                    this.ecpm = DataUtil.formatDouble(ctr * cvr * this.targetPrice * 1000,5);
                }
            }

        }

    }

    public static Double getMergeCxr(Double pCxr, Double sCxr, double pW, double lowerW, double upperW) {
        Double ret = 0.0;
        if (pCxr == null) {
            return sCxr;
        }
        if (sCxr == null) {
            return pCxr;
        }
        ret = pW * pCxr + (1 - pW) * sCxr;

        ret = DataUtil.formatDouble(ret, 5);

        // upperW 为 2.0 ，即预估值不能大于统计值的3倍
        if (ret > upperW * sCxr) {
            ret = upperW * sCxr;
        }
        // lowerW 为 0.5， 即预估值不能小于0 ，实际为 (0.5 - 0.5) * sCxr
        if (ret < lowerW * sCxr) {
            ret = lowerW * sCxr;
        }
        return ret;
    }

}
