package cn.com.duiba.nezha.alg.alg.adxhd.parse;

import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHContextFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.dmp.AHDmpFeatureDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class AHContextFeatureParse extends BaseParse {

    /**
     * @param cf adx上下文特征解析
     * @return
     */
    public static Map<String, String> parse(AHContextFeatureDto cf) throws Exception{
        Map<String, String> retMap = new HashMap<>(32);

        if (AssertUtil.isEmpty(cf)) {
            return retMap;
        }

        putMap(retMap, "fac_0001", cf.getGroupId()); // 推广组ID
        putMap(retMap, "fac_0002", cf.getResourceId());  // 资源位ID

        putMap(retMap, "fac_0003", cf.getExtAppId());  // 联盟媒体id
        putMap(retMap, "fac_0004", cf.getExtSlotId());  // 联盟广告位id

        putMap(retMap, "fac_0005", cf.getTagId());  // 竞价广告位ID
        putMap(retMap, "fac_0006", cf.getAppPkgName());  // 媒体包

        putMap(retMap, "fac_0007", cf.getSlotId());  // 内部广告位id
        putMap(retMap, "fac_0008", cf.getFloor());  // 底价

        putMap(retMap, "fac_0009", cf.getUa());  // ua
        putMap(retMap, "fac_0010", cf.getIp());  // ip

        putMap(retMap, "fac_0011", cf.getOs());  // 操作系统 ios、 android、pc
        putMap(retMap, "fac_0012", cf.getOsVersion());  // 操作系统版本

        putMap(retMap, "fac_0013", cf.getMake());  // 设备厂商
        putMap(retMap, "fac_0014", cf.getBrand());  // 设备品牌

        putMap(retMap, "fac_0015", cf.getModel());  // 设备型号
        putMap(retMap, "fac_0016", cf.getCarrier());  // 运营商
        putMap(retMap, "fac_0017", cf.getConnectionType());  // 网络链接类型

        putMap(retMap, "fac_0018", cf.getCity());  // 城市
        putMap(retMap, "fac_0019", cf.getProvince());  // 省份

        putMap(retMap, "fac_0020", cf.getAge());  // 年龄（选填）
        putMap(retMap, "fac_0021", cf.getGender());  // 性别（选填）

        LocalDateTime localDate = LocalDateTime.now();

        putMap(retMap, "fac_0022", DataUtil.Integer2String(localDate.getHour()));  // 小时
        putMap(retMap, "fac_0023", DataUtil.Integer2String(localDate.getDayOfWeek().getValue()));  // 周几

        return retMap;
    }
}
