package cn.com.duiba.nezha.alg.alg.adxhd.parse;

import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.TBDmpAppPackageDiDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHContextFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidReqDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.dmp.AHDmpFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatCalcDto;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AHFeatureParse extends BaseParse {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(AHFeatureParse.class);
    /**
     *
     * @param ideaBidReqDtos
     * @param contextFeatureDto
     * @param dmpFeatureDto
     * @param appPackageDiDto
     * @return
     * @throws Exception
     */
    public static Map<Long, FeatureMapDo> generateFeatureMap(List<AHIdeaBidReqDto> ideaBidReqDtos, AHContextFeatureDto contextFeatureDto, DmpFeatureDto dmpFeatureDto, TBDmpAppPackageDiDto appPackageDiDto) throws Exception {

        Map<Long, FeatureMapDo> ret = new HashMap<>();

        /**
         * step1 静态特征解析
         */

        Map<String, String> staticFeatureMap = generateFeatureMapStatic(contextFeatureDto, dmpFeatureDto, appPackageDiDto);

        /**
         * step2 动态特征解析
         */

        for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {

            Map<String, String> dynamicFeatureMap = generateFeatureMapDynamic(ideaBidReqDto);

            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);

            ret.put(ideaBidReqDto.getIdeaId(), featureMapDo);
        }

        return ret;
    }


    /**
     * @param contextFeatureDto
     * @param dmpFeatureDto
     * @return
     */
    private static Map<String, String> generateFeatureMapStatic(AHContextFeatureDto contextFeatureDto, DmpFeatureDto dmpFeatureDto, TBDmpAppPackageDiDto appPackageDiDto) throws Exception{

        Map<String, String> retMap = new HashMap<>(128);


        Map<String, String> deviceFeatureMap = AHDeviceFeatureParse.parse(dmpFeatureDto, appPackageDiDto);//设备DMP特征解析

        retMap.putAll(deviceFeatureMap);

        Map<String, String> contextFeatureMap = AHContextFeatureParse.parse(contextFeatureDto);//上下文特征解析

        retMap.putAll(contextFeatureMap);

        return retMap;
    }

    /**
     * @param ideaBidReqDto 请求参数
     * @return
     */
    private static Map<String, String> generateFeatureMapDynamic(AHIdeaBidReqDto ideaBidReqDto) throws Exception{
        Map<String, String> retMap = new HashMap<>(256);


        putMap(retMap, "faa_1001", ideaBidReqDto.getIdeaId());//CTR

        AHStatCalcDto ideaStatDoStatCalcDo = ideaBidReqDto.getIdeaStatCalcDto();

        try {

            if (ideaStatDoStatCalcDo != null && ideaStatDoStatCalcDo.getFeatureMap() != null) {
                retMap.putAll(ideaStatDoStatCalcDo.getFeatureMap());
            }

            AHStatCalcDto ideaPkgStatDoStatCalcDo = ideaBidReqDto.getIdeaPkgStatCalcDto();
            if (ideaPkgStatDoStatCalcDo != null && ideaPkgStatDoStatCalcDo.getFeatureMap() != null) {
                retMap.putAll(ideaPkgStatDoStatCalcDo.getFeatureMap());
            }
        } catch (Exception e) {
            logger.warn("generateFeatureMapDynamic", e);
//            System.out.println(e);
        }
        return retMap;
    }


}
