package cn.com.duiba.nezha.alg.alg.adxhd.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseParse {
    public static Number[] timeDiffBucket = {0, 1, 5, 10, 30, 60, 60 * 3, 60 * 24};

    public static Number[] ctrBucket = {0, 0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7};
    public static Number[] cvrBucket = {0, 0.0001, 0.001, 0.005, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.2};
    public static Number[] uvCostBucket = {0, 1, 3, 5, 7, 10, 20, 30, 40, 50, 100, 200, 300, 400};
    public static Number[] costBucket = {100, 500, 1000, 5000, 10000, 20000, 50000};

    public static Long log2p(Long value) {

        if (value == null || value < 0) {
            return null;
        } else if (value < 6) {
            return value;
        } else {
            return Math.min(Math.round(Math.log(value + 1) / Math.log(2)) + 3, 12);
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, T value) throws Exception {

        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Set<String> value) throws Exception {

        if (value != null) {
            List<String> list2 = new ArrayList<String>();
            list2.addAll(value);
            map.put(key, String.join(",", list2));
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Map<String, T> value) throws Exception {

        if (value != null) {
            List<String> list2 = new ArrayList<String>();
            list2.addAll(value.keySet());
            map.put(key, String.join(",", list2));
        }
    }


    public static <T> void putMap(Map<String, String> map, String key, List<String> value) throws Exception {

        if (value != null) {
            map.put(key, String.join(",", value));
        }
    }

    public static Long parseTimeDiffBucket(Long timestamp1) {

        if (timestamp1 == null) {
            return null;
        }
        long timestamp2 = System.currentTimeMillis();

        long timeDiff = (timestamp2 - timestamp1) / (60000);
        return timeDiff;


    }

    /**
     * 分箱
     *
     * @param value
     * @param bucketList
     * @param <V1>
     * @param <V2>
     * @return
     */
    public static <V1 extends Number, V2 extends Number> String bucket(V1 value, V2[] bucketList) throws Exception {
        if (value == null || bucketList == null || bucketList.length == 0) {
            return null;
        }
        int ret = bucketList.length;
        for (int i = 0; i < bucketList.length; i++) {
            Number bound = bucketList[i];
            if (value.doubleValue() <= bound.doubleValue()) {
                ret = i;
                break;
            }
        }
        return DataUtil.Integer2String(ret);
    }
}
