package cn.com.duiba.nezha.alg.alg.adxhd.rec;


import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.TBDmpAppPackageDiDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHContextFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidReqDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidResDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.dmp.AHDmpFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.enums.AHBidType;
import cn.com.duiba.nezha.alg.alg.adxhd.model.AHModel;
import cn.com.duiba.nezha.alg.alg.adxhd.model.AHOnnxModel;
import cn.com.duiba.nezha.alg.alg.adxhd.parse.AHFeatureParse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class AHBid {
    private static final Logger logger = LoggerFactory.getLogger(AHBid.class);

    private static final Map<Long, Double> defaultMap = new HashMap<>();

    /**
     *
     * @param ideaBidReqDtos 创意计划集合
     * @param contextFeatureDto 上下文信息：实时请求
     * @param dmpFeatureDto DMP数据：实时请求
     * @param ahOnnxModel 模型：缓存10分钟
     * @param appPackageDiDto 媒体包特征
     * @return
     */
    public static List<AHIdeaBidResDto> bidding(List<AHIdeaBidReqDto> ideaBidReqDtos
            , AHContextFeatureDto contextFeatureDto
            , DmpFeatureDto dmpFeatureDto
            , AHOnnxModel ahOnnxModel
            , TBDmpAppPackageDiDto appPackageDiDto
    ) {
        List<AHIdeaBidResDto> adxBidRets = new ArrayList<>();

        /**
         * 异常判断
         */

        if (AssertUtil.isEmpty(ideaBidReqDtos)) {
            logger.error("AHBid.bidding params error, ideaBidReqDtos is empty");
            return adxBidRets;
        }

        try {
            /**
             * step1：特征解析
             */
            Map<Long, FeatureMapDo> featureMap = AHFeatureParse.generateFeatureMap(ideaBidReqDtos, contextFeatureDto, dmpFeatureDto, appPackageDiDto);

            /**
             * step1.1: 保留算法出价的特征map, 不预估固定出价的特征map
             */
            Map<Long, FeatureMapDo> algFeatureMap = new HashMap<>();
            for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {
                Long ideaId = ideaBidReqDto.getIdeaId();
                if ((ideaBidReqDto.getAhBidType() != null) && !AHBidType.OTHER.equals(ideaBidReqDto.getAhBidType())) {
                    algFeatureMap.put(ideaBidReqDto.getIdeaId(), featureMap.get(ideaId));
                }
            }

            /**
             * step2：模型预估
             */

            Map<Long, Double> pCtrMap = defaultMap;
            Map<Long, Double> pCvrMap = defaultMap;

            if (ahOnnxModel!=null && AssertUtil.isAllNotEmpty(ahOnnxModel.getCtrOnnxModel(),ahOnnxModel.getCtrCodeModel(),ahOnnxModel.getCvrOnnxModel(),ahOnnxModel.getCvrCodeModel()) && algFeatureMap.size() > 0) {
                pCtrMap = ahOnnxModel.predictCtr(algFeatureMap);//ctr预估
                pCvrMap = ahOnnxModel.predictCvr(algFeatureMap);//cvr预估

            }

            /**
             * step3：出价
             */


            for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {
                Long ideaId = ideaBidReqDto.getIdeaId();
                Double pCtr = 0.0;
                Double pCvr = 0.0;
                if (pCtrMap != null) {
                    pCtr = pCtrMap.getOrDefault(ideaId, 0.0);
                }
                if (pCvrMap != null) {
                    pCvr = pCvrMap.getOrDefault(ideaId, 0.0);
                }
                FeatureMapDo featureMapDo = featureMap.get(ideaId);

                AHIdeaBidResDto ideaBidResDto = new AHIdeaBidResDto();
                ideaBidResDto.setIdeaId(ideaId);

                ideaBidResDto.setAhBidType(ideaBidReqDto.getAhBidType());
                // 人工固价出价的情况下，targetprice为空
                if (ideaBidReqDto.getTargetPrice() != null) {
                    ideaBidResDto.setTargetPrice(ideaBidReqDto.getTargetPrice() * 100);
                }
                ideaBidResDto.setConvertType(ideaBidReqDto.getConvertType());


                ideaBidResDto.updatePrice(ideaBidReqDto, featureMapDo.getFeatureMap(), pCtr, pCvr);

                adxBidRets.add(ideaBidResDto);

            }

            /**
             * step4：封装返回
             */

            return adxBidRets;

        } catch (Exception e) {
            logger.error("AHBid.bidding error", e);
        }

        return adxBidRets;
    }


    /**
     *
     * @param ideaBidReqDtos 创意计划集合
     * @param contextFeatureDto 上下文信息：实时请求
     * @param dmpFeatureDto DMP数据：实时请求
     * @param ahModel 模型：缓存10分钟
     * @param appPackageDiDto 媒体包特征
     * @return
     */
    public static List<AHIdeaBidResDto> bidding2(List<AHIdeaBidReqDto> ideaBidReqDtos
            , AHContextFeatureDto contextFeatureDto
            , DmpFeatureDto dmpFeatureDto
            , AHModel ahModel
            , TBDmpAppPackageDiDto appPackageDiDto
    ) {
        List<AHIdeaBidResDto> adxBidRets = new ArrayList<>();

        /**
         * 异常判断
         */

        if (AssertUtil.isEmpty(ideaBidReqDtos)) {
            logger.error("AHBid.bidding params error, ideaBidReqDtos is empty");
            return adxBidRets;
        }

        try {
            /**
             * step1：特征解析
             */
            Map<Long, FeatureMapDo> featureMap = AHFeatureParse.generateFeatureMap(ideaBidReqDtos, contextFeatureDto, dmpFeatureDto, appPackageDiDto);

            System.out.println("featureMap="+JSONObject.toJSONString(featureMap));
            /**
             * step2：模型预估
             */

            Map<Long, Double> pCtrMap = defaultMap;
            Map<Long, Double> pCvrMap = defaultMap;

            if (ahModel!=null && AssertUtil.isAllNotEmpty(ahModel.getCtrTFModel(),ahModel.getCtrCodeModel(),ahModel.getCvrTFModel(),ahModel.getCvrCodeModel())) {
                pCtrMap = ahModel.predictCtr(featureMap);//ctr预估
                pCvrMap = ahModel.predictCvr(featureMap);//cvr预估

            }

            /**
             * step3：出价
             */

            for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {
                Long ideaId = ideaBidReqDto.getIdeaId();
                Double pCtr = pCtrMap.get(ideaId);
                Double pCvr = pCvrMap.get(ideaId);
                FeatureMapDo featureMapDo = featureMap.get(ideaId);

                AHIdeaBidResDto ideaBidResDto = new AHIdeaBidResDto();
                ideaBidResDto.setIdeaId(ideaId);

                ideaBidResDto.setAhBidType(ideaBidReqDto.getAhBidType());
                // 人工固价出价的情况下，targetprice为空
                if (ideaBidReqDto.getTargetPrice() != null) {
                    ideaBidResDto.setTargetPrice(ideaBidReqDto.getTargetPrice() * 100);
                }
                ideaBidResDto.setConvertType(ideaBidReqDto.getConvertType());


                ideaBidResDto.updatePrice(ideaBidReqDto, featureMapDo.getFeatureMap(), pCtr, pCvr);

                adxBidRets.add(ideaBidResDto);

            }

            /**
             * step4：封装返回
             */

            return adxBidRets;

        } catch (Exception e) {
            logger.error("AHBid.bidding error", e);
        }

        return adxBidRets;
    }
}
