package cn.com.duiba.nezha.alg.alg.adxhd.stat;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class AHStatCalcDto {
    private static final long serialVersionUID = 4481088624505592801L;


    /**
     * adx竞价成功量级
     */
    private Double weight;
    /**
     * adx竞价成功量级
     */
    private Double adxSucPv;

    /**
     * adx曝光量级
     */
    private Double adxExpPv;

    /**
     * adx点击量级
     */
    private Double adxClickPv;

    /**
     * 广告位访问量级
     */
    private Double slotRequestPV;


    /**
     * 广告曝光次数
     */
    private Double adExpPv;

    /**
     * 广告计费点击数
     */
    private Double adClickPv;

    /**
     * 广告目标转化PV
     */
    private Double adConvertPv;

    /**
     * 累计出价因子factor（口径：曝光量级）
     */
    private Double factorAcc;


    /**
     * 累计预估cvr（口径：曝光量级）
     */
    private Double pCvrAcc;

    /**
     * 累计预估ctr（口径：曝光量级）
     */
    private Double pCtrAcc;

    /**
     * 累计出价（口径：曝光量级）
     */
    private Double priceAcc;

    /**
     * adx消耗(分)
     */
    private Double adxCost;

    /**
     * 广告理论消耗(分)
     */
    private Double adTargetCost;


    /**
     * 特征map
     * 初始化计算，并缓存
     */
    private Map<String, String> featureMap ;

    /**
     * ADX入口素材点击率
     * sCtr
     * 初始化计算，并缓存
     */
    private Double sCtr = null;
    private Boolean sCtrConf = false;

    /**
     * ADX点击目标转化率
     * sCvr
     * 初始化计算，并缓存
     */
    private Double sCvr = null;
    private Boolean sCvrConf = false;

    /**
     * UV点券收益
     * 初始化计算，并缓存
     */
    private Double uvCost;


    /**
     * 实际ROI
     * 初始化计算，并缓存
     */
    private Double sRoi;
    private Boolean sRoiConf = false;

    /**
     * 平均成本控制因子
     * 初始化计算，并缓存
     */
    private Double cFactoAvg = 1.0;


    /**
     * 成本控制因子
     * 初始化计算，并缓存
     */
    private Double cFactor = 1.0;


}
