package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxStatData {



    /**
     * 计算策略指标数据
     *
     * @param strategy
     * @param strategyDoList
     * @return 策略指标数据
     */
    public static Map<String, Long> getStrategyStatData(String strategy,
                                                        ArrayList<AdxStrategyDo> strategyDoList) {


        Map<String, Long> retMap = new HashMap<>();

        Long defaultCnt = 0L;
        Long defaultConsume = 0L;
        Long bidCnt = defaultCnt, sucCnt = defaultCnt, expCnt = defaultCnt, clickCnt = defaultCnt;
        Long adxConsume = defaultConsume, advertConsume = defaultConsume;

        if (AssertUtil.isAllNotEmpty(strategy, strategyDoList)) {

            List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
            bidCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID.getCode(), defaultCnt);
            sucCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID_SUC.getCode(), defaultCnt);
            expCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.EXP.getCode(), defaultCnt);
            clickCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.CLICK.getCode(), defaultCnt);
            adxConsume = DataUtil.double2Long((StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADX_CONSUME.getCode(), defaultConsume)/1000/10000),1L);
            advertConsume = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);

        }

        retMap.put(AdxIndex.BID.getCode(), bidCnt);                   //竞价量
        retMap.put(AdxIndex.BID_SUC.getCode(), sucCnt);               //竞价成功量
        retMap.put(AdxIndex.EXP.getCode(), expCnt);                   //曝光量
        retMap.put(AdxIndex.CLICK.getCode(), clickCnt);               //点击量
        retMap.put(AdxIndex.ADX_CONSUME.getCode(), adxConsume);       //adx消耗(分)
        retMap.put(AdxIndex.ADVERT_CONSUME.getCode(), advertConsume); //广告消耗(分)

        return retMap;
    }



    /**
     * 计算创意/资源位整体的roi
     *
     * @param mapInfo
     * @return roi
     */
    public static Double getRoi(Map<String, Long> mapInfo, Double targetRoi) {

        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 50L;

        if (AssertUtil.isNotEmpty(mapInfo)) {
            //adx消耗(分)
            Long adxConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            //广告消耗(分)
            Long advertConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);

            if (adxConsume >= defaultAdxConsume) {
                ret = DataUtil.division(advertConsume, adxConsume, 6);

            } else {
                ret = DataUtil.division((advertConsume + defaultAdxConsume * targetRoi), (adxConsume + defaultAdxConsume), 6);
            }
        }

        return ret;
    }



    /**
     * 计算策略流量配比
     *
     * @param flowRateMap
     * @param ind
     * @param step
     * @return
     */
    public static Map<String, Double> getFlowRateAdjust(Map<String, Double> flowRateMap,
                                                        Integer ind, Double step) {

        Map<String, Double> retMap = new HashMap<>();

        Double defaultFlowRate = 0.33;  // 默认流量配比
        Double firFlowRate = defaultFlowRate, secFlowRate = defaultFlowRate, thiFlowRate = defaultFlowRate;

        if (AssertUtil.isNotEmpty(flowRateMap)) {
            firFlowRate = StrategyBid.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_FIR.getCode()), defaultFlowRate, 0.1,0.8);
            secFlowRate = StrategyBid.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_SEC.getCode()), defaultFlowRate, 0.1,0.8);
            thiFlowRate = StrategyBid.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_THI.getCode()), defaultFlowRate, 0.1,0.8);
        }

        if (AssertUtil.isAllNotEmpty(ind, step)) {

            if (ind == 1) {
                firFlowRate += step;
            } else if (ind == 2) {
                secFlowRate += step;
            } else if (ind == 3) {
                thiFlowRate += step;
            }

        }

        retMap.put(AdxStrategy.ADX_STRATEGY_FIR.getCode(), firFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_SEC.getCode(), secFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_THI.getCode(), thiFlowRate);

        return retMap;
    }



    /**
     * 缺失情况，重置为defaultValue
     *
     * @param value
     * @param defaultValue
     * @return 默认值
     */
    public static Double nullToDefault(Double value, Double defaultValue) {

        Double ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }




    /**
     * 计算流量配比得分
     *
     * @param mapInfo
     * @return roi
     */
    public static Double getFlowRateScore(Map<String, Long> mapInfo) {

        Double ret = 0.0;
        Long defaultValue = 0L;
        Long bidCntLimit = 20L;

        if (AssertUtil.isNotEmpty(mapInfo)) {

            //竞价量
            Long bidCnt = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            //adx消耗(分)
            Long adxConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            //广告消耗(分)
            Long advertConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);

            if (bidCnt >= bidCntLimit) {
                ret = DataUtil.division((advertConsume/1.15 - adxConsume), bidCnt) * 1000;
            }
        }

        return DataUtil.formatDouble(ret ,3);
    }





}
