package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;




public class FactorExploration {



    /**
     * 策略3-因子试探（根据缓存数据，调用频率：20min调用1次）
     *
     * @param adxRoiControlDoInfo 人工设置，统计数据，上一次缓存数据
     * @return 因子试探表,调节主要依据
     */


    private static final Logger logger = LoggerFactory.getLogger(FactorExploration.class);

    public static AdxFactorExplorationDo getExploreFactor(AdxRoiControlDo adxRoiControlDoInfo) {

        AdxFactorExplorationDo ret = new AdxFactorExplorationDo();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、计算统计数据
         * 步骤4、判断启动状态tryLabel
         * 步骤5、判断基准值是否重置/更新
         * 步骤6、试价幅度调节
         * 步骤7、试价流量分配
         * 步骤8、更新上一次实际ROI
         *
         */


        try {


            // 1、设置默认值
            Double defaultFactor = 1.0;                               // 默认ROI调节因子
            Double defaultMinRoi = 1.0;                               // 默认最低ROI
            Double lowerLimit = 0.3;                                  // ROI调节因子下限
            Double upperLimit = 1.7;                                  // ROI调节因子上限

            Double[] stepList = {-0.05, 0.00, 0.05};                  // 基准值调节步长
            //Double[] diffList = {0.02, 0.05, 0.08, 0.10};
            Double[] diffList = {0.02, 0.05, 0.08, 0.10, 0.15, 0.20, 0.30};  // ROI偏差分桶值

            Double baseValue = defaultFactor;                         // 基准值
            Double[] baseFlowRate = {0.2, 0.6, 0.2};                  // 基准流量比例
            Double[] lastRealRoi = {0.0, 0.0, 0.0};                   // 默认上一次实际roi
            Double[] lastRealSucRate = {0.0, 0.0, 0.0};               // 默认上一次成功率


            //因子试探表
            Map<String, Double> factorMap = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> flowRateMap = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> lastRoiMap  = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> lastSucRateMap  = new HashMap<>((AdxLevel.values().length - 1));

            Long tryLabel = 0L;                                       // 冷启动试探标记
            Long lastTryLabel = 0L;                                   // 上一次冷启动试探标记


            //调节主要依据
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;

            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;



            //2、当前对象是否合法
            if (AssertUtil.isNotEmpty(adxRoiControlDoInfo)) {

                //人工设置ROI
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                //扣费方式：1:一价扣费，2:二价扣费
                Integer feeType = adxRoiControlDoInfo.getFeeType();

                //3、计算统计数据
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyThiMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());

                //策略3-分level-实时-ROI(置信),竞价成功率,竞价成功量级，adx消耗(分*10000/cpm)
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategyThiMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                //分level-实时-ROI(置信处理)
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategyThiMs, minRoi);
                //分level-实时-ROI(纠偏处理)
                Map<String, Double> roiLevelMs = StrategyBid.getRoiFactorRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);


                //策略3-实时-ROI,竞价成功率,竞价量级,竞价成功量级.adx消耗(分),广告消耗
                roiMs = StrategyBid.getRoi(strategyThiMs,minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyThiMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division(StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume),10000*1000L,2);
                advertConsumeMs = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));

                //策略3-全天累计-ROI,竞价成功率,竞价量级,竞价成功量级.adx消耗(分),广告消耗
                roiDay = StrategyBid.getRoi(strategyThiDay,minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyThiDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division(StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume),10000*1000L,2);
                advertConsumeDay = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));

                //资源位维度-实时-ROI,竞价成功率
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }




                //4、判断启动状态tryLabel：0-正常；1-试探；2-回归(不在投放时间段,实时竞价量级为0)
                if (bidCntMs == 0L) {

                    tryLabel = 2L;

                } else {

                    // 试探组数据不置信；基准level数据不置信 并且 涨价level的roi<0.95
                    if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 0.05
                            && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 200 * 1000 * 10000L) {

                        tryLabel = 1L;

                    } else {

                        if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05
                                && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 200 * 1000 * 10000L) {

                            if (roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < minRoi * 0.95) {

                                tryLabel = 1L;

                            }
                        }
                    }

                }




                //5、判断调节因子是否重置/更新
                baseValue = defaultFactor;
                Double lowValue = baseValue + 0.05;  //获得降价level的出价
                Double uppValue = baseValue - 0.05;  //获得涨价level的出价
                Double diff = DataUtil.division(roiMs, minRoi,3);

                //5.1、重置--人工设置ROI与上一次ROI不相同; 更新时间为00:00:00-00:20:00;全天累计竞价量级为0;
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));

                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null
                        || (currentTime >= 0L && currentTime < 20L)
                        || bidCntDay == 0L) {

                    baseValue = defaultFactor;

                } else {


                    //5.2、最优出价：增量1，权重1
                    Double incre1 = 1.00;
                    AdxFactorExplorationDo lastFactorDoInfo = adxRoiControlDoInfo.getLastFactorExplorationDo();
                    if (AssertUtil.isNotEmpty(lastFactorDoInfo)) {

                        Map<String, Double> lastFactorMap = lastFactorDoInfo.getFactorExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastFactorDoInfo.getTryLabel();

                        if (AssertUtil.isNotEmpty(lastFactorMap)) {

                            if (lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                //获得基准出价
                                baseValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                //获得降价level的出价
                                lowValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                                //获得涨价level的出价
                                uppValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());

                            }

                            //增量1
                            if (lastFactorMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division(lastFactorMap.get(bestLevel), baseValue, 3);

                            }

                        }

                    }


                    //不在投放时间段，基准值回归至默认值
                    if (tryLabel == 2L) {

                        Double baseDiff = baseValue - defaultFactor;
                        baseValue -= baseDiff * 0.20;


                    } else {

                        //权重1
                        Double weight1 = 1.00;
                        if (sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05) {
                            weight1 = 0.0;
                        } else {
                            weight1 = diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0));
                        }


                        //5.3、维稳调控：增量2，权重2
                        Double incre2 = 1.00;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((minRoi * 0.98), roiMs, 3);

                            //墨迹：参照max(历史策略ROI，实时策略ROI)
                            if (feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                                incre2 = DataUtil.division((minRoi * 0.98), roiStable, 3);
                            }
                        }

                        Double weight2 = 1.00;
                        if (sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05) {
                            weight2 = 0.0;
                        } else {
                            //weight2 = diff < 0.95 ? 0.7 : (diff < 1.05 ? 0.5 : 0.8);
                            weight2 = 1.0;
                        }

                        //根据全天累计ROI确定维稳范围
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);

                        incre1 = StrategyBid.getNormalValue(incre1, 1.00, 0.90, 1.10);
                        incre2 = StrategyBid.getNormalValue(incre2, 1.00, (1 - remainStableLimit), (1 + remainStableLimit));
                        Double incre = 1 + (incre1-1) * weight1 *0.5 + (incre2-1) * weight2 * 0.5;
                        if (weight1 == 0.0) { incre = 1 + (incre2-1) * weight2; }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);


                        //5.4、基准出价是否更新(冷启动:不更新；正常启动：更新)
                        if (tryLabel == 0L) {
                            baseValue = StrategyBid.getNormalValue((baseValue * incre), defaultFactor, (baseValue * (1.0 - coeff)), (baseValue * (1.0 + coeff)));
                        }


                        // 冷启动跳转正常启动,用试探level更新basevalue
                        if (lastTryLabel == 1L && tryLabel == 0L) {
                            baseValue = uppValue;
                        }


                        baseValue = DataUtil.formatDouble(StrategyBid.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit),6);

                    }

                }




                // 6、试价幅度调节
                if (tryLabel == 2L) {

                    //涨价幅度
                    Double uppDiff = uppValue - defaultFactor;
                    stepList[0] = uppValue - uppDiff * 0.20 - baseValue;

                    //降价幅度
                    Double lowDiff = lowValue - defaultFactor;
                    stepList[2] = lowValue - lowDiff * 0.20 - baseValue;


                } else if (tryLabel == 1L) {

                    //降价幅度
                    stepList[2] = lowValue - baseValue;

                    //涨价幅度
                    Double stepCon = StrategyBid.getTryUppStepCon(adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()),
                            roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), 0.10);

                    Double uppDiff = DataUtil.division(roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), minRoi, 3);
                    Double stepRoi = uppDiff < 0.8 ? -0.10 : (uppDiff < 0.95 ? -0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.20 ? 0.07 : 0.10)));

                    if (adxConsumeMs == 0.0) {
                        stepCon = 0.15;
                        stepRoi = 0.15;
                    }

                    stepList[0] = Math.min((uppValue - baseValue - (0.4 * stepCon + 0.6 * stepRoi)), 0.0);


                } else {

                    //涨价幅度
                    stepList[0] -= diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.00 : (diff < 1.3 ? 0.03 : 0.05)));
                    //降价幅度
                    stepList[2] += diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.00 : (diff < 0.95 ? -0.02 : -0.03)));


                }




                //7、试价流量分配
                if (tryLabel == 2L) {

                    //涨价占比
                    baseFlowRate[0] = 0.2;
                    //降价占比
                    baseFlowRate[2] = 0.2;


                } else if (tryLabel == 1L) {

                    //涨价占比
                    Double tryDiff = DataUtil.division(roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), minRoi,3);
                    baseFlowRate[0] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), adxRoiControlDoInfo);
                    //降价占比
                    baseFlowRate[2] = baseFlowRate[0] > 0.8 ? 0.0 : 0.2;

                    //针对墨迹一价计费, 冷启动时，增大涨价流量占比
                    //if (feeType != null && feeType == 1) {
                    //    baseFlowRate[0] = 0.4;
                    //}


                } else {

                    if (diff < 0.9) {

                        //涨价占比
                        baseFlowRate[0] = 0.1;
                        //降价占比
                        baseFlowRate[2] = diff < 0.8 ? 0.3 : 0.2;

                    } else if (diff > 1.1) {

                        //涨价占比
                        baseFlowRate[0] = diff < 1.2 ? 0.2 : 0.3;
                        //降价占比
                        baseFlowRate[2] = 0.1;

                    } else if (diff > 0.95 && diff < 1.05) {

                        //涨价占比
                        baseFlowRate[0] = 0.10;
                        //降价占比
                        baseFlowRate[2] = 0.10;

                    } else {

                        //涨价占比
                        baseFlowRate[0] = 0.15;
                        //降价占比
                        baseFlowRate[2] = 0.15;

                    }

                }

                baseFlowRate[1] = DataUtil.formatDouble((1.0 - baseFlowRate[2] - baseFlowRate[0]),3);




                //8、更新上一次实际ROI和竞价成功率
                for (int i = 1; i < AdxLevel.values().length; i++) {
                    lastRealRoi[i-1] = roiLevelMs.get(DataUtil.Integer2String(i));
                    lastRealSucRate[i-1] = sucRateLevelMs.get(DataUtil.Integer2String(i));

                    //ROI：冷启动-未纠偏
                    if (tryLabel == 1L) {
                        lastRealRoi[i-1] = roiRealLevelMs.get(DataUtil.Integer2String(i));
                    }
                }

            }



            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (!key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) {
                    int i = DataUtil.toInt(DataUtil.string2Long(key));
                    Double factor = DataUtil.formatDouble(StrategyBid.getNormalValue((baseValue + stepList[i-1]), defaultFactor, lowerLimit, upperLimit),6);
                    Double flowRate = DataUtil.formatDouble(baseFlowRate[i-1],3);
                    Double lastRoi = lastRealRoi[i-1];
                    Double lastSucRate = lastRealSucRate[i-1];

                    factorMap.put(key, factor);
                    flowRateMap.put(key, flowRate);
                    lastRoiMap.put(key, lastRoi);
                    lastSucRateMap.put(key, lastSucRate);
                }
            }

            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);

            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);

            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);


        } catch(Exception e){
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }

        return ret;
    }






    //单元测试
    public static void main(String[] args) {

        try {

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setBasePrice(900.0);


            //AdxFactorExplorationDo ret2 = FactorExploration.getExploreFactor(adxRoiControlDoInfo1);
            //System.out.println("ret2:" + JSON.toJSONString(ret2));


            String str =
                    "{\"adxFlowRateDo\":{\"firFlowRate\":0.1,\"roiDiffDayList\":[1.008,0.769,1.031],\"roiDiffMsList\":[0.787,0.578,0.891],\"scoreList\":[16.045,-8.036,17.709],\"secFlowRate\":0.101,\"sucRateDayList\":[0.121,0.064,0.107],\"sucRateMsList\":[0.044,0.071,0.059],\"thiFlowRate\":0.801},\"adxRoiFactorDo\":{\"advertConsumeDay\":171523.0,\"advertConsumeMs\":231.0,\"adxConsumeDay\":122587.15,\"adxConsumeMs\":302.5,\"adxRoiFactor\":0.864422,\"bidCntDay\":1125044,\"bidCntMs\":5100,\"lastRealRoi\":0.763662,\"roiDay\":1.399193,\"roiMs\":0.763662,\"sucBidCntDay\":134832,\"sucBidCntMs\":348,\"sucDay\":0.119846,\"sucMs\":0.068236},\"basePrice\":900.0,\"defaultPrice\":900,\"factorExplorationDo\":{\"advertConsumeDay\":380713.0,\"advertConsumeMs\":2291.0,\"adxConsumeDay\":265789.16,\"adxConsumeMs\":1652.42,\"bidCntDay\":2759952,\"bidCntMs\":32429,\"factorExploreMap\":{\"1\":0.829498,\"2\":0.829498,\"3\":0.8795},\"factorFlowRateMap\":{\"1\":0.061,\"2\":0.74,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.290854,\"2\":1.611559,\"3\":2.289869},\"lastSucRateMap\":{\"1\":0.073663,\"2\":0.039826,\"3\":0.020296},\"roiDay\":1.432388,\"roiMs\":1.386455,\"sucBidCntDay\":293614,\"sucBidCntMs\":1910,\"sucDay\":0.106384,\"sucMs\":0.058898,\"tryLabel\":1},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":2828,\"advertConsume\":2814,\"adxConsume\":23666550000,\"bid\":67980,\"exp\":2585,\"click\":632},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":171523.0,\"advertConsumeMs\":231.0,\"adxConsumeDay\":122587.15,\"adxConsumeMs\":302.5,\"adxRoiFactor\":0.864422,\"bidCntDay\":1125044,\"bidCntMs\":5100,\"lastRealRoi\":0.763662,\"roiDay\":1.399193,\"roiMs\":0.763662,\"sucBidCntDay\":134832,\"sucBidCntMs\":348,\"sucDay\":0.119846,\"sucMs\":0.068236},\"lastFactorExplorationDo\":{\"advertConsumeDay\":380713.0,\"advertConsumeMs\":2291.0,\"adxConsumeDay\":265789.16,\"adxConsumeMs\":1652.42,\"bidCntDay\":2759952,\"bidCntMs\":32429,\"factorExploreMap\":{\"1\":0.829498,\"2\":0.829498,\"3\":0.8795},\"factorFlowRateMap\":{\"1\":0.061,\"2\":0.74,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.290854,\"2\":1.611559,\"3\":2.289869},\"lastSucRateMap\":{\"1\":0.073663,\"2\":0.039826,\"3\":0.020296},\"roiDay\":1.432388,\"roiMs\":1.386455,\"sucBidCntDay\":293614,\"sucBidCntMs\":1910,\"sucDay\":0.106384,\"sucMs\":0.058898,\"tryLabel\":1},\"lastMinRoi\":1.39,\"lastPriceExplorationDo\":{\"advertConsumeDay\":27680.0,\"advertConsumeMs\":192.0,\"adxConsumeDay\":25933.17,\"adxConsumeMs\":239.41,\"bidCntDay\":474873,\"bidCntMs\":4116,\"lastRealRoiMap\":{\"1\":1.39,\"2\":1.39,\"3\":0.802006},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.138447},\"priceExploreMap\":{\"1\":567.0,\"2\":630.0,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.605,\"3\":0.196},\"roiDay\":1.06736,\"roiMs\":0.802006,\"sucBidCntDay\":30232,\"sucBidCntMs\":287,\"sucDay\":0.063664,\"sucMs\":0.069728,\"tryLabel\":1},\"maxPrice\":2500,\"minPrice\":300,\"minRoi\":1.39,\"priceExplorationDo\":{\"advertConsumeDay\":27680.0,\"advertConsumeMs\":192.0,\"adxConsumeDay\":25933.17,\"adxConsumeMs\":239.41,\"bidCntDay\":474873,\"bidCntMs\":4116,\"lastRealRoiMap\":{\"1\":1.39,\"2\":1.39,\"3\":0.802006},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.138447},\"priceExploreMap\":{\"1\":567.0,\"2\":630.0,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.605,\"3\":0.196},\"roiDay\":1.06736,\"roiMs\":0.802006,\"sucBidCntDay\":30232,\"sucBidCntMs\":287,\"sucDay\":0.063664,\"sucMs\":0.069728,\"tryLabel\":1},\"resourceIndexMap\":{\"bidSuc\":11834,\"advertConsume\":12160,\"adxConsume\":98730970000,\"bid\":310213,\"exp\":10720,\"click\":2588},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":134878,\"advertConsume\":171576,\"adxConsume\":1226307380000,\"bid\":1127696,\"exp\":128268,\"click\":25816}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":27000000,\"bid\":93338,\"exp\":3,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":13011,\"advertConsume\":11989,\"adxConsume\":111303900000,\"bid\":285432,\"exp\":12367,\"click\":2105}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":17404,\"advertConsume\":15879,\"adxConsume\":149503790000,\"bid\":103020,\"exp\":16584,\"click\":2887}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":49419,\"advertConsume\":59010,\"adxConsume\":451280180000,\"bid\":478572,\"exp\":46664,\"click\":9458}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":216998,\"advertConsume\":285743,\"adxConsume\":1961168310000,\"bid\":1977354,\"exp\":204839,\"click\":41735}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":29564,\"advertConsume\":38749,\"adxConsume\":265337310000,\"bid\":361307,\"exp\":27929,\"click\":5830}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":350,\"advertConsume\":266,\"adxConsume\":3078890000,\"bid\":6402,\"exp\":334,\"click\":81}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":1360,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":4011,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":180,\"advertConsume\":155,\"adxConsume\":1494000000,\"bid\":1211,\"exp\":166,\"click\":28}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":156,\"advertConsume\":200,\"adxConsume\":1331320000,\"bid\":3225,\"exp\":145,\"click\":36}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1813,\"advertConsume\":2153,\"adxConsume\":15254170000,\"bid\":38650,\"exp\":1665,\"click\":417}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":278,\"advertConsume\":40,\"adxConsume\":2209790000,\"bid\":10421,\"exp\":242,\"click\":56}}],\"strategy\":\"3\"}]}\n";
            //JSONObject object = JSON.parseObject(str);
            AdxRoiControlDo adxRoiControlDoInfo3 = JSONObject.parseObject(str,AdxRoiControlDo.class);
            System.out.println("lastFactorExplorationDo:" + JSON.toJSONString(adxRoiControlDoInfo3.getLastFactorExplorationDo()));

            AdxFactorExplorationDo ret3 = FactorExploration.getExploreFactor(adxRoiControlDoInfo3);
            System.out.println("ret3:" + JSON.toJSONString(ret3));
            System.out.println("ret3:" + JSON.toJSONString(DataUtil.double2Long(359000000/1000/10000,1L)));

        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}