package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;

import java.io.DataOutput;
import java.io.Serializable;

/**
 * 响应插件-统计对象
 */
public class ResPlugInStatModel implements Serializable {


    /**
     * 统计对象融合
     * @param historyStatDo
     * @param hourStatDo
     * @return
     */
    public static ResPlugInStatDo merge(ResPlugInStatDo historyStatDo, ResPlugInStatDo hourStatDo) {

        ResPlugInStatDo ret = new ResPlugInStatDo();
        if (historyStatDo == null) {
            historyStatDo = new ResPlugInStatDo();
        }

        if (hourStatDo == null) {
            hourStatDo = new ResPlugInStatDo();
        }

        Double decayFactor = getDecayFactor(hourStatDo.getMainVisitPv());

        Long visitPv = merge(historyStatDo.getVisitPv(), hourStatDo.getMainVisitPv(), hourStatDo.getResPlugVisitPv(), decayFactor);
        Long joinPv = merge(historyStatDo.getJoinPv(), hourStatDo.getMainJoinPv(), hourStatDo.getResPlugJoinPv(), decayFactor);
        Long launchCnt = merge(historyStatDo.getLaunchCnt(), hourStatDo.getMainLaunchCnt(), hourStatDo.getResPlugLaunchCnt(), decayFactor);
        Long clickPv = merge(historyStatDo.getClickPv(), hourStatDo.getMainClickPv(), hourStatDo.getResPlugClickPv(), decayFactor);
        Long costFee = merge(historyStatDo.getCostFee(), hourStatDo.getMainCostFee(), hourStatDo.getResPlugCostFee(), decayFactor);
        Long convertPv = merge(historyStatDo.getConvertPv(), hourStatDo.getMainConvertPv(), hourStatDo.getResPlugConvertPv(), decayFactor);


        ret.setSlotId(hourStatDo.getSlotId());
        ret.setDsm2A(historyStatDo.getDsm2A());
        ret.setResPlugInId(hourStatDo.getResPlugInId());
        ret.setResPlugInIndex(hourStatDo.getResPlugInIndex());


        ret.setVisitPv(visitPv);
        ret.setJoinPv(joinPv);
        ret.setLaunchCnt(launchCnt);
        ret.setClickPv(clickPv);
        ret.setCostFee(costFee);
        ret.setConvertPv(convertPv);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));

        return ret;
    }

    public static Double getRpm(ResPlugInStatDo historyStatDo) {
        Double ret = null;
        if (historyStatDo != null) {
            if (historyStatDo.getVisitPv() > 500 && historyStatDo.getCostFee() > 500) {
                ret = DataUtil.division(historyStatDo.getCostFee(), historyStatDo.getVisitPv(), 5);
            }
        }
        return ret;
    }

    public static Double getRoi(ResPlugInStatDo historyStatDo) {
        Double ret = null;
        if (historyStatDo != null) {
            if (historyStatDo.getVisitPv() > 500 && historyStatDo.getConvertPv() > 5) {
                ret = DataUtil.division(historyStatDo.getConvertPv(), historyStatDo.getVisitPv(), 5);
            }
        }
        return ret;
    }

    public static Long merge(Long v1, Long v2, Long v3, Double decayFactor) {

        if (v1 == null) {
            v1 = 0L;
        }
        if (v2 == null) {
            v2 = 0L;
        }
        if (v3 == null) {
            v3 = 0L;
        }
        return DataUtil.double2Long(decayFactor *v1 + (v2 + v3));

    }

    public static Double getDecayFactor(Long visitPv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = 1.0 - 0.3 * Math.min(visitPv / 1000, 1.0);
        }
        return ret;
    }

}
