package cn.com.duiba.nezha.alg.alg.intercept;

import cn.com.duiba.nezha.alg.alg.vo.intercept.ActInterceptRcmdDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptStatDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectActInterceptDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class ActInterceptRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(ActInterceptRcmdAlg.class);


    /**
     * @param coderModel                  编码器模型
     * @param ltfModel                    TF模型
     * @param actInterceptDoList          返回拦截活动-业务
     * @param preSelectActInterceptDoList 海选集合
     * @param actInterceptStatDoMap       统计数据
     * @param actInterceptFeatureDo       特征
     * @return
     */
    public static ActInterceptRcmdDo rcmd(CODER coderModel,
                                          LocalTFModel ltfModel,
                                          List<Long> actInterceptDoList,
                                          List<PreSelectActInterceptDo> preSelectActInterceptDoList,
                                          Map<Long, ActInterceptStatDo> actInterceptStatDoMap,
                                          ActInterceptFeatureDo actInterceptFeatureDo) {
        ActInterceptRcmdDo ret = null;
        try {
            ret = ActInterceptDQNRcmder.rcmd(coderModel, ltfModel, actInterceptDoList, preSelectActInterceptDoList, actInterceptStatDoMap, actInterceptFeatureDo);
        } catch (Exception e) {
            logger.error("ActTitleRcmdDo.rcmd2 error", e);
        }
        return ret;
    }


    /**
     * 特征解析
     *
     * @param
     * @return
     */
    public static Map<String, String> featureParse(ActInterceptFeatureDo actFeatureDo) {
        //1 静态特征解析
        Double rpm = null;
        if (actFeatureDo != null) {
            rpm = ActInterceptStatModel.getRpm(actFeatureDo.getActInterceptStatDo());
        }


        return ActInterceptDQNRcmder.featureParse(actFeatureDo,rpm);
    }


}
