package cn.com.duiba.nezha.alg.alg.intercept;

import cn.com.duiba.nezha.alg.alg.vo.intercept.ActInterceptRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.InterceptRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectPlugInterceptDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptStatDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectActInterceptDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.PlugInterceptStatDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class ActInterceptRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(ActInterceptRcmdAlg.class);


    /**
     * @param coderModel                  编码器模型
     * @param ltfModel                    TF模型
     * @param actInterceptDoList          返回拦截活动-业务
     * @param preSelectActInterceptDoList 海选集合
     * @param actInterceptStatDoMap       统计数据
     * @param actInterceptFeatureDo       特征
     * @return
     */
    public static ActInterceptRcmdDo rcmd(CODER coderModel,
                                          LocalTFModel ltfModel,
                                          List<Long> actInterceptDoList,
                                          List<PreSelectActInterceptDo> preSelectActInterceptDoList,
                                          Map<Long, ActInterceptStatDo> actInterceptStatDoMap,
                                          ActInterceptFeatureDo actInterceptFeatureDo) {
        ActInterceptRcmdDo ret = null;
        try {
            ret = ActInterceptDQNRcmder.rcmd(coderModel, ltfModel, actInterceptDoList, preSelectActInterceptDoList, actInterceptStatDoMap, actInterceptFeatureDo);
        } catch (Exception e) {
            logger.error("ActTitleRcmdDo.rcmd2 error", e);
        }
        return ret;
    }

    /**
     * @param coderModel                   编码器模型
     * @param ltfModel                     TF模型
     * @param plugInterceptDoList          返回拦截活动-业务
     * @param preSelectPlugInterceptDoList 海选集合
     * @param plugInterceptStatDoMap       统计数据
     * @param plugInterceptFeatureDo       特征
     * @return
     */
    public static ActInterceptRcmdDo rcmdPlug(CODER coderModel,
                                              LocalTFModel ltfModel,
                                              List<Long> plugInterceptDoList,
                                              List<PreSelectPlugInterceptDo> preSelectPlugInterceptDoList,
                                              Map<Long, PlugInterceptStatDo> plugInterceptStatDoMap,
                                              ActInterceptFeatureDo plugInterceptFeatureDo) {
        ActInterceptRcmdDo ret = null;
        try {
            ret = PlugInterceptDQNRcmder.rcmd(coderModel, ltfModel, plugInterceptDoList, preSelectPlugInterceptDoList, plugInterceptStatDoMap, plugInterceptFeatureDo);
        } catch (Exception e) {
            logger.error("ActTitleRcmdDo.rcmd2 error", e);
        }
        return ret;
    }

    /**
     * 推荐接口   返回拦截活动&插件
     *
     * @param interceptRcmdRequestDo
     * @return
     */
    public static ActInterceptRcmdDo rcmd(InterceptRcmdRequestDo interceptRcmdRequestDo) {
        ActInterceptRcmdDo ret = null;
        try {
            if (interceptRcmdRequestDo != null) {
                ActInterceptRcmdDo retAct = ActInterceptDQNRcmder.rcmd(
                        interceptRcmdRequestDo.getCoderModel(),
                        interceptRcmdRequestDo.getLtfModel(),
                        interceptRcmdRequestDo.getActInterceptDoList(),
                        interceptRcmdRequestDo.getPreSelectActInterceptDoList(),
                        interceptRcmdRequestDo.getActInterceptStatDoMap(),
                        interceptRcmdRequestDo.getActInterceptFeatureDo());

                ActInterceptRcmdDo retPlug = PlugInterceptDQNRcmder.rcmd(
                        interceptRcmdRequestDo.getPlugCoderModel(),
                        interceptRcmdRequestDo.getPlugLtfModel(),
                        interceptRcmdRequestDo.getPlugInterceptDoList(),
                        interceptRcmdRequestDo.getPreSelectPlugInterceptDoList(),
                        interceptRcmdRequestDo.getPlugInterceptStatDoMap(),
                        interceptRcmdRequestDo.getPlugInterceptFeatureDo());


                return InterceptPkAlg.pk(retAct, retPlug);

            }


//            ret = ActInterceptDQNRcmder.rcmd();

        } catch (Exception e) {
            logger.error("ActTitleRcmdDo.rcmd2 error", e);
        }
        return ret;
    }


    /**
     * 特征解析-返回拦截活动
     *
     * @param
     * @return
     */
    public static Map<String, String> featureParse(ActInterceptFeatureDo actFeatureDo) {
        //1 静态特征解析
        Double rpm = null;
        if (actFeatureDo != null) {
            rpm = InterceptStatModel.getRpm(actFeatureDo.getActInterceptStatDo());
        }

        return ActInterceptDQNRcmder.featureParse(actFeatureDo, rpm);
    }


    /**
     * 特征解析-返回拦截插件
     *
     * @param
     * @return
     */
    public static Map<String, String> featureParsePlug(ActInterceptFeatureDo actFeatureDo) {
        //1 静态特征解析
        Double rpm = null;
        if (actFeatureDo != null) {
            rpm = InterceptStatModel.getRpm(actFeatureDo.getPlugInterceptStatDo());
        }
        return PlugInterceptDQNRcmder.featureParse(actFeatureDo, rpm);
    }
}
