package cn.com.duiba.nezha.alg.alg.intercept;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.intercept.ActInterceptRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectPlugInterceptDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActInterceptFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.PlugInterceptStatDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlugInterceptDQNRcmder {

    private static final Logger logger = LoggerFactory.getLogger(PlugInterceptDQNRcmder.class);

    private static long ADX_MULTIPLIER = 10000000;

    private static int MAP_DF_SIZE = 8;


    /**
     * pcpm权重分配1 top1>0
     */
    static double[] pCpmBucket = {0.5, 0.8, 0.90, 0.95, 0.99, 1};
    static double[] pCpmWeight = {0.1, 1, 2, 2, 5, 100};


    /**
     * 特征解析
     *
     * @param
     * @return
     */
    public static Map<String, String> featureParse(ActInterceptFeatureDo actFeatureDo, Double rpm) {
        //1 静态特征解析
        Map<String, String> staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic(actFeatureDo);
        Map<String, String> dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamicPlug(actFeatureDo, actFeatureDo, rpm);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }


    public static ActInterceptRcmdDo rcmd(CODER coderModel,
                                          LocalTFModel ltfModel,
                                          List<Long> plugInterceptDoList,
                                          List<PreSelectPlugInterceptDo> preSelectPlugInterceptDoList,
                                          Map<Long, PlugInterceptStatDo> plugInterceptStatDoMap,
                                          ActInterceptFeatureDo actFeatureDo) throws Exception {
        ActInterceptRcmdDo ret = null;


        if (valid(plugInterceptDoList, actFeatureDo)) {

            Map<Long, Map<String, String>> featureMap = new HashMap<>();


            //1 海选数据去重、转Map
            Map<Long, PreSelectPlugInterceptDo> plugInterceptSelectDoListMap = getLastSelect(preSelectPlugInterceptDoList);

            //2 统计数据转Map

            if (plugInterceptStatDoMap == null) {
                plugInterceptStatDoMap = new HashMap<>();
            }

            //3 静态特征解析
            Map<String, String> staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic(actFeatureDo);

            //4 解析：动态特征。
            List<ActInterceptRcmdDo> actRcmdDoList = new ArrayList<>();

            for (Long plugId : plugInterceptDoList) {

                // 解析动态特征
                ActInterceptFeatureDo dynamicDo = new ActInterceptFeatureDo();
                dynamicDo.setPlugId(plugId); //
                PlugInterceptStatDo plugInterceptStatDo = plugInterceptStatDoMap.get(plugId);
                Double rpm = InterceptStatModel.getRpm(plugInterceptStatDo);

                Map<String, String> dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamicPlug(dynamicDo, actFeatureDo, rpm);

                dynamicFeatureMap.putAll(staticFeatureMap);

                // 封装特征
                featureMap.put(plugId, dynamicFeatureMap);

//                System.out.println(JSON.toJSONString(featureMap));
            }

            //5 模型预估RPM
            Map<Long, Double> pRpmMap = new HashMap<>();

            if (validModel(coderModel, ltfModel)) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
//            System.out.println(JSON.toJSONString(pRpmMap));


            //6 封装：统计、海选、预估RPM 推荐对象

            for (Long plugId : plugInterceptDoList) {

                ActInterceptRcmdDo interceptRcmdDo = new ActInterceptRcmdDo();
                interceptRcmdDo.setKey(plugId + "");
                interceptRcmdDo.setPlugId(plugId);
                interceptRcmdDo.setInterceptContentType(2L);

                if (plugInterceptSelectDoListMap.containsKey(plugId)) {
                    interceptRcmdDo.setHasType(true);
                } else {
                    interceptRcmdDo.setHasType(false);
                }
                PlugInterceptStatDo plugInterceptStatDo = plugInterceptStatDoMap.get(plugId);

                interceptRcmdDo.setsRpm(InterceptStatModel.getRpm(plugInterceptStatDo));
//                actInterceptRcmdDo.setJpv(InterceptStatModel.getJpv(plugInterceptStatDo));
//                actInterceptRcmdDo.setCpv(InterceptStatModel.getCpv(plugInterceptStatDo));
//                actInterceptRcmdDo.setApv(InterceptStatModel.getApv(plugInterceptStatDo));

                Double pRpm = pRpmMap.get(plugId);


                interceptRcmdDo.setpRpm(pRpm);

                Double mergeRpm = getMergeRpm(interceptRcmdDo);

                interceptRcmdDo.setMergeRpm(mergeRpm);

                actRcmdDoList.add(interceptRcmdDo);
            }
            //5 推荐 最终排序分、 流量分配
            ret = rcmd(actRcmdDoList);

        }

        return ret;
    }


    /**
     * @param rcmdList
     * @return
     */
    public static ActInterceptRcmdDo rcmd(List<ActInterceptRcmdDo> rcmdList) {


        ActInterceptRcmdDo ret = null;


        if (AssertUtil.isEmpty(rcmdList)) {
            return ret;

        }
        long size = rcmdList.size();

        //1 获取最优RPM
        Double bestRpm = null;//最优
        String bestRpmKey = null;

        if (size == 1) {
            return rcmdList.get(0);
        }


        for (int i = 0; i < size; i++) {

            ActInterceptRcmdDo plugDo = rcmdList.get(i);

            Double rpm = plugDo.getMergeRpm();
            if (rpm != null) {
                if (bestRpm == null || bestRpm < rpm) {
                    bestRpm = rpm;
                    bestRpmKey = plugDo.getKey();
                }
            }
        }


        //2 概率分配
        Map<ActInterceptRcmdDo, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

        Double weightSum = 0.0;

        for (int i = 0; i < size; i++) {

            ActInterceptRcmdDo rcmdDo = rcmdList.get(i);

            Double rpm = rcmdDo.getMergeRpm();

            Double weight = getRpmWeight(rpm, bestRpm);

            weight = 1.0;

            weightSum += weight;
            weightMap.put(rcmdDo, weight);

        }


        for (Map.Entry<ActInterceptRcmdDo, Double> entry : weightMap.entrySet()) {
            ActInterceptRcmdDo rcmdDo = entry.getKey();
            Double weight = entry.getValue();

            // 权重调节
            if (bestRpmKey != null && bestRpmKey.equals(rcmdDo.getKey()) && weight < weightSum * 0.85) {

                Double weightOther = weightSum - weight;
                weight = weightOther * 0.85 / (1 - 0.85);
                weightSum = weightOther + weight;

                weightMap.put(rcmdDo, weight);

            }

        }


//        System.out.println("weightMap=" + JSON.toJSONString(weightMap));

        //3 挑选
        ret = Roulette.doubleMap(weightMap);

        //4 返回
        return ret;
    }


    /**
     * @param actRcmdDo
     * @return
     */
    private static Double getMergeRpm(ActInterceptRcmdDo actRcmdDo) {

        Double ret = null;

        if (actRcmdDo != null) {
//            Double actSRpm = actTitleRcmdDo.getsRpm();
//            Double actSubSRpm = actTitleRcmdDo.getSubSRpm();

            Double actSRpm = actRcmdDo.getsRpm();

            Double pRpm = actRcmdDo.getpRpm();

            if (pRpm == null) {
                return ret;
            }

            ret = pRpm;

            if (actSRpm == null) {
                actSRpm = pRpm;
            }


            ret = 0.8 * pRpm + 0.2 * actSRpm;


        }

        return ret;
    }

    /**
     * @param rpm
     * @param bestRpm
     * @return
     */
    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;

        if (rpm != null && bestRpm != null) {

            Double ratio = DataUtil.division(rpm, bestRpm, 3);
            if (bestRpm >= 0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }

        }

        return ret;
    }


    public static Map<Long, PreSelectPlugInterceptDo> getLastSelect(List<PreSelectPlugInterceptDo> preSelectDoList) {
        Map<Long, PreSelectPlugInterceptDo> ret = new HashMap<>();
        Map<String, Map<Long, PreSelectPlugInterceptDo>> groupMap = new HashMap<>();

        String lastDateTime = null;
        if (AssertUtil.isAllNotEmpty(preSelectDoList)) {
            for (int i = 0; i < preSelectDoList.size(); i++) {
                PreSelectPlugInterceptDo preSelectDo = preSelectDoList.get(i);
                if (preSelectDo != null) {
                    String cDateTime = preSelectDo.getDt();
                    Long plugId = preSelectDo.getPlugId();
                    if (!groupMap.containsKey(cDateTime)) {
                        groupMap.put(cDateTime, new HashMap<>());
                    }
                    if (plugId != null) {
                        groupMap.get(cDateTime).put(plugId, preSelectDo);
                    }


                    if (lastDateTime == null) {
                        lastDateTime = cDateTime;
                    } else if (lastDateTime.compareTo(cDateTime) < 0) {
                        lastDateTime = cDateTime;
                    }
                }


            }
            ret = groupMap.get(lastDateTime);
        }

        return ret;
    }

    /**
     * 推荐列表合法性校验
     *
     * @param interceptDoList
     * @param actFeatureDo
     * @return
     */
    private static Boolean valid(List<Long> interceptDoList,
                                 ActInterceptFeatureDo actFeatureDo) {
        Boolean ret = true;

        if (AssertUtil.isAnyEmpty(interceptDoList, actFeatureDo)) {
            logger.warn("PlugInterceptDQNRcmder.rcmd() input valid ,params plugList or actFeatureDo is null");
            ret = false;
        }

        return ret;
    }


    /**
     * 模型合法性校验
     *
     * @param coderModel
     * @param ltfModel
     * @return
     */
    private static Boolean validModel(
            CODER coderModel,
            LocalTFModel ltfModel) {
        Boolean ret = true;

        if (ltfModel == null || coderModel == null) {
            logger.warn("ActInterceptDQNRcmder.rcmd() input valid ,params ltfModel is null or coderModel is null");
            ret = false;
        }

        return ret;
    }

}
