package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.predict.AdxClickValuePredict;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickValuePredDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;

import java.util.List;

public class AdxClickValuePredictAlg {


    /**
     * 接口1：预估点击价值接口
     *
     * @param mergeAdxClickAndJoinDo 点击、活动参与 融合数据；本地缓存获取
     * @param adxPredAdDoList        预发券Top3列表；接口调用获取
     * @return 点击价值
     */
    public static Double getPredClickValue(AdxClickAndJoinDo mergeAdxClickAndJoinDo,
                                           List<AdxPredAdDo> adxPredAdDoList) {
        return AdxClickValuePredict.getPredClickValue(mergeAdxClickAndJoinDo, adxPredAdDoList);

    }


    /**
     * 接口2：点击、活动参与，统计数据融合
     *
     * @param adxClickValuePredDo 点击、活动参与统计数据
     * @return 融合统计数据
     * <p>
     * 备注：数据本地缓存1分钟
     */
    public static AdxClickAndJoinDo getMergeStatClickValue(AdxClickValuePredDo adxClickValuePredDo) {

        return AdxClickValuePredict.getMergeStatClickValue(adxClickValuePredDo);

    }

}