package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;


public class AdxDirectlyFactor {


    /**
     * 算法接口3-直投ROI维稳因子试探表(定时任务)
     * (根据缓存数据，调用频率：20min调用1次）
     *
     * @param directlyIdeaDoInfo 直投创意信息
     * @param lastDirectlyFactorInfo 上一次出参（直投ROI维稳因子对象）
     * @return
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyFactor.class);

    public static AdxDirectlyFactorDo getExploreFactor(AdxDirectlyIdeaDo directlyIdeaInfo,
                                                       AdxDirectlyFactorDo lastDirectlyFactorInfo) {


        AdxDirectlyFactorDo ret = new AdxDirectlyFactorDo();


        /**
         *
         * 步骤：
         * 步骤1、初始化
         * 步骤2、获取统计数据
         * 步骤3、判断启动状态tryLabel
         * 步骤4、判断基准值是否重置/更新
         * 步骤5、试价幅度调节
         * 步骤6、试价流量分配
         * 步骤7、更新上一次统计信息
         *
         */


        try {

            // 1、初始化
            Double minRoi = 1.0;                                             // 默认最低ROI
            Double defaultFactor = 1.0;                                      // 默认ROI调节因子
            Double lowerLimit = 0.3;                                         // ROI调节因子下限
            Double upperLimit = 1.7;                                         // ROI调节因子上限

            Double[] stepList = {-0.05, 0.00, 0.05};                         // 基准值调节步长
            Double[] diffList = {0.02, 0.05, 0.08, 0.10, 0.15, 0.20, 0.30};  // ROI偏差分桶值

            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();        // 直投-策略1
            int levelSize = AdxLevel.values().length - 1;                    // 策略1-level个数

            Double baseValue = defaultFactor;                                // 基准值
            Double[] baseFlowRate = {0.2, 0.6, 0.2};                         // 基准流量比例
            Double[] lastRealRoi = {0.0, 0.0, 0.0};                          // 默认上一次实际roi
            Double[] lastRealSucRate = {0.0, 0.0, 0.0};                      // 默认上一次成功率

            //因子试探表
            Map<String, Double> factorMap = new HashMap<>(levelSize);
            Map<String, Double> flowRateMap = new HashMap<>(levelSize);
            Map<String, Double> lastRoiMap  = new HashMap<>(levelSize);
            Map<String, Double> lastSucRateMap  = new HashMap<>(levelSize);

            Long tryLabel = 0L;                                              // 冷启动试探标记
            Long lastTryLabel = 0L;                                          // 上一次冷启动试探标记

            //调节主要依据
            Long bidCntMs = 0L, sucCntMs = 0L, adxConsumeMs = 0L, advertConsumeMs = 0L;
            Double roiMs = 0.0, sucRateMs = 0.0;
            Long bidCntDay = 0L, sucCntDay = 0L, adxConsumeDay = 0L, advertConsumeDay = 0L;
            Double roiDay = 0.0, sucRateDay = 0.0;



            if (AssertUtil.isNotEmpty(directlyIdeaInfo)) {

                // 2、获取统计数据
                Integer feeType = directlyIdeaInfo.getFeeType();//扣费方式
                minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);//设置ROI

                //计算指标:竞价量级,竞价成功量级.adx消耗(分),广告消耗(分),ROI,竞价成功率,RPM
                ArrayList<AdxStrategyDo> StrategyMsDoList = directlyIdeaInfo.getStrategyMsDoList();
                Map<String, Long> strategyMsIndex = AdxStatData.getStrategyStatData(strategy, StrategyMsDoList);
                ArrayList<AdxStrategyDo> StrategyDayDoList = directlyIdeaInfo.getStrategyDayDoList();
                Map<String, Long> strategyDayIndex = AdxStatData.getStrategyStatData(strategy, StrategyDayDoList);

                //维度:策略-分level-实时
                Map<String, Long> bidCntLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.BID.getCode(), StrategyMsDoList);
                Map<String, Long> sucCntLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.BID_SUC.getCode(), StrategyMsDoList);
                Map<String, Long> adxConsumeLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.ADX_CONSUME.getCode(), StrategyMsDoList);
                Map<String, Long> advertConsumeLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.ADVERT_CONSUME.getCode(), StrategyMsDoList);
                Map<String, Double> sucRateLevelMs = AdxStatData.getLevelSucRate(bidCntLevelMs, sucCntLevelMs);
                Map<String, Double> roiRealLevelMs = AdxStatData.getLevelRoi(adxConsumeLevelMs, advertConsumeLevelMs, minRoi);
                //roi-纠偏处理
                Map<String, Double> roiLevelMs = AdxStatData.getRoiFactorRectify(roiRealLevelMs, adxConsumeLevelMs, lastDirectlyFactorInfo);

                //维度:策略-实时
                bidCntMs = strategyMsIndex.get(AdxIndex.BID.getCode());
                sucCntMs = strategyMsIndex.get(AdxIndex.BID_SUC.getCode());
                adxConsumeMs = strategyMsIndex.get(AdxIndex.ADX_CONSUME.getCode());
                advertConsumeMs = strategyMsIndex.get(AdxIndex.ADVERT_CONSUME.getCode());
                sucRateMs = AdxStatData.getSucRate(strategyMsIndex, 50L);
                roiMs = AdxStatData.getRoi(strategyMsIndex, minRoi);

                //维度:策略-全天
                bidCntDay = strategyDayIndex.get(AdxIndex.BID.getCode());
                sucCntDay = strategyDayIndex.get(AdxIndex.BID_SUC.getCode());
                adxConsumeDay = strategyDayIndex.get(AdxIndex.ADX_CONSUME.getCode());
                advertConsumeDay = strategyDayIndex.get(AdxIndex.ADVERT_CONSUME.getCode());
                sucRateDay = AdxStatData.getSucRate(strategyDayIndex, 50L);
                roiDay = AdxStatData.getRoi(strategyDayIndex, minRoi);

                //维度:资源位-实时
                Map<String, Long> resoMapInfo = directlyIdeaInfo.getResourceIndexMap();
                //AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(resoMapInfo);
                Double resoSucRateMs = AdxStatData.getSucRate(resoMapInfo, 50L);



                // 3、判断启动状态tryLabel：0-正常；1-试探；2-回归
                if (bidCntMs == 0L) {

                    //(不在投放时间段,实时竞价量级为0)
                    tryLabel = 2L;

                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 0.02
                        && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 100L){

                    // 试探组数据不置信；
                    tryLabel = 1L;

                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.02
                        && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 100L
                        && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < minRoi * 0.95) {

                    //基准level数据不置信 并且 涨价level的roi<0.95
                    tryLabel = 1L;

                }



                // 4、判断调节因子是否重置/更新
                baseValue = defaultFactor;
                Double lowValue = baseValue + 0.05;  //获得降价level的因子
                Double uppValue = baseValue - 0.05;  //获得涨价level的因子
                Double diff = DataUtil.division(roiMs, minRoi,3);

                //4.1、重置--人工设置ROI与上一次ROI不相同; 更新时间为00:00:00-00:20:00;全天累计竞价量级为0;
                Double lastMinRoi = AdxStatData.nullToDefault(directlyIdeaInfo.getLastMinRoi(), 1.0);
                Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));

                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null
                        || (currentTime >= 0L && currentTime < 20L)
                        || bidCntDay == 0L) {

                    baseValue = defaultFactor;

                } else {

                    //4.2、选择最优level：增量1，权重1
                    Double incre1 = 1.00;
                    if (AssertUtil.isNotEmpty(lastDirectlyFactorInfo)) {

                        Map<String, Double> lastFactorMap = lastDirectlyFactorInfo.getFactorExploreMap();
                        String bestLevel = AdxStatData.selectBestLevel(bidCntLevelMs, adxConsumeLevelMs, advertConsumeLevelMs);
                        lastTryLabel = AdxStatData.nullToDefault(lastDirectlyFactorInfo.getTryLabel(),0L);

                        if (AssertUtil.isNotEmpty(lastFactorMap)) {

                            if (lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                //获得基准因子
                                baseValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                //获得降价level的因子
                                lowValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                                //获得涨价level的因子
                                uppValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());

                            }

                            //增量1
                            if (lastFactorMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division(lastFactorMap.get(bestLevel), baseValue, 3);

                            }

                        }

                    }


                    //不在投放时间段，基准值回归至默认值
                    if (tryLabel == 2L) {

                        Double baseDiff = baseValue - defaultFactor;
                        baseValue -= baseDiff * 0.20;

                    } else {

                        //权重1
                        Double weight1 = 1.00;
                        if (sucRateMs < 0.02 || sucRateMs < resoSucRateMs * 0.02) {
                            weight1 = 0.0;
                        } else {
                            weight1 = diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0));
                        }


                        //4.3、维稳调控：增量2，权重2
                        Double incre2 = 1.00;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((minRoi * 0.98), roiMs, 3);

                            //墨迹：参照max(历史策略ROI，实时策略ROI)
                            if (feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                                incre2 = DataUtil.division((minRoi * 0.98), roiStable, 3);
                            }
                        }

                        Double weight2 = 1.00;
                        if (sucRateMs < 0.02 || sucRateMs < resoSucRateMs * 0.02) {
                            weight2 = 0.0;
                        } else {
                            weight2 = 1.0;
                        }

                        //根据全天累计ROI确定维稳范围
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, DataUtil.toDouble(adxConsumeDay));

                        incre1 = AdxStatData.getNormalValue(incre1, 1.00, 0.90, 1.10);
                        incre2 = AdxStatData.getNormalValue(incre2, 1.00, (1 - remainStableLimit), (1 + remainStableLimit));
                        Double incre = 1 + (incre1-1) * weight1 *0.5 + (incre2-1) * weight2 * 0.5;
                        if (weight1 == 0.0) { incre = 1 + (incre2-1) * weight2; }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);


                        //4.4、基准出价是否更新(冷启动:不更新；正常启动：更新)
                        if (tryLabel == 0L) {
                            baseValue = AdxStatData.getNormalValue((baseValue * incre), defaultFactor, (baseValue * (1.0 - coeff)), (baseValue * (1.0 + coeff)));
                        }

                        // 冷启动跳转正常启动,用试探level更新basevalue
                        if (lastTryLabel == 1L && tryLabel == 0L) {
                            baseValue = uppValue;
                        }

                        baseValue = DataUtil.formatDouble(AdxStatData.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit),6);

                    }

                }



                // 5、试价幅度调节
                if (tryLabel == 2L) {

                    //涨价幅度
                    Double uppDiff = uppValue - defaultFactor;
                    stepList[0] = uppValue - uppDiff * 0.20 - baseValue;

                    //降价幅度
                    Double lowDiff = lowValue - defaultFactor;
                    stepList[2] = lowValue - lowDiff * 0.20 - baseValue;


                } else if (tryLabel == 1L) {

                    //降价幅度
                    stepList[2] = lowValue - baseValue;

                    //涨价幅度
                    Double stepCon = AdxStatData.getTryUppStepCon(adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()),
                            roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), 0.10);

                    Double uppDiff = DataUtil.division(roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), minRoi, 3);
                    Double stepRoi = uppDiff < 0.8 ? -0.10 : (uppDiff < 0.95 ? -0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.20 ? 0.07 : 0.10)));

                    if (adxConsumeMs == 0.0) {
                        stepCon = 0.15;
                        stepRoi = 0.15;
                    }

                    stepList[0] = Math.min((uppValue - baseValue - (0.4 * stepCon + 0.6 * stepRoi)), 0.0);


                } else {

                    //涨价幅度
                    stepList[0] -= diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.00 : (diff < 1.3 ? 0.03 : 0.05)));
                    //降价幅度
                    stepList[2] += diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.00 : (diff < 0.95 ? -0.02 : -0.03)));


                }



                //6、试价流量分配
                if (tryLabel == 2L) {

                    //涨价占比
                    baseFlowRate[0] = 0.2;
                    //降价占比
                    baseFlowRate[2] = 0.2;


                } else if (tryLabel == 1L) {

                    //涨价占比
                    Double tryDiff = DataUtil.division(roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), minRoi,3);
                    baseFlowRate[0] = AdxStatData.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), lastDirectlyFactorInfo);
                    //降价占比
                    baseFlowRate[2] = baseFlowRate[0] > 0.8 ? 0.0 : 0.2;


                } else {

                    if (diff < 0.9) {

                        //涨价占比
                        baseFlowRate[0] = 0.1;
                        //降价占比
                        baseFlowRate[2] = diff < 0.8 ? 0.3 : 0.2;

                    } else if (diff > 1.1) {

                        //涨价占比
                        baseFlowRate[0] = diff < 1.2 ? 0.2 : 0.3;
                        //降价占比
                        baseFlowRate[2] = 0.1;

                    } else if (diff > 0.95 && diff < 1.05) {

                        //涨价占比
                        baseFlowRate[0] = 0.10;
                        //降价占比
                        baseFlowRate[2] = 0.10;

                    } else {

                        //涨价占比
                        baseFlowRate[0] = 0.15;
                        //降价占比
                        baseFlowRate[2] = 0.15;

                    }

                }

                baseFlowRate[1] = DataUtil.formatDouble((1.0 - baseFlowRate[2] - baseFlowRate[0]),3);


                //7、更新上一次统计信息
                for (int i = 1; i < AdxLevel.values().length; i++) {
                    lastRealRoi[i-1] = roiLevelMs.get(DataUtil.Integer2String(i));
                    lastRealSucRate[i-1] = sucRateLevelMs.get(DataUtil.Integer2String(i));

                    //ROI：冷启动-未纠偏
                    if (tryLabel == 1L) {
                        lastRealRoi[i-1] = roiRealLevelMs.get(DataUtil.Integer2String(i));
                    }
                }

            }



            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (!key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) {
                    int i = DataUtil.toInt(DataUtil.string2Long(key));
                    Double factor = DataUtil.formatDouble(AdxStatData.getNormalValue((baseValue + stepList[i-1]), defaultFactor, lowerLimit, upperLimit),6);
                    Double flowRate = DataUtil.formatDouble(baseFlowRate[i-1],3);
                    Double lastRoi = lastRealRoi[i-1];
                    Double lastSucRate = lastRealSucRate[i-1];

                    factorMap.put(key, factor);
                    flowRateMap.put(key, flowRate);
                    lastRoiMap.put(key, lastRoi);
                    lastSucRateMap.put(key, lastSucRate);
                }
            }

            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setCurrentMinRoi(minRoi);

            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucCntDay(sucCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);

            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucCntMs(sucCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);


        } catch(Exception e){
            logger.error("AdxDirectlyFactor.getExploreFactor error:" + e);

        }

        return ret;
    }

}
