package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowFilterDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFilterAlg {

    /**
     * 算法接口1-流量预过滤
     *
     * @param flowInfo adx流量信息
     * @param filterInfo1 adx流量过滤1.0-定时任务结果
     * @param filterInfo2 adx流量过滤2.0-定时任务结果
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFilterAlg.class);

    public static AdxFlowFilterDo adxFlowFiltering(AdxFlowInfoDo flowInfo,
                                                   AdxFilterInfoDo filterInfo1,
                                                   AdxFilterInfoDo filterInfo2) {
        AdxFlowFilterDo ret = null;

        try {
            ret = AdxFlowFiltering.getFlowFiltering(flowInfo, filterInfo1, filterInfo2);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering error:" + e);

        }

        return ret;
    }


    /**
     * 算法接口2-流量预过滤1.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTask(AdxFlowInfoDo flowInfo,
                                                AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTask.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTask error " + e);

        }

        return ret;
    }



    /**
     * 算法接口3-流量预过滤2.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTaskPlus(AdxFlowInfoDo flowInfo,
                                                    AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTaskPlus.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTaskPlus error " + e);

        }

        return ret;
    }

}
