package cn.com.duiba.nezha.alg.alg.alg;

import cn.com.duiba.nezha.alg.alg.budget.BudgetSmooth;
import cn.com.duiba.nezha.alg.alg.budget.BudgetSmoothNew;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetInfo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;

import java.util.HashMap;
import java.util.Map;

public class BudgetSmoothAlg {


//    /**
//     * @param advertBudgetInfoMap 广告预算消耗对象Map
//     * @return <广告，消耗速度>
//     */
//    public static <T> Map<T, BudgetSmoothDo> getBudgetRatio(Map<T, BudgetInfo> advertBudgetInfoMap) {
//
//        return BudgetSmooth.getBudgetRatio(advertBudgetInfoMap);
//    }
//
//
//    /**
//     * @param advertBudgetInfo 广告预算消耗对象Map
//     * @return <广告，消耗速度>
//     */
//    public static BudgetSmoothDo getBudgetRatio(BudgetInfo advertBudgetInfo) {
//
//        Map<Long, BudgetInfo> advertBudgetInfoMap = new HashMap<>();
//        advertBudgetInfoMap.put(1L, advertBudgetInfo);
//        Map<Long, BudgetSmoothDo> ret = BudgetSmooth.getBudgetRatio(advertBudgetInfoMap);
//        return ret.get(1L);
//    }


    /**
     * 预算消耗速度
     *
     * @param budgetDo           最新消耗数据对象
     * @param lastBudgetSmoothDo 上次调用返回结果
     * @return 消耗速度，1分钟过期，重新计算
     */
    public static BudgetSmoothDo getBudgetRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo) {

        return BudgetSmoothNew.getRatio(budgetDo, lastBudgetSmoothDo);
    }


    /**
     * 计算平滑因子
     * @param budgetSmoothDo    配置    消耗速度 1分钟有效，失效重新计算
     * @param appBudgetSmoothDo 配置&媒体   消耗速度 1分钟内有效  失效重新计算
     * @return
     */
    public static SmoothResultDo getSmoothRatio(BudgetSmoothDo budgetSmoothDo, BudgetSmoothDo appBudgetSmoothDo) {
        SmoothResultDo ret = new SmoothResultDo();
        ret.setGiveUp(false);

        if (appBudgetSmoothDo != null  && appBudgetSmoothDo.getValid()!=null && appBudgetSmoothDo.getValid()) {
            ret = BudgetSmoothNew.getSmooth(appBudgetSmoothDo);

        }

        if(ret.getValid()==null || ret.getValid()==false){
            ret = BudgetSmoothNew.getSmooth(budgetSmoothDo);
        }



        return ret;
    }


//
//    /**
//     * 2.26
//     *
//     * @param advertBudgetInfo
//     * @param lastAdvertBudgetInfo
//     * @return
//     */
//    public static BudgetSmoothDo getBudgetRatio(BudgetInfo advertBudgetInfo, BudgetInfo lastAdvertBudgetInfo) {
//
//        BudgetSmoothDo ret = null;
//        ret = BudgetSmoothNew.getRatio(advertBudgetInfo,lastAdvertBudgetInfo);
//
//        return ret;
//    }
//
//
//    /**
//     * 2.26
//     * 预算平滑-是否竞价
//     *
//     * @param budgetSmoothDo
//     * @return 是否参与竞价
//     */
//    public static SmoothResultDo getBudgetRatio(BudgetSmoothDo budgetSmoothDo) {
//
//        SmoothResultDo ret = new SmoothResultDo();
//        ret.setGiveUp(true);
//
//        return ret;
//    }


}
