package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageRecallDo;
import cn.com.duiba.nezha.alg.feature.parse.DPAActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.DPAActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * @author lijingzhe
 * @description 推荐引擎接口
 * @date 2020/6/17
 */
public class ActRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActRcmder.class);

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [dpaActFeatureDo]
     * @methodReturnType: java.util.Map<java.lang.String,java.lang.String>
     * @description: DPA特征日志解析
     */
    public static Map<String, String> featureParse(DPAActFeatureDo dpaActFeatureDo){
        Map<String, String> featureMap = DPAActFeatureParse.generateFeatureMapStatic(dpaActFeatureDo);
        Map<String, String> dynamicFeatureMapTitle = DPAActFeatureParse.generateFeatureMapDynamicTitle(dpaActFeatureDo);
        Map<String, String> dynamicFeatureMapPrize = DPAActFeatureParse.generateFeatureMapDynamicPrize(dpaActFeatureDo);
        featureMap.putAll(dynamicFeatureMapTitle);
        featureMap.putAll(dynamicFeatureMapPrize);
        return featureMap;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [coderModel, ltfModel, packageRecallDos]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 排序接口
     */
    public static List<ActRcmdDo> recRank(CODER coderModel,
                                          LocalTFModel ltfModel,
                                          List<PackageRecallDo> packageRecallDos) throws Exception{
        return null;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [actRcmdDos]
     * @methodReturnType: java.util.Map
     * @description: 冷启动接口
     */
    public static Map<Integer, ActRcmdDo> recEE(List<ActRcmdDo> actRcmdDos) throws Exception{
        return null;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [actRcmdDos]
     * @methodReturnType: java.util.Map<java.lang.Integer,java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>>
     * @description: 重排序接口
     */
    public static Map<Integer, List<ActRcmdDo>> recSort(List<ActRcmdDo> actRcmdDos) throws Exception{
        return null;
    }

}

