package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.vo.dpa.*;

import java.util.ArrayList;
import java.util.List;

public class LocalPrizeRecallTester {
    public static Double COSTRANGE = 10.0;
    public static Double GLOBAL_COSTRANGE = 10.0;
    public static Double REQUESTRANGE = 100.0;
    public static Double GLOBAL_REQUESTRANGE = 10000.0;

    public static List<PackageInfoDo> preparePrizeCandidates(int num){

        List<PackageInfoDo> result = new ArrayList<PackageInfoDo>(num);
        for (int i = 0; i < num; i++) {
            PackageIdDo pid = new PackageIdDo();
            pid.setPrizeId((long)i);
            pid.setPrizeTagId((long)(Math.random()*10));
            PackageInfoDo pi = new PackageInfoDo();
            pi.setCost(Math.random()*COSTRANGE);
            pi.setGlobalCost(Math.random()*GLOBAL_COSTRANGE);
            pi.setRequest(Math.random()*REQUESTRANGE);
            pi.setGlobalRequest(Math.random()*GLOBAL_REQUESTRANGE);
            pi.setPackageIdDo(pid);
            result.add(pi);
        }
        return result;
    }


    public static List<PackageInfoDo> prepareAdCandidates(int num){

        List<PackageInfoDo> result = new ArrayList<PackageInfoDo>(num);
        for (int i = 0; i < num; i++) {
            PackageIdDo pid = new PackageIdDo();
            pid.setAdPrizeId((long)i);
            pid.setPrizeTagId((long)(Math.random()*10));
            pid.setAdPrizeType(Long.toString((long)(Math.random()*10)));
            PackageInfoDo pi = new PackageInfoDo();
            pi.setCost(Math.random()*COSTRANGE);
            pi.setGlobalCost(Math.random()*GLOBAL_COSTRANGE);
            pi.setRequest(Math.random()*REQUESTRANGE);
            pi.setGlobalRequest(Math.random()*GLOBAL_REQUESTRANGE);
            pi.setPackageIdDo(pid);
            result.add(pi);
        }
        return result;
    }

    public static List<CandidateActivityDo> prepareActivityCandidates(int num, int groupNum){
        List<CandidateActivityDo> result = new ArrayList<CandidateActivityDo>(num);
        Long id = 0l;
        List<List<PrizeDo>> groups = new ArrayList<>(groupNum);
        for (int i = 0; i < groupNum; i++) {
            List<PrizeDo> group = new ArrayList<>(6);
            for(int j =0; j < 6; j++){
                PrizeDo prizeDo = new PrizeDo(false, id++);
                group.add(prizeDo);
            }
            groups.add(group);
        }
        for (int i = 0; i < num; i++) {
            CandidateActivityDo act = new CandidateActivityDo();
            act.setPrizeGroup(deepClone(groups.get(i % groupNum)));
            result.add(act);
        }
        return result;
    }

    private static List<PrizeDo> deepClone(List<PrizeDo> group){
        List<PrizeDo> result = new ArrayList<>(group.size());
        for(PrizeDo pd : group){
            PrizeDo newPd = new PrizeDo(pd.isAd(), pd.getId());
            result.add(newPd);
        }
        return result;
    }

    public static void main(String[] args) {
        List<PackageInfoDo> pks = preparePrizeCandidates(350);
        List<PackageInfoDo> adPks = prepareAdCandidates(350);

        List<PackageRecallDo> result = PrizeRecall.matchPrizeAndAd(pks,adPks,4);
        result.forEach(item -> System.out.println(item.getPackageInfoDo().getPackageIdDo().getPrizeGroup()));
        System.out.println("======================");

        List<PackageRecallDo> result2 = PrizeRecall.matchPrize(pks,4);
        result2.forEach(item -> System.out.println(item.getPackageInfoDo().getPackageIdDo().getPrizeGroup()));
        System.out.println("======================");

        List<CandidateActivityDo> activities = prepareActivityCandidates(100, 10);
        List<PackageInfoDo> adPks2 = prepareAdCandidates(350);
        List<CandidateActivityDo> replacedActs = AdReplacement.recallAdAndReplacePrize(activities, adPks2);
        replacedActs.forEach(item -> System.out.println(item.getPrizeGroup()));

    }
}
