package cn.com.duiba.nezha.alg.alg.vo.adx.pd;


import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * PD决策入参对象
 */
public class AdxPdDecisionRequestDo implements Serializable {

    private static final long serialVersionUID = -6404508184879770984L;

    /**
     * deal ID (tuiaDealId：推啊dealId，20位Long)
     */
    private Long dealId;

    /**
     * deal出价 (单位：分 / cpm * 10000)
     */
    private Long price;

    /**
     * 创意推荐结果对象
     */
    private AdxIdeaRcmdResultDo ideaRcmdResult;

    /**
     * 预发券结果对象(预发券Top3列表)
     */
    private List<AdxPredAdDo> adxPredAdDoList;

    /**
     * 创意点击参与融合数据--定时任务缓存获取
     */
    private AdxClickAndJoinDo mergeAdxClickAndJoinDo;

    /**
     * PD决策维稳对象--定时任务缓存获取
     */
    private AdxPdControlDo adxPdControlInfo;

    /**
     * 创意点击价值纠偏对象--定时任务缓存获取
     */
    private ClickValueRectifyDo clickValueRectify;

    /**
     * 创意统计数据
     */
    private AdxStatsDo ideaStats;

    /**
     * 创意+stratery+level统计数据(key为stratery)
     */
    private Map<String, AdxStrategyDo> strategyLevelStats;

    /**
     * 创意+clickValueLevel统计数据(key为clickValueLevel)
     */
    private Map<Integer, AdxStatsDo> clickValueLevelStats;

    /**
     * PD目标ROI(小数：1.15)
     */
    private Double targetRoi;


    public Long getDealId() {
        return dealId;
    }

    public void setDealId(Long dealId) {
        this.dealId = dealId;
    }

    public Long getPrice() { return price; }

    public void setPrice(Long price) {
        this.price = price;
    }

    public AdxIdeaRcmdResultDo getIdeaRcmdResult() {
        return ideaRcmdResult;
    }

    public void setIdeaRcmdResult(AdxIdeaRcmdResultDo ideaRcmdResult) {
        this.ideaRcmdResult = ideaRcmdResult;
    }

    public List<AdxPredAdDo> getAdxPredAdDoList() {
        return adxPredAdDoList;
    }

    public void setAdxPredAdDoList(List<AdxPredAdDo> adxPredAdDoList) {
        this.adxPredAdDoList = adxPredAdDoList;
    }

    public AdxClickAndJoinDo getMergeAdxClickAndJoinDo() {
        return mergeAdxClickAndJoinDo;
    }

    public void setMergeAdxClickAndJoinDo(AdxClickAndJoinDo mergeAdxClickAndJoinDo) {
        this.mergeAdxClickAndJoinDo = mergeAdxClickAndJoinDo;
    }

    public AdxPdControlDo getAdxPdControlInfo() {
        return adxPdControlInfo;
    }

    public void setAdxPdControlInfo(AdxPdControlDo adxPdControlInfo) {
        this.adxPdControlInfo = adxPdControlInfo;
    }

    public ClickValueRectifyDo getClickValueRectify() {
        return clickValueRectify;
    }

    public void setClickValueRectify(ClickValueRectifyDo clickValueRectify) {
        this.clickValueRectify = clickValueRectify;
    }

    public AdxStatsDo getIdeaStats() {
        return ideaStats;
    }

    public void setIdeaStats(AdxStatsDo ideaStats) {
        this.ideaStats = ideaStats;
    }

    public Map<String, AdxStrategyDo> getStrategyLevelStats() {
        return strategyLevelStats;
    }

    public void setStrategyLevelStats(Map<String, AdxStrategyDo> strategyLevelStats) {
        this.strategyLevelStats = strategyLevelStats;
    }

    public Map<Integer, AdxStatsDo> getClickValueLevelStats() {
        return clickValueLevelStats;
    }

    public void setClickValueLevelStats(Map<Integer, AdxStatsDo> clickValueLevelStats) {
        this.clickValueLevelStats = clickValueLevelStats;
    }

    public Double getTargetRoi() {
        return targetRoi;
    }

    public void setTargetRoi(Double targetRoi) {
        this.targetRoi = targetRoi;
    }
}
