/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterCntDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchPvFiltering {
    private static final Logger logger = LoggerFactory.getLogger(LaunchPvFiltering.class);

    public static FlowFilterResultDo getLaunchPvFiltering(FlowFilterRequestDo flowFilterRequestDo) {
        FlowFilterResultDo ret = new FlowFilterResultDo();
        try {
            AdxFlowInfoDo flowInfo;
            Integer flowFilterLabel = 0;
            Integer filterType = 0;
            boolean isConfident = false;
            Double preWeight = 0.8;
            Double flowerLimit = 0.0;
            Double fUpperLimit = 4.0;
            Double defaultValue = 0.01;
            Double preLaunchPv = null;
            if (LaunchPvFiltering.valid(flowFilterRequestDo).booleanValue()) {
                AdxFeatureDo adxFeatureDo = flowFilterRequestDo.getAdxFeatureDo();
                Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
                Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)adxFeatureDo, (AdxFeatureDo)adxFeatureDo);
                FeatureMapDo featureMapDo = new FeatureMapDo();
                featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
                featureMapDo.setStaticFeatureMap(staticFeatureMap);
                HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
                Long ideaId = flowFilterRequestDo.getFlowInfo().getIdeaId();
                featureMap.put(ideaId, featureMapDo);
                CODER launchPvCoderModel = flowFilterRequestDo.getLaunchPvCoderModel();
                LocalTFModel launchPvLtfModel = flowFilterRequestDo.getLaunchPvLtfModel();
                Map preValueMap = launchPvCoderModel.predictWithLocalTFNew(featureMap, launchPvLtfModel);
                preLaunchPv = (Double)preValueMap.get(ideaId);
            }
            if (AssertUtil.isNotEmpty((Object)(flowInfo = flowFilterRequestDo.getFlowInfo()))) {
                AdxIndexStatDo ideaMinStats = flowInfo.getIdeaMinStats();
                AdxIndexStatsDo ideaMinComputes = AdxStatData.adxIndexCompute(ideaMinStats);
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaMinComputes.getConfident() != false && ideaDayComputes.getConfident() != false;
                Map<Integer, AdxFilterCntDo> ideafilterDo = flowFilterRequestDo.getIdeafilterCntDo();
                Double minfilterRate = LaunchPvFiltering.getFilterRate(ideafilterDo, "20min");
                Double dayfilterRate = LaunchPvFiltering.getFilterRate(ideafilterDo, "1day");
                Double filterRate = Math.max(minfilterRate, dayfilterRate);
                Double statLaunchPv = AdxStatData.nullToDefault(ideaMinComputes.getLaunchPv(), ideaDayComputes.getLaunchPv());
                Double conLaunchPv = AdxStatData.getConValue(preLaunchPv, statLaunchPv, preWeight, flowerLimit, fUpperLimit, defaultValue);
                Double launchPvLimit = AdxStatData.nullToMinDefault(flowFilterRequestDo.getLaunchPvLimit(), 0.0);
                double random = Math.random();
                if (isConfident) {
                    if (conLaunchPv < launchPvLimit * 0.5) {
                        flowFilterLabel = random < 0.99 ? 1 : 0;
                    } else if (conLaunchPv < launchPvLimit * 0.7) {
                        flowFilterLabel = random < 0.9 ? 1 : 0;
                    } else if (conLaunchPv < launchPvLimit * 0.9) {
                        flowFilterLabel = random < 0.8 ? 1 : 0;
                    }
                }
                double random2 = Math.random();
                if (flowFilterLabel.equals(1)) {
                    if (filterRate > 0.8) {
                        flowFilterLabel = random < 0.2 ? 1 : 0;
                    } else if (filterRate > 0.5) {
                        flowFilterLabel = random2 < 0.5 ? 1 : 0;
                    }
                }
            }
            filterType = flowFilterLabel == 1 ? 2 : 0;
            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setFilterType(filterType);
            ret.setPreLaunchPv(preLaunchPv);
        }
        catch (Exception e) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering error " + e);
        }
        return ret;
    }

    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {
        Boolean ret = true;
        if (flowFilterRequestDo == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }
        if (flowFilterRequestDo.getLaunchPvLtfModel() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params launchPvLtfModel is null");
            return false;
        }
        if (flowFilterRequestDo.getLaunchPvCoderModel() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid , params launchPvCoderModel is null");
            return false;
        }
        if (flowFilterRequestDo.getAdxFeatureDo() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid ,params adxFeatureDo is null");
            return false;
        }
        if (flowFilterRequestDo.getFlowInfo() == null) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering() input params valid ,params flowInfo is null");
            return false;
        }
        return ret;
    }

    private static Double getFilterRate(Map<Integer, AdxFilterCntDo> ideafilterDo, String timeIndex) {
        Double ret = 0.0;
        if (AssertUtil.isNotEmpty(ideafilterDo)) {
            AdxFilterCntDo filterCntDo1 = Optional.ofNullable(ideafilterDo.get(0)).orElse(new AdxFilterCntDo());
            AdxFilterCntDo filterCntDo2 = Optional.ofNullable(ideafilterDo.get(1)).orElse(new AdxFilterCntDo());
            AdxFilterCntDo filterCntDo3 = Optional.ofNullable(ideafilterDo.get(2)).orElse(new AdxFilterCntDo());
            Long cnt1 = 0L;
            Long cnt2 = 0L;
            Long cnt3 = 0L;
            if (timeIndex.equals("20min")) {
                cnt1 = AdxStatData.nullToMinDefault(filterCntDo1.getLast20MinCnt(), 0L);
                cnt2 = AdxStatData.nullToMinDefault(filterCntDo2.getLast20MinCnt(), 0L);
                cnt3 = AdxStatData.nullToMinDefault(filterCntDo3.getLast20MinCnt(), 0L);
            } else if (timeIndex.equals("1day")) {
                cnt1 = AdxStatData.nullToMinDefault(filterCntDo1.getLast1DayCnt(), 0L);
                cnt2 = AdxStatData.nullToMinDefault(filterCntDo2.getLast1DayCnt(), 0L);
                cnt3 = AdxStatData.nullToMinDefault(filterCntDo3.getLast1DayCnt(), 0L);
            }
            if (AdxStatData.isLarger(cnt3, 10L) && AdxStatData.isLarger(cnt1 + cnt2 + cnt3, 30L)) {
                ret = DataUtil.division((Long)cnt3, (Long)(cnt1 + cnt2 + cnt3), (int)5);
            }
        }
        return AdxStatData.getNormalValue(ret, 0.0, 0.0, 1.0);
    }
}

