package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * adx流量过滤入参对象
 */


@Data
public class FlowFilterRequestDo implements Serializable {

    private static final long serialVersionUID = 8790187003832578709L;

    /**
     * adx流量信息
     */
    private AdxFlowInfoDo flowInfo;

    /**
     * adx流量过滤1.0-定时任务结果
     */
    private AdxFilterInfoDo filterInfo1;

    /**
     * adx流量过滤2.0-定时任务结果
     */
    AdxFilterInfoDo filterInfo2;

    /**
     * 点击率预估模型
     */
    private FM ctrFmModel;

    /**
     * 每pv发券编码器模型
     */
    private CODER launchPvCoderModel;

    /**
     * 每pv发券tf模型
     */
    private LocalTFModel launchPvLtfModel;

    /**
     * 流量特征对象
     */
    private AdxFeatureDo adxFeatureDo;

    /**
     * 算法出价模式(1-按roi出价, 2-按cpc出价)
     */
    private Integer algoBidMode;

    /**
     * 每pv发券阈值(小数)
     */
    private Double launchPvLimit;

    /**
     * 创意+filterType过滤竞价量级(key为filterType)
     */
    private Map<Integer, AdxFilterCntDo> ideafilterCntDo;

    /**
     * 资源位+filterType过滤竞价量级(key为filterType)
     */
    private Map<Integer, AdxFilterCntDo> resofilterCntDo;


}
