package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbBidAlg {

    private static final Logger logger = LoggerFactory.getLogger(RtbBidAlg.class);

    /**
     * RTB互动算法出价
     *
     * @param bidRequestDo
     * @return
     */
    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {

        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();

        try {

            if (valid(bidRequestDo)) {

                // 算法出价模式(1-按roi出价, 2-按cpc出价)
                Integer algoBidMode = bidRequestDo.getAdxDoInfo().getAlgoBidMode();

                if (AssertUtil.isNotEmpty(algoBidMode) && algoBidMode.equals(1)) {
                    ret = AdxRoiAlgoBid.getAdxAlgoPrice(bidRequestDo.getAdxDoInfo(), bidRequestDo.getAdxRoiControlInfo());

                } else if (AssertUtil.isNotEmpty(algoBidMode) && algoBidMode.equals(2)) {
                    ret = AdxCpcAlgoBid.getAdxAlgoPrice(bidRequestDo);

                }

            }

        } catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", e);
        }

        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param bidRequestDo
     * @return
     */
    private static Boolean valid(AdxRtbBidRequestDo bidRequestDo) {

        Boolean ret = true;

        if (AssertUtil.isEmpty(bidRequestDo)) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params bidRequestDo is null");

        } else if (AssertUtil.isEmpty(bidRequestDo.getAdxDoInfo())) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params adxDoInfo is null");
        }

        return ret;
    }

}