package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.MaterialFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSONObject;

import java.util.*;
import java.util.stream.Collectors;

public class MaterialRcmder {


    public static MaterialRcmdDo forkFeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map<Long, MaterialFeatureInfo> featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty(featureInfoMap)) {
            return null;
        }
        List<Long> idList = new ArrayList<>(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }

        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        // 旧版算法对应type为1
        materialRcmdDo.setType(1);
        // 获取素材id对应的特征，构建推荐结果对象
        Map<String, String> featureMap = new HashMap<>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo));
        System.out.println(featureMap.toString());
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        System.out.println(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    /**
     * 排序
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmd(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
//        ret = randomStrategy(materialExtractDo, materialFeatureDo);
        ret = rank(model, materialExtractDo, materialFeatureDo);
        return ret;
    }

    private static MaterialRcmdDo randomStrategy(MaterialExtractDo materialExtractDo,
                                                 MaterialFeatureDo materialFeatureDo) {
        List<MaterialMatchDo> materialMatchDoList = materialExtractDo.getMaterialMatchDoList();
        if (materialMatchDoList.size() < 1) {
            return null;
        }
        Collections.shuffle(materialMatchDoList);
        MaterialMatchDo materialMatchDo = materialMatchDoList.get(0);
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = materialMatchDo.getMaterialId();
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        // 随机策略对应type为0
        materialRcmdDo.setType(0);
        // 获取素材id对应的特征，构建推荐结果对象
        Map<String, String> featureMap = new HashMap<>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo));
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }


    public static MaterialRcmdDo rank(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList());
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    /**
     * @return 返回值说明
     * @description merge多路召回结果
     * @date 2020/7/24
     */
    private static Set<Long> mergeMultiRecallStrategy(MaterialExtractDo materialExtractDo) {
        Set<Long> recallMaterialSet = new HashSet<>();
        materialExtractDo.getMaterialMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        List<MaterialCostMatchDo> materialCostMatchDos = materialExtractDo.getMaterialCostMatchDoList();
        if (AssertUtil.isNotEmpty(materialCostMatchDos)) {
            materialCostMatchDos.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    private static RerankMaterial reRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map<Long, MaterialFeatureInfo> materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        double maxScore = -1;
        double rawScore = -1;
        Long resultId = -1L;
        Long oldOrderResultId = -1L;
        double oldMaxScore = -1;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }

        // 改为更为缓和的曝光降权方式，尽量保持模型的排序
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId)) {
                MaterialFeatureInfo materialFeatureInfo = materialFeatureInfoMap.get(materialId);
                if (null != materialFeatureInfo) {
                    UserMaterialFeature userMaterialFeature = materialFeatureInfo.getUserMaterialFeature();
                    if (null != userMaterialFeature) {
                        Long exposeCnt = userMaterialFeature.getUExposeDayCnt();
                        // 当天曝光降权
                        if (null != exposeCnt) {
                            double weight = Math.pow(Math.E, -0.09 * exposeCnt);
                            score = score * weight;
                        }
//                        // 根据过去7天的曝光次数降权，相对缓和
//                        Long exposeWeek = userMaterialFeature.getUExposeWeekCnt();
//                        Long clickWeek = userMaterialFeature.getUClickWeekCnt();
//                        if (null != exposeWeek) {
//                            // 用户过去7天曾经点击过该素材，基本无衰减，最低0.9
//                            if (null != clickWeek) {
//                                exposeWeek = Math.min(2, exposeWeek);
//                            } else {
//                                // 用户无点击过该素材，从曝光6次截断，保留0.65可能性
//                                exposeWeek = Math.min(6, exposeWeek);
//                            }
//                            double weight = 1.05 * Math.pow(Math.E, -0.08 * exposeWeek);
//                            score = score * weight;
//                        }
                    }
                }
            }
            preCTR.put(materialId, score);
            if (score > maxScore) {
                maxScore = score;
                resultId = materialId;
                rawScore = tmpScore;
            }
            if (tmpScore > oldMaxScore) {
                oldMaxScore = tmpScore;
                oldOrderResultId = materialId;
            }
        }

        // 判断重排后的素材是否在top5素材的平均水平的70%，防止出现非常差的素材
        List<MaterialMatchDo> sortedList = materialMatchDoList.stream()
                .sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed())
                .collect(Collectors.toList());
        int size = Math.min(5, sortedList.size());
        boolean flag = false;
        double sum = 0.0;
        for (int i = 0; i < size; i++) {
            sum += sortedList.get(i).getCtr();
        }
        double avgCtr = sum / size;
        double faithLevel = 0.7;
        double currCtr = 0.0;
        for (MaterialMatchDo materialMatchDo : materialMatchDoList) {
            if (resultId.equals(materialMatchDo.getMaterialId())) {
                currCtr = materialMatchDo.getCtr();
                break;
            }
        }
        if (currCtr >= avgCtr * faithLevel) {
            flag = true;
        }
        if (!flag) {
            resultId = oldOrderResultId;
            rawScore = oldMaxScore;
            maxScore = oldMaxScore;
        }

        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        return rerankMaterial;

    }


    public static void main(String[] args) {
        String string = " {\"deviceId\":\"7183214b04e218e99d43746c908b27b0\",\"materialFeatureMap\":{561:{\"bConvertWeekCnt\":2,\"clickDayCnt\":2720,\"clickWeekCnt\":1733,\"convertWeekCnt\":48,\"customization\":\"1431\",\"designHue\":\"1987\",\"exposeDayCnt\":163886,\"exposeWeekCnt\":93856,\"industry\":\"1407\",\"materialId\":561,\"rewardElement\":\"1899\",\"slotNature\":\"1443\"}},\"rid\":\"123456\",\"slotFeature\":{\"appId\":76235,\"appIndustryTagId\":\"198\",\"appIndustryTagPid\":\"196\",\"slotId\":352313,\"slotType\":9},\"slotMaterialFeatureMap\":{561:{\"slotBConvertHistCnt\":2,\"slotBConvertWeekCnt\":2,\"slotClickDayCnt\":2720,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1728,\"slotConvertHistCnt\":49,\"slotConvertWeekCnt\":48,\"slotExposeDayCnt\":163886,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":93851}},\"userFeature\":{\"age\":\"010212\",\"appList\":\"14924\",\"consumeLevel\":\"05011701\",\"expDayMaterials\":\"22099,3591,27170\",\"expWeekMaterials\":\"20200729203127-561,20200728093434-26869,20200728094320-27169,20200728094210-27170,20200723183928-27171\",\"marry\":\"01050303\",\"permanentProvince\":\"广西\",\"sex\":\"010102\"},\"userMaterialFeatureMap\":{561:{\"uExposeHistCnt\":3,\"uExposeInterval\":1,\"uExposePeriod\":5,\"uExposeWeekCnt\":3}}}";
        MaterialFeatureDo exp = JSONObject.parseObject(string, MaterialFeatureDo.class);
        MaterialRcmdDo ret = forkFeatureParse(exp);
        System.out.println(JSONObject.toJSONString(ret));
    }
}