/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.rtbbid.AdxCpcAlgoBid;
import cn.com.duiba.nezha.alg.alg.adx.rtbbid.AdxRoiAlgoBid;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbBidAlg {
    private static final Logger logger = LoggerFactory.getLogger(RtbBidAlg.class);

    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {
        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();
        try {
            if (RtbBidAlg.valid(bidRequestDo).booleanValue()) {
                Integer algoBidMode = bidRequestDo.getAdxDoInfo().getAlgoBidMode();
                if (AssertUtil.isNotEmpty((Object)algoBidMode) && algoBidMode.equals(1)) {
                    ret = AdxRoiAlgoBid.getAdxAlgoPrice(bidRequestDo.getAdxDoInfo(), bidRequestDo.getAdxRoiControlInfo());
                } else if (AssertUtil.isNotEmpty((Object)algoBidMode) && algoBidMode.equals(2)) {
                    ret = AdxCpcAlgoBid.getAdxAlgoPrice(bidRequestDo);
                }
            }
        }
        catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", (Throwable)e);
        }
        return ret;
    }

    private static Boolean valid(AdxRtbBidRequestDo bidRequestDo) {
        Boolean ret = true;
        if (AssertUtil.isEmpty((Object)bidRequestDo)) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params bidRequestDo is null");
        } else if (AssertUtil.isEmpty((Object)bidRequestDo.getAdxDoInfo())) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params adxDoInfo is null");
        }
        return ret;
    }
}

