/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.MaterialCostMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialExtractDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.material.RerankMaterial;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.MaterialFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureInfo;
import cn.com.duiba.nezha.alg.feature.vo.UserMaterialFeature;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MaterialRcmder {
    public static MaterialRcmdDo forkFeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty((Map)featureInfoMap)) {
            return null;
        }
        ArrayList idList = new ArrayList(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = (Long)idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        materialRcmdDo.setType(1);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo));
        System.out.println(((Object)featureMap).toString());
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        System.out.println(MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    public static MaterialRcmdDo rcmd(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        ret = MaterialRcmder.rank(model, materialExtractDo, materialFeatureDo);
        return ret;
    }

    private static MaterialRcmdDo randomStrategy(MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) {
        List<MaterialMatchDo> materialMatchDoList = materialExtractDo.getMaterialMatchDoList();
        if (materialMatchDoList.size() < 1) {
            return null;
        }
        Collections.shuffle(materialMatchDoList);
        MaterialMatchDo materialMatchDo = materialMatchDoList.get(0);
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = materialMatchDo.getMaterialId();
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        materialRcmdDo.setType(0);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo));
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    public static MaterialRcmdDo rank(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }
        HashMap<Long, Double> preCTR = new HashMap();
        preCTR = model.predictsNew(featureDoMap);
        RerankMaterial rerankMaterial = MaterialRcmder.reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList());
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        if (reRankId < 0L) {
            return null;
        }
        ret.setMaterialId(reRankId);
        featureMapDo = (FeatureMapDo)featureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        return ret;
    }

    private static Set<Long> mergeMultiRecallStrategy(MaterialExtractDo materialExtractDo) {
        HashSet<Long> recallMaterialSet = new HashSet<Long>();
        materialExtractDo.getMaterialMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        List<MaterialCostMatchDo> materialCostMatchDos = materialExtractDo.getMaterialCostMatchDoList();
        if (AssertUtil.isNotEmpty(materialCostMatchDos)) {
            materialCostMatchDos.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    private static RerankMaterial reRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        double maxScore = -1.0;
        double rawScore = -1.0;
        Long resultId = -1L;
        Long oldOrderResultId = -1L;
        double oldMaxScore = -1.0;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            Long exposeCnt;
            UserMaterialFeature userMaterialFeature;
            MaterialFeatureInfo materialFeatureInfo;
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId) && null != (materialFeatureInfo = (MaterialFeatureInfo)materialFeatureInfoMap.get(materialId)) && null != (userMaterialFeature = materialFeatureInfo.getUserMaterialFeature()) && null != (exposeCnt = userMaterialFeature.getUExposeDayCnt())) {
                double weight = Math.pow(Math.E, -0.09 * (double)exposeCnt.longValue());
                score *= weight;
            }
            preCTR.put(materialId, score);
            if (score > maxScore) {
                maxScore = score;
                resultId = materialId;
                rawScore = tmpScore;
            }
            if (!(tmpScore > oldMaxScore)) continue;
            oldMaxScore = tmpScore;
            oldOrderResultId = materialId;
        }
        List sortedList = materialMatchDoList.stream().sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed()).collect(Collectors.toList());
        int size = Math.min(5, sortedList.size());
        boolean flag = false;
        double sum = 0.0;
        for (int i = 0; i < size; ++i) {
            sum += ((MaterialMatchDo)sortedList.get(i)).getCtr().doubleValue();
        }
        double avgCtr = sum / (double)size;
        double faithLevel = 0.7;
        double currCtr = 0.0;
        for (MaterialMatchDo materialMatchDo : materialMatchDoList) {
            if (!resultId.equals(materialMatchDo.getMaterialId())) continue;
            currCtr = materialMatchDo.getCtr();
            break;
        }
        if (currCtr >= avgCtr * faithLevel) {
            flag = true;
        }
        if (!flag) {
            resultId = oldOrderResultId;
            rawScore = oldMaxScore;
            maxScore = oldMaxScore;
        }
        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        return rerankMaterial;
    }

    public static void main(String[] args) {
        String string = " {\"deviceId\":\"7183214b04e218e99d43746c908b27b0\",\"materialFeatureMap\":{561:{\"bConvertWeekCnt\":2,\"clickDayCnt\":2720,\"clickWeekCnt\":1733,\"convertWeekCnt\":48,\"customization\":\"1431\",\"designHue\":\"1987\",\"exposeDayCnt\":163886,\"exposeWeekCnt\":93856,\"industry\":\"1407\",\"materialId\":561,\"rewardElement\":\"1899\",\"slotNature\":\"1443\"}},\"rid\":\"123456\",\"slotFeature\":{\"appId\":76235,\"appIndustryTagId\":\"198\",\"appIndustryTagPid\":\"196\",\"slotId\":352313,\"slotType\":9},\"slotMaterialFeatureMap\":{561:{\"slotBConvertHistCnt\":2,\"slotBConvertWeekCnt\":2,\"slotClickDayCnt\":2720,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1728,\"slotConvertHistCnt\":49,\"slotConvertWeekCnt\":48,\"slotExposeDayCnt\":163886,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":93851}},\"userFeature\":{\"age\":\"010212\",\"appList\":\"14924\",\"consumeLevel\":\"05011701\",\"expDayMaterials\":\"22099,3591,27170\",\"expWeekMaterials\":\"20200729203127-561,20200728093434-26869,20200728094320-27169,20200728094210-27170,20200723183928-27171\",\"marry\":\"01050303\",\"permanentProvince\":\"\u5e7f\u897f\",\"sex\":\"010102\"},\"userMaterialFeatureMap\":{561:{\"uExposeHistCnt\":3,\"uExposeInterval\":1,\"uExposePeriod\":5,\"uExposeWeekCnt\":3}}}";
        MaterialFeatureDo exp = (MaterialFeatureDo)JSONObject.parseObject((String)string, MaterialFeatureDo.class);
        MaterialRcmdDo ret = MaterialRcmder.forkFeatureParse(exp);
        System.out.println(JSONObject.toJSONString((Object)ret));
    }
}

