/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.plugins.ResPlugInStatModel;
import cn.com.duiba.nezha.alg.alg.vo.plug.PreSelectActResPlugDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActPlugInDQNRcmder2 {
    private static final Logger logger = LoggerFactory.getLogger(ActPlugInDQNRcmder2.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] pCpmBucket = new double[]{0.5, 0.8, 0.9, 0.95, 0.98, 1.0};
    static double[] pCpmWeight = new double[]{0.2, 1.0, 2.0, 3.0, 5.0, 100.0};

    public static ResPlugInRcmdDo rcmd3(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo, CODER coderModel, LocalTFModel ltfModel, List<PreSelectActResPlugDo> preSelectActResPlugIndexDoList, List<PreSelectActResPlugDo> preSelectActResPlugIdDoList) throws Exception {
        return ActPlugInDQNRcmder2.rcmdIndexAndIdBase(plugList, actFeatureDo, coderModel, ltfModel, preSelectActResPlugIndexDoList, preSelectActResPlugIdDoList, 3, 1.0);
    }

    public static ResPlugInRcmdDo rcmdIndexAndIdBase(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo, CODER coderModel, LocalTFModel ltfModel, List<PreSelectActResPlugDo> preSelectActResPlugIndexDoList, List<PreSelectActResPlugDo> preSelectActResPlugIdDoList, int rcmd_type, Double statWeight) throws Exception {
        ResPlugInRcmdDo ret = null;
        if (ActPlugInDQNRcmder2.valid(plugList, actFeatureDo).booleanValue()) {
            HashMap<String, Map> featureMap = new HashMap<String, Map>();
            Map staticFeatureMap = ActFeatureParse.generateFeatureMapStatic((ActFeatureDo)actFeatureDo);
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                resPlugInRcmdDo.setKey();
                String key = resPlugInRcmdDo.getKey();
                ResPlugInStatDo statDo = resPlugInRcmdDo.getResPlugInStatDo();
                resPlugInRcmdDo.setSRpm(ResPlugInStatModel.getRpm(statDo));
                resPlugInRcmdDo.setSRoi(ResPlugInStatModel.getRoi(statDo));
                ActFeatureDo dynamicDo = new ActFeatureDo();
                dynamicDo.setResPlugInId(resPlugInRcmdDo.getResPlugInId());
                dynamicDo.setResPlugInIndex(resPlugInRcmdDo.getResPlugInIndex());
                Map dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic((ActFeatureDo)dynamicDo, (ActFeatureDo)actFeatureDo);
                dynamicFeatureMap.putAll(staticFeatureMap);
                featureMap.put(key, dynamicFeatureMap);
            }
            Map pRpmMap = new HashMap();
            if (ActPlugInDQNRcmder2.validModel(coderModel, ltfModel).booleanValue()) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            HashMap<Long, List<ResPlugInRcmdDo>> rcmdIndexMap = new HashMap<Long, List<ResPlugInRcmdDo>>();
            HashMap<Long, List<ResPlugInRcmdDo>> rcmdPlugMap = new HashMap<Long, List<ResPlugInRcmdDo>>();
            HashMap<String, ResPlugInRcmdDo> rcmdMap = new HashMap<String, ResPlugInRcmdDo>();
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                String key = resPlugInRcmdDo.getKey();
                Double pRpm = (Double)pRpmMap.get(key);
                resPlugInRcmdDo.setPRpm(pRpm);
                Double mergeRpm = ActPlugInDQNRcmder2.getMergeRpm(pRpm, resPlugInRcmdDo.getSRpm(), statWeight);
                resPlugInRcmdDo.setMergeRpm(mergeRpm);
                Long plugId = resPlugInRcmdDo.getResPlugInId();
                Long plugIndex = resPlugInRcmdDo.getResPlugInIndex();
                if (!rcmdIndexMap.containsKey(plugIndex)) {
                    rcmdIndexMap.put(plugIndex, new ArrayList());
                }
                if (!rcmdPlugMap.containsKey(plugId)) {
                    rcmdPlugMap.put(plugId, new ArrayList());
                }
                if (plugId != null && plugIndex != null && plugIndex > 4L || plugId != null && plugIndex == null && plugIndex > 4L || plugId == null && plugIndex != null) continue;
                ((List)rcmdIndexMap.get(plugIndex)).add(resPlugInRcmdDo);
                ((List)rcmdPlugMap.get(plugId)).add(resPlugInRcmdDo);
                rcmdMap.put(plugId + "-" + plugIndex, resPlugInRcmdDo);
            }
            Map<Long, PreSelectActResPlugDo> preSelectActResPlugIndexDoMap = ActPlugInDQNRcmder2.getLastSelectPlug(preSelectActResPlugIndexDoList, rcmdIndexMap, 2);
            Map<Long, PreSelectActResPlugDo> preSelectActResPlugIdDoMap = ActPlugInDQNRcmder2.getLastSelectPlug(preSelectActResPlugIdDoList, rcmdPlugMap, 1);
            if (rcmd_type == 2) {
                ret = ActPlugInDQNRcmder2.rcmdWithMap3(rcmdIndexMap, rcmdPlugMap, rcmdMap);
            }
            if (rcmd_type == 1) {
                ret = ActPlugInDQNRcmder2.rcmdWithMap2041(rcmdPlugMap);
            }
            if (rcmd_type == 3) {
                ret = AssertUtil.isAnyEmpty((Object[])new Object[]{preSelectActResPlugIdDoMap, preSelectActResPlugIndexDoMap}) ? ActPlugInDQNRcmder2.rcmdWithMap4(rcmdIndexMap, rcmdPlugMap, rcmdMap) : (Math.random() < 0.98 ? ActPlugInDQNRcmder2.rcmdWithPreSelectMap(preSelectActResPlugIndexDoMap, preSelectActResPlugIdDoMap, rcmdMap) : ActPlugInDQNRcmder2.rcmdWithMap4(rcmdIndexMap, rcmdPlugMap, rcmdMap));
            }
            if (ret == null) {
                ret = (ResPlugInRcmdDo)rcmdMap.get("null-null");
            }
        }
        return ret;
    }

    private static Boolean valid(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{plugList, actFeatureDo})) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }
        return ret;
    }

    public static Map<Long, PreSelectActResPlugDo> getLastSelectPlug(List<PreSelectActResPlugDo> preSelectActResPlugDoList, Map<Long, List<ResPlugInRcmdDo>> rcmdKeyMap, int type) {
        HashMap<Long, PreSelectActResPlugDo> ret = new HashMap();
        HashMap groupMap = new HashMap();
        Date lastDateTime = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{preSelectActResPlugDoList, rcmdKeyMap})) {
            for (int i = 0; i < preSelectActResPlugDoList.size(); ++i) {
                Long key;
                PreSelectActResPlugDo preSelectActResPlugDo = preSelectActResPlugDoList.get(i);
                if (preSelectActResPlugDo == null) continue;
                Date cDateTime = preSelectActResPlugDo.getCurDate();
                Long index = preSelectActResPlugDo.getResPlugInIndex();
                Long id = preSelectActResPlugDo.getResPlugInId();
                if (!groupMap.containsKey(cDateTime)) {
                    groupMap.put(cDateTime, new HashMap());
                }
                Long l = key = type == 1 ? id : index;
                if (type == 1 && key == null) continue;
                if (!((Map)groupMap.get(cDateTime)).containsKey(key) && rcmdKeyMap.containsKey(key)) {
                    ((Map)groupMap.get(cDateTime)).put(key, preSelectActResPlugDo);
                }
                if (lastDateTime == null) {
                    lastDateTime = cDateTime;
                    continue;
                }
                if (!lastDateTime.before(cDateTime)) continue;
                lastDateTime = cDateTime;
            }
        }
        ret = (Map)groupMap.get(lastDateTime);
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap3(Map<Long, List<ResPlugInRcmdDo>> plugIndexMap, Map<Long, List<ResPlugInRcmdDo>> plugIdMap, Map<String, ResPlugInRcmdDo> rcmdMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{plugIndexMap, plugIdMap})) {
            HashMap<Long, ResPlugInStatDo> indexMap = new HashMap<Long, ResPlugInStatDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIndexMap.entrySet()) {
                Long index = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                ResPlugInStatDo resPlugInStatDo = ResPlugInStatModel.mergeIndexList(plugIndexList);
                indexMap.put(index, resPlugInStatDo);
            }
            Long plugIndex = ActPlugInDQNRcmder2.rcmdIndex(indexMap);
            List<ResPlugInRcmdDo> indexPlugList = plugIndexMap.get(plugIndex);
            if (plugIndex == null) {
                ret = ActPlugInDQNRcmder2.rcmd(indexPlugList, false);
            } else {
                HashMap<Long, ResPlugInStatDo> idMap = new HashMap<Long, ResPlugInStatDo>();
                for (Map.Entry entry : plugIdMap.entrySet()) {
                    Long id = (Long)entry.getKey();
                    List plugIdList = (List)entry.getValue();
                    ResPlugInStatDo idStatDo = ResPlugInStatModel.mergeIdList(plugIdList);
                    idMap.put(id, idStatDo);
                }
                Long plugId = ActPlugInDQNRcmder2.rcmdId(idMap);
                ret = rcmdMap.get(plugId + "-" + plugIndex);
            }
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap4(Map<Long, List<ResPlugInRcmdDo>> plugIndexMap, Map<Long, List<ResPlugInRcmdDo>> plugIdMap, Map<String, ResPlugInRcmdDo> rcmdMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{plugIndexMap, plugIdMap})) {
            HashMap<Long, ResPlugInStatDo> indexMap = new HashMap<Long, ResPlugInStatDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIndexMap.entrySet()) {
                Long index = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                ResPlugInStatDo indexStatDo = ResPlugInStatModel.mergeIndexList(plugIndexList);
                indexMap.put(index, indexStatDo);
            }
            Long plugIndex = ActPlugInDQNRcmder2.rcmdRandom(indexMap);
            Long plugId = null;
            List<ResPlugInRcmdDo> indexPlugList = plugIndexMap.get(plugIndex);
            if (plugIndex != null) {
                HashMap<Long, ResPlugInStatDo> idMap = new HashMap<Long, ResPlugInStatDo>();
                for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIdMap.entrySet()) {
                    Long id = entry.getKey();
                    List<ResPlugInRcmdDo> plugIdList = entry.getValue();
                    ResPlugInStatDo idStatDo = ResPlugInStatModel.mergeIdList(plugIdList);
                    if (id == null) continue;
                    idMap.put(id, idStatDo);
                }
                plugId = ActPlugInDQNRcmder2.rcmdRandom(idMap);
            }
            ret = rcmdMap.get(plugId + "-" + plugIndex);
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithPreSelectMap(Map<Long, PreSelectActResPlugDo> preSelectActResPlugIndexDoMap, Map<Long, PreSelectActResPlugDo> preSelectActResPlugIdDoMap, Map<String, ResPlugInRcmdDo> rcmdMap) {
        ResPlugInRcmdDo ret = null;
        Long plugIndex = ActPlugInDQNRcmder2.rcmdIndexAndIdWithSelect(preSelectActResPlugIndexDoMap, 2);
        Long plugId = null;
        if (plugIndex != null) {
            plugId = ActPlugInDQNRcmder2.rcmdIndexAndIdWithSelect(preSelectActResPlugIdDoMap, 1);
        }
        ret = rcmdMap.get(plugId + "-" + plugIndex);
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap2(Map<Long, List<ResPlugInRcmdDo>> plugMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            List<ResPlugInRcmdDo> plugIndexList;
            ArrayList<ResPlugInRcmdDo> plugList = new ArrayList<ResPlugInRcmdDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                ResPlugInRcmdDo plugRcmdDo;
                List<ResPlugInRcmdDo> plugIndexList2 = entry.getValue();
                if (AssertUtil.isEmpty(plugIndexList2)) continue;
                if (plugIndexList2.size() == 1) {
                    plugRcmdDo = plugIndexList2.get(0);
                    plugList.add(plugRcmdDo);
                    continue;
                }
                plugRcmdDo = ActPlugInDQNRcmder2.getBestIndex(plugIndexList2);
                if (plugRcmdDo == null) continue;
                plugList.add(plugRcmdDo);
            }
            ret = ActPlugInDQNRcmder2.rcmd(plugList, false);
            if (ret != null && ret.getResPlugInId() != null && (plugIndexList = plugMap.get(ret.getResPlugInId())) != null && plugIndexList.size() > 1) {
                ret = ActPlugInDQNRcmder2.rcmd(plugIndexList, true);
            }
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap(Map<Long, List<ResPlugInRcmdDo>> plugMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            ArrayList<ResPlugInRcmdDo> plugList = new ArrayList<ResPlugInRcmdDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                ResPlugInRcmdDo plugRcmdDo;
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                if (plugIndexList != null && plugIndexList.size() == 1) {
                    plugRcmdDo = plugIndexList.get(0);
                    plugList.add(plugRcmdDo);
                    continue;
                }
                plugRcmdDo = ActPlugInDQNRcmder2.rcmd(plugIndexList, true);
                if (plugRcmdDo == null) continue;
                plugList.add(plugRcmdDo);
            }
            ret = ActPlugInDQNRcmder2.rcmd(plugList, false);
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap2041(Map<Long, List<ResPlugInRcmdDo>> plugMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            HashMap<Long, ResPlugInRcmdDo> plugIndexMap = new HashMap<Long, ResPlugInRcmdDo>();
            HashMap<ResPlugInRcmdDo, Double> weightMap = new HashMap<ResPlugInRcmdDo, Double>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                Long plugId = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                if (plugId == null) {
                    if (!AssertUtil.isNotEmpty(plugIndexList)) continue;
                    plugIndexMap.put(null, plugIndexList.get(0));
                    weightMap.put(plugIndexList.get(0), 1.0);
                    continue;
                }
                if (!plugId.equals(2041L) || !AssertUtil.isNotEmpty(plugIndexList)) continue;
                for (int i = 0; i < plugIndexList.size(); ++i) {
                    ResPlugInRcmdDo resPlugInRcmdDo = plugIndexList.get(i);
                    if (resPlugInRcmdDo == null) continue;
                    plugIndexMap.put(resPlugInRcmdDo.getResPlugInIndex(), resPlugInRcmdDo);
                    weightMap.put(resPlugInRcmdDo, 1.0);
                }
            }
            ret = (ResPlugInRcmdDo)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static ResPlugInRcmdDo getBestIndex(List<ResPlugInRcmdDo> plugIndexList) {
        ResPlugInRcmdDo ret = null;
        long size = plugIndexList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        int i = 0;
        while ((long)i < size) {
            ResPlugInRcmdDo plugDo = plugIndexList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
                ret = plugDo;
            }
            ++i;
        }
        if (ret == null && plugIndexList != null) {
            ret = plugIndexList.get(0);
        }
        return ret;
    }

    public static Long rcmdIndexAndIdWithSelect(Map<Long, PreSelectActResPlugDo> plugMap, int type) {
        Long ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            ArrayList<Long> indexList = new ArrayList<Long>(plugMap.keySet());
            int size = indexList.size();
            HashMap<Long, Double> weightMap = new HashMap<Long, Double>(MAP_DF_SIZE);
            for (int i = 0; i < size; ++i) {
                Double subWeight;
                Long key = (Long)indexList.get(i);
                if (type == 1 && key == null) continue;
                PreSelectActResPlugDo selectDo = plugMap.get(key);
                Integer isBest = selectDo.getIsBest();
                Double oWeight = selectDo.getScore();
                if (isBest != null && isBest > 0) {
                    subWeight = oWeight != null ? oWeight * 100.0 : 60.0;
                    weightMap.put(key, subWeight);
                    continue;
                }
                subWeight = oWeight != null ? oWeight * 100.0 : 7.0;
                weightMap.put(key, Math.min(subWeight, 7.0));
            }
            ret = (Long)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static Long rcmdRandom(Map<Long, ResPlugInStatDo> indexMap) {
        Long ret = null;
        HashMap<Long, Double> weightMap = new HashMap<Long, Double>(MAP_DF_SIZE);
        if (AssertUtil.isNotEmpty(indexMap)) {
            for (Map.Entry<Long, ResPlugInStatDo> entry : indexMap.entrySet()) {
                Long key = entry.getKey();
                weightMap.put(key, 1.0);
            }
            ret = (Long)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static Long rcmdIndex(Map<Long, ResPlugInStatDo> indexMap) {
        Long ret = null;
        Double bestRpm = null;
        Long bestIndex = null;
        if (AssertUtil.isNotEmpty(indexMap)) {
            Double rpm;
            ArrayList<Long> indexList = new ArrayList<Long>(indexMap.keySet());
            int size = indexList.size();
            HashMap<Long, Double> indexRpmMap = new HashMap<Long, Double>();
            for (int i = 0; i < size; ++i) {
                Long index = (Long)indexList.get(i);
                ResPlugInStatDo statDo = indexMap.get(index);
                rpm = ResPlugInStatModel.getRpm(statDo);
                indexRpmMap.put(index, rpm);
                if (rpm == null || index == null || bestRpm != null && !(bestRpm < rpm)) continue;
                bestRpm = rpm;
                bestIndex = index;
            }
            HashMap<Long, Double> weightMap = new HashMap<Long, Double>(MAP_DF_SIZE);
            for (int i = 0; i < size; ++i) {
                Long index = (Long)indexList.get(i);
                rpm = (Double)indexRpmMap.get(index);
                if (index != null && index.equals(bestIndex)) {
                    weightMap.put(index, 85.0);
                    continue;
                }
                weightMap.put(index, 3.0);
            }
            ret = (Long)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static Long rcmdId(Map<Long, ResPlugInStatDo> idMap) {
        Long ret = null;
        Double bestRpm = null;
        Long bestIndex = null;
        if (AssertUtil.isNotEmpty(idMap)) {
            Long id;
            int i;
            ArrayList<Long> idList = new ArrayList<Long>(idMap.keySet());
            int size = idList.size();
            HashMap<Long, Double> indexRpmMap = new HashMap<Long, Double>();
            for (int i2 = 0; i2 < size; ++i2) {
                Long index = (Long)idList.get(i2);
                ResPlugInStatDo statDo = idMap.get(index);
                Double rpm = ResPlugInStatModel.getRpm(statDo);
                indexRpmMap.put(index, rpm);
                if (rpm == null || bestRpm != null && !(bestRpm < rpm)) continue;
                bestRpm = rpm;
                bestIndex = index;
            }
            HashMap<Long, Double> weightMap = new HashMap<Long, Double>(MAP_DF_SIZE);
            Double weightSum = 0.0;
            for (i = 0; i < size; ++i) {
                id = (Long)idList.get(i);
                Double rpm = (Double)indexRpmMap.get(id);
                Double weight = ActPlugInDQNRcmder2.getRpmWeight(rpm, bestRpm);
                if (rpm == null) {
                    weight = 2.0;
                }
                if (weight != null) {
                    weightMap.put(id, weight);
                    weightSum = weightSum + weight;
                    continue;
                }
                weightMap.put(id, 1.0);
                weightSum = weightSum + 1.0;
            }
            for (i = 0; i < size; ++i) {
                Double weightOther;
                id = (Long)idList.get(i);
                if (id == null) continue;
                Double weight = (Double)weightMap.get(id);
                if (bestRpm == null) continue;
                if (bestIndex != null && bestIndex.equals(id) && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.85 / 0.15000000000000002;
                    weightSum = weightOther + weight;
                    weightMap.put(id, weight);
                }
                if (bestIndex != null || id != null || !(weight < weightSum)) continue;
                weightOther = weightSum - weight;
                weight = weightOther * 0.85 / 0.15000000000000002;
                weightSum = weightOther + weight;
                weightMap.put(id, weight);
            }
            ret = (Long)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList, boolean isIndex) {
        Double weight;
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isEmpty(plugList)) {
            return ret;
        }
        long size = plugList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        Double baseRpm = null;
        if (size == 1L) {
            return plugList.get(0);
        }
        int i = 0;
        while ((long)i < size) {
            ResPlugInRcmdDo plugDo = plugList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
            }
            if (plugDo.getResPlugInId() == null && plugDo.getResPlugInIndex() == null) {
                baseRpm = plugDo.getMergeRpm();
            }
            ++i;
        }
        HashMap<ResPlugInRcmdDo, Double> weightMap = new HashMap<ResPlugInRcmdDo, Double>(MAP_DF_SIZE);
        Double weightSum = 0.0;
        int i2 = 0;
        while ((long)i2 < size) {
            ResPlugInRcmdDo plugDo = plugList.get(i2);
            Double rpm = plugDo.getMergeRpm();
            weight = ActPlugInDQNRcmder2.getRpmWeight(rpm, bestRpm);
            if (plugDo.getSRpm() == null) {
                weight = MathBase.noiseSmoother(weight, 1.0, 2.0);
            }
            if (plugDo.getSRpm() != null && weight < 1.0 && Math.random() > 0.5) {
                weight = 0.1;
            }
            if (weight != null) {
                weightMap.put(plugDo, weight);
                weightSum = weightSum + weight;
            } else {
                weightMap.put(plugDo, 1.0);
                weightSum = weightSum + 1.0;
            }
            ++i2;
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            Double weightOther;
            ResPlugInRcmdDo plugDo = (ResPlugInRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (isIndex) {
                if (plugDo.getResPlugInIndex() == 3L && weight > weightSum * 0.05 && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.05 / 0.95;
                    weightSum = weightOther + weight;
                    weightMap.put(plugDo, weight);
                }
                if (bestRpmKey != null && plugDo != null && bestRpmKey.equals(plugDo.getKey()) && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.9 / 0.09999999999999998;
                    weightSum = weightOther + weight;
                    weightMap.put(plugDo, weight);
                }
            }
            if (!isIndex) {
                if (plugDo.getResPlugInIndex() == null && weight > weightSum * 0.2 && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.2 / 0.8;
                    weightSum = weightOther + weight;
                    weightMap.put(plugDo, weight);
                }
                if (bestRpmKey != null && plugDo != null && plugDo.getSRpm() != null && bestRpmKey.equals(plugDo.getKey()) && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.85 / 0.15000000000000002;
                    weightSum = weightOther + weight;
                }
            }
            weightMap.put(plugDo, weight);
        }
        ret = (ResPlugInRcmdDo)Roulette.doubleMap(weightMap);
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    private static Double getMergeRpm(Double pRpm, Double sRpm, double statWeight) {
        Double ret = pRpm;
        if (pRpm == null) {
            ret = sRpm;
        }
        if (sRpm != null && pRpm != null) {
            if (sRpm <= 0.0) {
                sRpm = 0.0;
            } else {
                pRpm = MathBase.noiseSmoother(pRpm, 0.5 * sRpm, 2.0 * sRpm);
            }
            ret = (1.0 - statWeight) * pRpm + statWeight * sRpm;
        }
        return ret;
    }
}

