/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.pddecision;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.predict.AdxClickValuePredict;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdDecisionRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdDecisionResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdDecisionAlg {
    private static final Logger logger = LoggerFactory.getLogger(PdDecisionAlg.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int[] CLICK_VALUE_BUCKET = new int[]{1, 2, 3, 5, 7, 10, 20, 50, 100};

    public static AdxPdDecisionResultDo getPdDecision(AdxPdDecisionRequestDo decisionRequestDo) {
        AdxPdDecisionResultDo ret = new AdxPdDecisionResultDo();
        try {
            Double preCtrWeight = 0.8;
            Double preCvaWeight = 0.5;
            Double preAdWeight = 0.1;
            Long giveUpType = PdDecisionAlg.getGiveUpType(decisionRequestDo);
            Integer isGiveUp = 0;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_ONE.getCode();
            Double rectifyFactor = 1.0;
            Double controlFactor = 1.0;
            Double lowerLimit = 0.5;
            Double upperLimit = 1.5;
            Double giveUpRate = 0.9;
            Integer warnLabel = 0;
            if (AssertUtil.isNotEmpty((Object)decisionRequestDo)) {
                Map<Integer, Double> rectifyFactorMap;
                Long ideaId = null;
                Double preCtr = null;
                Double statCtr = null;
                Double statCtrDay = null;
                Double resoStatCtr = null;
                Double preClickValue = null;
                Double statClickValue = null;
                Double statClickValueDay = null;
                Double resoStatClickValue = null;
                AdxIdeaRcmdResultDo ideaRcmdResult = decisionRequestDo.getIdeaRcmdResult();
                if (AssertUtil.isNotEmpty((Object)ideaRcmdResult)) {
                    ideaId = ideaRcmdResult.getIdeaId();
                    preCtr = ideaRcmdResult.getPreCtr();
                    statCtr = ideaRcmdResult.getStatCtr();
                    resoStatCtr = ideaRcmdResult.getStatCtrResource();
                    preClickValue = ideaRcmdResult.getPreClickValue();
                    statClickValue = ideaRcmdResult.getStatClickValue();
                    resoStatClickValue = ideaRcmdResult.getStatClickValueResource();
                    giveUpType = ideaRcmdResult.getGiveUpType();
                }
                boolean isConfident = false;
                Long ideaAdxCostDay = 0L;
                Long ideaAdConsumeDay = 0L;
                AdxStatsDo ideaStats = decisionRequestDo.getIdeaStats();
                if (AssertUtil.isNotEmpty((Object)ideaStats)) {
                    AdxIndexStatDo last1DayStat = ideaStats.getLast1DayStat();
                    AdxIndexStatDo last20MinStat = ideaStats.getLast20MinStat();
                    AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(last1DayStat);
                    AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(last20MinStat);
                    ideaAdxCostDay = ideaStatsDay.getAdxConsume();
                    ideaAdConsumeDay = ideaStatsDay.getAdvertConsume();
                    statCtr = AdxStatData.nullToDefault(statCtr, ideaStatsMin.getCtr());
                    statClickValue = AdxStatData.nullToDefault(statClickValue, ideaStatsMin.getClickValue());
                    statCtrDay = ideaStatsDay.getCtr();
                    statClickValueDay = ideaStatsDay.getClickValue();
                    if (ideaStatsDay.getConfident().booleanValue() && ideaStatsMin.getConfident().booleanValue()) {
                        isConfident = true;
                    }
                }
                if (ideaAdxCostDay <= 0L && ideaAdConsumeDay > 500L) {
                    warnLabel = 1;
                    logger.warn(String.format("AdxPdAlgo AdxConsume Exception Logging, DealId: %s; IdeaId: %s]; IdeaAdxConsumeDay: %s; IdeaAdvertConsumeDay: %s;", JSONObject.toJSONString((Object)decisionRequestDo.getDealId()), JSONObject.toJSONString((Object)ideaId), JSONObject.toJSONString((Object)ideaAdxCostDay), JSONObject.toJSONString((Object)ideaAdConsumeDay)));
                }
                AdxClickAndJoinDo mergeAdxClickAndJoinDo = decisionRequestDo.getMergeAdxClickAndJoinDo();
                List<AdxPredAdDo> adxPredAdDoList = decisionRequestDo.getAdxPredAdDoList();
                Double preAdClickValue = AdxClickValuePredict.getPredClickValue(mergeAdxClickAndJoinDo, adxPredAdDoList);
                Integer clickValueLevel = AdxStatData.bucket(preClickValue, CLICK_VALUE_BUCKET);
                ClickValueRectifyDo clickValueRectify = decisionRequestDo.getClickValueRectify();
                if (AssertUtil.isNotEmpty((Object)clickValueRectify) && AssertUtil.isNotEmpty(rectifyFactorMap = clickValueRectify.getRectifyFactorMap())) {
                    rectifyFactor = AdxStatData.getNormalValue(rectifyFactorMap.get(clickValueLevel), 1.0, 0.5, 1.5);
                }
                Double statConClickValue = AdxStatData.nullToDefault(resoStatClickValue, statClickValueDay);
                Double recPreClickValue = statConClickValue = AdxStatData.nullToDefault(statClickValue, statConClickValue);
                if (AssertUtil.isNotEmpty((Object)preClickValue)) {
                    recPreClickValue = DataUtil.division((Double)preClickValue, (Double)rectifyFactor);
                }
                Double conPreAdClickValue = AdxStatData.getConClickValue(preAdClickValue, statConClickValue, preAdWeight);
                Double conClickValue = AdxStatData.getConClickValue(recPreClickValue, statConClickValue, preCvaWeight);
                Double statConCtr = AdxStatData.nullToDefault(resoStatCtr, statCtrDay);
                statConCtr = AdxStatData.nullToDefault(statCtr, statConCtr);
                Double conCtr = AdxStatData.getConCtr(preCtr, statConCtr, preCtrWeight);
                Double expConsume = conClickValue * conCtr;
                Double targetRoi = AdxStatData.nullToMinDefault(decisionRequestDo.getTargetRoi(), 1.1501);
                AdxPdControlDo adxPdControlInfo = decisionRequestDo.getAdxPdControlInfo();
                if (AssertUtil.isNotEmpty((Object)adxPdControlInfo)) {
                    giveUpRate = AdxStatData.nullToDefault(adxPdControlInfo.getGiveUpRate(), giveUpRate);
                    controlFactor = AdxStatData.getNormalValue(adxPdControlInfo.getControlFactor(), controlFactor, lowerLimit, upperLimit);
                }
                Long price = decisionRequestDo.getPrice();
                Double expCost = DataUtil.division((Long)AdxStatData.nullToDefault(price, 0L), (Long)ADX_MULTIPLIER);
                Double pRoi1 = DataUtil.division((Double)expConsume, (Double)expCost, (int)6);
                Double pRoi2 = DataUtil.division((Double)expConsume, (Double)(expCost * controlFactor), (int)6);
                if (isConfident) {
                    double random = Math.random();
                    if (pRoi1 < 1.0 || pRoi2 < 1.0) {
                        if (random < 0.98) {
                            isGiveUp = 1;
                            giveUpType = 10L;
                        }
                    } else if ((pRoi1 < 1.15 || pRoi2 < 1.15) && random < giveUpRate) {
                        isGiveUp = 1;
                        giveUpType = 10L;
                    }
                }
                ret.setIdeaId(ideaId);
                ret.setPreCtr(preCtr);
                ret.setStatCtr(statCtr);
                ret.setStatCtrResource(resoStatCtr);
                ret.setPreClickValue(preClickValue);
                ret.setPredClickValue(preAdClickValue);
                ret.setStatClickValue(statClickValue);
                ret.setStatClickValueResource(resoStatClickValue);
                ret.setClickValueLevel(clickValueLevel);
            }
            ret.setIsGiveUp(isGiveUp);
            ret.setStrategy(strategy);
            ret.setLevel(level);
            ret.setClickValueRectifyFactor(rectifyFactor);
            ret.setGiveUpType(giveUpType);
        }
        catch (Exception e) {
            logger.error("PdDecisionAlg.getPdDecision error", (Throwable)e);
        }
        return ret;
    }

    private static Long getGiveUpType(AdxPdDecisionRequestDo decisionRequestDo) {
        Long ret = null;
        if (decisionRequestDo == null) {
            logger.error("PdDecisionAlg.getPdDecision() input params valid , params decisionRequestDo is null");
            return 11L;
        }
        if (decisionRequestDo.getIdeaRcmdResult() == null) {
            logger.error("PdDecisionAlg.getPdDecision() input params valid , params ideaRcmdResult is null");
            return 12L;
        }
        return ret;
    }
}

