/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.DPAActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.CandidateActivityDo;
import cn.com.duiba.nezha.alg.feature.vo.DPAActFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActRcmderTFServing {
    private static final Logger logger = LoggerFactory.getLogger(ActRcmderTFServing.class);
    static double[] pCpmBucket = new double[]{0.4, 0.6, 0.85, 0.95, 0.99, 1.0};
    static double[] pCpmWeight = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 85.0};

    public static Map<String, String> featureParse(DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) {
        Map DPAFeatureMap = DPAActFeatureParse.generateFeatureMapStatic((DPAActFeatureDo)dpa);
        Map DPADynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic((DPAActFeatureDo)dpa, (SlotActFeature)slotActFeature);
        Map slotActFeatureMap = DPAActFeatureParse.generateFeatureMapSlotAct((SlotActFeature)slotActFeature);
        Map userProfileFeatureMap = DPAActFeatureParse.generateFeatureMapUserProfile((UserProfileFeature)userProfileFeature);
        Map featureMap = DPAActFeatureParse.generateFeatureMapBase((FeatureDo)featureDo);
        Map userActFeatureMap = DPAActFeatureParse.generateFeatureMapUserAct((UserActFeature)userActFeature);
        DPAFeatureMap.putAll(DPADynamicFeatureMap);
        DPAFeatureMap.putAll(slotActFeatureMap);
        DPAFeatureMap.putAll(userProfileFeatureMap);
        DPAFeatureMap.putAll(featureMap);
        DPAFeatureMap.putAll(userActFeatureMap);
        return DPAFeatureMap;
    }

    public static List<ActRcmdDo> recRank(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> candidateActivityDoList, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{candidateActivityDoList, dpa})) {
            logger.warn("Actcmder recRank input params is null");
            return rets;
        }
        Map<String, String> staticFeatureMap = ActRcmderTFServing.featureParse(dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        ArrayList<CandidateActivityDo> candidateActivityDos = new ArrayList<CandidateActivityDo>(candidateActivityDoList);
        List activityZoomDos = activityDos.stream().sorted(Comparator.comparing(CandidateActivityDo::getActivityMatchScore).reversed()).limit(10L).collect(Collectors.toList());
        candidateActivityDos.addAll(activityZoomDos);
        HashMap<CandidateActivityDo, FeatureMapDo> featureDoMap = new HashMap<CandidateActivityDo, FeatureMapDo>();
        HashMap<CandidateActivityDo, ActRcmdDo> retMap = new HashMap<CandidateActivityDo, ActRcmdDo>();
        for (CandidateActivityDo candidateActivityDo : candidateActivityDos) {
            ActRcmdDo actRcmdDo = new ActRcmdDo();
            actRcmdDo.setCandidateActivityDo(candidateActivityDo);
            actRcmdDo.setActPackageType(candidateActivityDo.getActPackageType());
            actRcmdDo.setAppId(dpa.getAppId());
            actRcmdDo.setSlotId(dpa.getSlotId());
            actRcmdDo.setRid(dpa.getRid());
            actRcmdDo.setDeviceId(dpa.getDeviceId());
            actRcmdDo.setImei(dpa.getImei());
            actRcmdDo.setUa(dpa.getUa());
            actRcmdDo.setAreaCode(dpa.getAreaCode());
            actRcmdDo.setPriceSection(dpa.getPriceSection());
            DPAActFeatureDo dpaActFeatureDo = new DPAActFeatureDo();
            dpaActFeatureDo.setCandidateActivityDo(candidateActivityDo);
            Map dynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic((DPAActFeatureDo)dpaActFeatureDo, (SlotActFeature)slotActFeature);
            HashMap<String, String> retFeatureMap = new HashMap<String, String>();
            retFeatureMap.putAll(staticFeatureMap);
            retFeatureMap.putAll(dynamicFeatureMap);
            actRcmdDo.setFeatureMap(retFeatureMap);
            retMap.put(candidateActivityDo, actRcmdDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(candidateActivityDo, featureMapDo);
        }
        Map pRpmMap = new HashMap();
        try {
            if (ActRcmderTFServing.validModel(coderModel, tfServingClient).booleanValue()) {
                pRpmMap = coderModel.predictWithTFNew(featureDoMap, tfServingClient);
            }
        }
        catch (Exception e2) {
            logger.warn("TF predict failed: " + e2.toString());
        }
        HashMap featureMap = new HashMap();
        HashMap<Long, Double> predMap = new HashMap<Long, Double>();
        for (Map.Entry pRmp : pRpmMap.entrySet()) {
            CandidateActivityDo candidateActivityDo = (CandidateActivityDo)pRmp.getKey();
            Double pcpm = (Double)pRmp.getValue();
            if (candidateActivityDo.getActivityId() != null && pcpm != null) {
                predMap.put(candidateActivityDo.getActivityId(), pcpm);
            }
            ActRcmdDo actRcmdDo = (ActRcmdDo)retMap.get(candidateActivityDo);
            actRcmdDo.setpCpm(pcpm);
            retMap.put(candidateActivityDo, actRcmdDo);
        }
        if (coderModel.getModelId().equals("nz_last_model_new_deep_fm_e2e_dpa_join_v001_")) {
            logger.info(coderModel.getModelId() + dpa.getSlotId() + " predict:" + JSON.toJSONString(predMap));
        }
        rets = retMap.values().stream().filter(e -> e.getpCpm() != null).sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }

    public static ActRcmdDo recEE(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> candidateActivityDos, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmderTFServing.recRank(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder recEE input params is null");
            return ret;
        }
        return ActRcmderTFServing.ActRoulette(rets);
    }

    public static ActRcmdDo recEEWithResort(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> candidateActivityDos, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmderTFServing.recRank(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder recEE input params is null");
            return ret;
        }
        List<ActRcmdDo> resortRets = ActRcmderTFServing.recReSort(rets, slotActFeature);
        return ActRcmderTFServing.ActRoulette(resortRets);
    }

    public static ActRcmdDo recSort(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> candidateActivityDos, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        return ActRcmderTFServing.recEE(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static ActRcmdDo recSortWithResort(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> candidateActivityDos, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        return ActRcmderTFServing.recEEWithResort(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static List<ActRcmdDo> recRank(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> candidateActivityDoList, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{dpa, candidateActivityDoList})) {
            logger.warn("Actcmder recRank common input params is null");
            return rets;
        }
        List candidateActivityDos = candidateActivityDoList.stream().sorted(Comparator.comparing(CandidateActivityDo::getActivityMatchScore).reversed()).limit(10L).collect(Collectors.toList());
        Map<String, String> staticFeatureMap = ActRcmderTFServing.featureParse(dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        HashMap<CandidateActivityDo, FeatureMapDo> featureDoMap = new HashMap<CandidateActivityDo, FeatureMapDo>();
        HashMap<CandidateActivityDo, ActRcmdDo> retMap = new HashMap<CandidateActivityDo, ActRcmdDo>();
        for (CandidateActivityDo candidateActivityDo : candidateActivityDos) {
            ActRcmdDo actRcmdDo = new ActRcmdDo();
            actRcmdDo.setCandidateActivityDo(candidateActivityDo);
            actRcmdDo.setActPackageType(candidateActivityDo.getActPackageType());
            actRcmdDo.setAppId(dpa.getAppId());
            actRcmdDo.setSlotId(dpa.getSlotId());
            actRcmdDo.setRid(dpa.getRid());
            actRcmdDo.setDeviceId(dpa.getDeviceId());
            actRcmdDo.setImei(dpa.getImei());
            actRcmdDo.setUa(dpa.getUa());
            actRcmdDo.setAreaCode(dpa.getAreaCode());
            actRcmdDo.setPriceSection(dpa.getPriceSection());
            DPAActFeatureDo dpaActFeatureDo = new DPAActFeatureDo();
            dpaActFeatureDo.setCandidateActivityDo(candidateActivityDo);
            Map dynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic((DPAActFeatureDo)dpaActFeatureDo, (SlotActFeature)slotActFeature);
            HashMap<String, String> retFeatureMap = new HashMap<String, String>();
            retFeatureMap.putAll(staticFeatureMap);
            retFeatureMap.putAll(dynamicFeatureMap);
            actRcmdDo.setFeatureMap(retFeatureMap);
            retMap.put(candidateActivityDo, actRcmdDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(candidateActivityDo, featureMapDo);
        }
        Map pRpmMap = new HashMap();
        if (ActRcmderTFServing.validModel(coderModel, tfServingClient).booleanValue()) {
            pRpmMap = coderModel.predictWithTFNew(featureDoMap, tfServingClient);
            logger.info("coderModel.predictWithTFNew() \u8fd4\u56de\u7ed3\u679c\u6570\u91cf \uff1a" + pRpmMap.keySet().size());
        }
        HashMap featureMap = new HashMap();
        HashMap<Long, Double> predMap = new HashMap<Long, Double>();
        for (Map.Entry pRmp : pRpmMap.entrySet()) {
            CandidateActivityDo candidateActivityDo = (CandidateActivityDo)pRmp.getKey();
            Double pcpm = (Double)pRmp.getValue();
            if (candidateActivityDo.getActivityId() != null && pcpm != null) {
                predMap.put(candidateActivityDo.getActivityId(), pcpm);
            }
            ActRcmdDo actRcmdDo = (ActRcmdDo)retMap.get(candidateActivityDo);
            actRcmdDo.setpCpm(pcpm);
            retMap.put(candidateActivityDo, actRcmdDo);
        }
        if (coderModel.getModelId().equals("nz_last_model_new_deep_fm_e2e_dpa_join_v001_")) {
            logger.info(coderModel.getModelId() + dpa.getSlotId() + " predict:" + JSON.toJSONString(predMap));
        }
        rets = retMap.values().stream().filter(e -> e.getpCpm() != null).sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }

    public static ActRcmdDo recEE(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmderTFServing.recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reEE output is null");
            return ret;
        }
        ret = ActRcmderTFServing.ActRoulette(rets);
        return ret;
    }

    public static ActRcmdDo recEEWithResort(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmderTFServing.recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reEE output is null");
            return ret;
        }
        List<ActRcmdDo> resortRets = ActRcmderTFServing.recReSort(rets, slotActFeature);
        ret = ActRcmderTFServing.ActRoulette(resortRets);
        return ret;
    }

    public static ActRcmdDo recSort(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        logger.info("\u5e38\u89c4\u6d3b\u52a8\u5019\u9009\u96c6\u6570\u91cf \uff1a" + activityDos.size());
        return ActRcmderTFServing.recEE(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static ActRcmdDo recSortWithResort(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        logger.info("\u5e38\u89c4\u6d3b\u52a8\u5019\u9009\u96c6\u6570\u91cf \uff1a" + activityDos.size());
        return ActRcmderTFServing.recEEWithResort(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static List<ActRcmdDo> recWeightedRank(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ArrayList<ActRcmdDo> retTemps = new ArrayList<ActRcmdDo>();
        List<ActRcmdDo> actRcmdDos = ActRcmderTFServing.recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (CollectionUtils.isEmpty(actRcmdDos)) {
            return null;
        }
        Double sdCostPerJoin = slotActFeature.getSdCostPerJoin();
        if (sdCostPerJoin == null) {
            sdCostPerJoin = 0.0;
        }
        Iterator<ActRcmdDo> iterator = actRcmdDos.iterator();
        while (iterator.hasNext()) {
            ActRcmdDo actRcmdDo;
            ActRcmdDo actRcmdDoTemp = actRcmdDo = iterator.next();
            Double weighted = actRcmdDo.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActJoinDayConsumer();
            if (weighted == null) {
                weighted = 0.0;
            } else if (sdCostPerJoin > 0.0 && weighted > 3.0 * sdCostPerJoin) {
                weighted = 3.0 * sdCostPerJoin;
            }
            Double zdSlotActCostPerTime = actRcmdDo.getCandidateActivityDo().getRoutineActFeature().getZdSlotActCostPerTime();
            if (zdSlotActCostPerTime == null) {
                zdSlotActCostPerTime = 0.0;
            }
            Double pcmp = actRcmdDo.getpCpm() * weighted + zdSlotActCostPerTime;
            if (actRcmdDo.getpCpm() > 1.0) {
                pcmp = (1.0 + Math.log(actRcmdDo.getpCpm()) / Math.log(2.0)) * weighted + zdSlotActCostPerTime;
            }
            actRcmdDoTemp.setpCpm(pcmp);
            retTemps.add(actRcmdDoTemp);
        }
        List<ActRcmdDo> rets = retTemps.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }

    public static ActRcmdDo recWeightedEE(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmderTFServing.recWeightedRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reWeightedEE output is null");
            return ret;
        }
        ret = ActRcmderTFServing.ActRoulette(rets);
        return ret;
    }

    public static ActRcmdDo recWeightedSort(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        logger.info("\u5e38\u89c4\u6d3b\u52a8\u5019\u9009\u96c6\u6570\u91cf \uff1a" + activityDos.size());
        return ActRcmderTFServing.recWeightedEE(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static Double getMatchScore(ActivityMatchInfo activityMatchInfo) throws Exception {
        Double matchScore = 0.0;
        double slotScore = WilsonInterval.wilsonCalc((double)(activityMatchInfo.getHisRequest().slotVal / 100.0), (double)activityMatchInfo.getHisRequest().slotVal).lowerBound;
        double globalScore = WilsonInterval.wilsonCalc((double)(activityMatchInfo.getHisRequest().globalVal / 100.0), (double)activityMatchInfo.getHisRequest().globalVal).lowerBound;
        double appScore = WilsonInterval.wilsonCalc((double)(activityMatchInfo.getHisRequest().appVal / 100.0), (double)activityMatchInfo.getHisRequest().appVal).lowerBound;
        double sconfidence = Math.min(activityMatchInfo.getHisRequest().slotVal / 100.0, 1.0);
        double aconfidence = Math.min(activityMatchInfo.getHisRequest().appVal / 100.0, 1.0);
        double gconfidence = Math.min(activityMatchInfo.getHisRequest().globalVal / 100.0 * 10.0, 1.0);
        matchScore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
        return matchScore;
    }

    public static ActRcmdDo ActRoulette(List<ActRcmdDo> actRcmdDos) throws Exception {
        return ActRcmderTFServing.ActRoulette(actRcmdDos, 0.9);
    }

    public static ActRcmdDo ActRoulette(List<ActRcmdDo> actRcmdDos, double top1Weight) throws Exception {
        Double weight;
        ActRcmdDo actRcmdDo = null;
        if (actRcmdDos == null) {
            return actRcmdDo;
        }
        Double bestCpm = null;
        CandidateActivityDo bestCpmKey = null;
        if (actRcmdDos.size() == 1) {
            return actRcmdDos.get(0);
        }
        for (ActRcmdDo rcmdDo : actRcmdDos) {
            Double cpm = rcmdDo.getpCpm();
            if (cpm == null || bestCpm != null && !(bestCpm < cpm)) continue;
            bestCpm = cpm;
            bestCpmKey = rcmdDo.getCandidateActivityDo();
        }
        HashMap<ActRcmdDo, Double> weightMap = new HashMap<ActRcmdDo, Double>();
        Double weightSum = 0.0;
        for (ActRcmdDo actRcmdDo2 : actRcmdDos) {
            Double cpm = actRcmdDo2.getpCpm();
            weight = ActRcmderTFServing.getCpmWeight(cpm, bestCpm);
            if (weight == null) {
                weight = 1.0;
            }
            weightSum = weightSum + weight;
            weightMap.put(actRcmdDo2, weight);
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            ActRcmdDo rcmdDo = (ActRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (bestCpmKey == null || !bestCpmKey.equals(rcmdDo.getCandidateActivityDo()) || !(weight < weightSum * top1Weight)) continue;
            Double weightOther = weightSum - weight;
            weight = weightOther * top1Weight / (1.0 - top1Weight);
            weightSum = weightOther + weight;
            weightMap.put(rcmdDo, weight);
        }
        actRcmdDo = (ActRcmdDo)Roulette.doubleMap(weightMap);
        return actRcmdDo;
    }

    private static Boolean validModel(CODER coderModel, TFServingClient tfServingClient) {
        Boolean ret = true;
        if (tfServingClient == null || coderModel == null) {
            logger.warn("ActRcmder.rcmd() input valid ,params tfServing is null or coder is null");
            ret = false;
        }
        return ret;
    }

    private static Double getCpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    public static List<ActRcmdDo> recReSort(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature) {
        return ActRcmderTFServing.recReSort(actRcmdDos, slotActFeature, true);
    }

    public static List<ActRcmdDo> recReSort(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature, boolean cntflag) {
        Double sdCostPerJoin = slotActFeature.getSdCostPerJoin();
        Double zdCostPerTime = slotActFeature.getZdCostPerTime();
        if (sdCostPerJoin == null || zdCostPerTime == null || slotActFeature.getSdJoinCnt() == null || slotActFeature.getSdJoinCnt() < 1000L || slotActFeature.getZdCnt() == null || slotActFeature.getZdCnt() < 200L) {
            sdCostPerJoin = 1.0;
            zdCostPerTime = 0.645;
        }
        for (ActRcmdDo actRcmdDo : actRcmdDos) {
            CandidateActivityDo cad = actRcmdDo.getCandidateActivityDo();
            double newSortValue = actRcmdDo.getpCpm();
            if (cntflag) {
                newSortValue *= sdCostPerJoin.doubleValue();
            }
            actRcmdDo.setpCpm(newSortValue += (double)cad.getRoutineActFeature().getAutoFirstLaunchStatus().intValue() * zdCostPerTime);
        }
        return actRcmdDos.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
    }

    public static ActRcmdDo recSortWithResortAndMapping(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        logger.info("\u5e38\u89c4\u6d3b\u52a8\u5019\u9009\u96c6\u6570\u91cf \uff1a" + activityDos.size());
        return ActRcmderTFServing.recEEWithResortWithMapping(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static ActRcmdDo recEEWithResortWithMapping(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmderTFServing.recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reEE output is null");
            return ret;
        }
        List<ActRcmdDo> resortRets = ActRcmderTFServing.recReSortWithMapping(rets, slotActFeature);
        ret = ActRcmderTFServing.ActRoulette(resortRets);
        return ret;
    }

    public static List<ActRcmdDo> recReSortWithMapping(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature) {
        return ActRcmderTFServing.recReSortWithMapping(actRcmdDos, slotActFeature, true);
    }

    public static List<ActRcmdDo> recReSortWithMapping(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature, boolean cntflag) {
        Double sdCostPerJoin = slotActFeature.getSdCostPerJoin();
        Double zdCostPerTime = slotActFeature.getZdCostPerTime();
        if (sdCostPerJoin == null || zdCostPerTime == null || slotActFeature.getSdJoinCnt() == null || slotActFeature.getSdJoinCnt() < 1000L || slotActFeature.getZdCnt() == null || slotActFeature.getZdCnt() < 200L) {
            sdCostPerJoin = 1.0;
            zdCostPerTime = 0.645;
        }
        for (ActRcmdDo actRcmdDo : actRcmdDos) {
            CandidateActivityDo cad = actRcmdDo.getCandidateActivityDo();
            double newSortValue = Math.log(1.0 + actRcmdDo.getpCpm());
            if (cntflag) {
                newSortValue *= Math.log(1.0 + sdCostPerJoin);
            }
            actRcmdDo.setpCpm(newSortValue += (double)cad.getRoutineActFeature().getAutoFirstLaunchStatus().intValue() * Math.log(1.0 + zdCostPerTime));
        }
        return actRcmdDos.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
    }

    public static ActRcmdDo recSortWithResortWithCtr(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        logger.info("\u5e38\u89c4\u6d3b\u52a8\u5019\u9009\u96c6\u6570\u91cf \uff1a" + activityDos.size());
        return ActRcmderTFServing.recCtrWeightedEE(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static ActRcmdDo recCtrWeightedEE(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = ActRcmderTFServing.recCtrWeightedRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reWeightedEE output is null");
            return ret;
        }
        ret = ActRcmderTFServing.ActRoulette(rets);
        return ret;
    }

    public static List<ActRcmdDo> recCtrWeightedRank(CODER coderModel, TFServingClient tfServingClient, List<CandidateActivityDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        ArrayList<ActRcmdDo> retTemps = new ArrayList<ActRcmdDo>();
        List<ActRcmdDo> actRcmdDos = ActRcmderTFServing.recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (CollectionUtils.isEmpty(actRcmdDos)) {
            return null;
        }
        Iterator<ActRcmdDo> iterator = actRcmdDos.iterator();
        while (iterator.hasNext()) {
            ActRcmdDo actRcmdDo;
            ActRcmdDo actRcmdDoTemp = actRcmdDo = iterator.next();
            Double weighted = actRcmdDo.getCandidateActivityDo().getRoutineActFeature().getCAppSlotCtrPerTime();
            if (weighted == null) {
                weighted = 1.0;
            }
            Double pcmp = actRcmdDo.getpCpm() * weighted;
            actRcmdDoTemp.setpCpm(pcmp);
            retTemps.add(actRcmdDoTemp);
        }
        List<ActRcmdDo> rets = retTemps.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }
}

