package cn.com.duiba.nezha.alg.alg.base;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

public class MathBase {


    /**
     * 是否相等
     *
     * @param a
     * @param b
     * @return
     */
    public static Boolean equals(Long a, Long b) {
        Boolean ret = false;
        if (AssertUtil.isAllEmpty(a, b)) {
            ret = true;
        } else if (AssertUtil.isAnyEmpty(a, b)) {
            ret = false;
        } else if (a.equals(b)) {
            ret = true;
        }

        return ret;
    }


    /**
     * 结果平滑,限定调节范围
     *
     * @param point
     * @param upperLimit
     * @param lowerLimit
     * @return
     * @throws Exception
     */
    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) {
        Double ret = point;

        if (AssertUtil.isAnyEmpty(upperLimit, lowerLimit)) {
            //logger.warn("noiseSmoother input invalid,with upperLimit=" + upperLimit + ",lowerLimit=" + lowerLimit);
            return ret;
        }

        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }

        return ret;
    }

    /**
     * 平滑分桶函数
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Double getConfidenceWeight(Long value, double[] bucketList, double[] weightList, double defaultValue) {

        Double valueD = null;
        if (value != null) {
            valueD = value + 0.0;
        }
        return getConfidenceWeight(valueD, bucketList, weightList, defaultValue);
    }

    /**
     * 平滑分桶函数
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Double getConfidenceWeight(Double value, double[] bucketList, double[] weightList, double defaultValue) {

        Double ret = defaultValue;

        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {


            double lastWeight = weightList[0];
            double lastBound = bucketList[0];

            for (int i = 0, size = bucketList.length; i < size; i++) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];

                double bound = bucketList[i];
                if (value <= bound) {

                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = weightList[0];
                    }
                    break;

                } else if (i == size - 1) {
                    ret = weightList[size - 1];
                }

                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }

        }

        return DataUtil.formatDouble(ret, 3);
    }

    /**
     * 平滑分桶函数
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList) {

        return getConfidenceWeight(value, bucketList, weightList, 0.0);
    }


    /**
     * @param x
     * @param lowerLimit
     * @param upperLimit
     * @param zoom
     * @return
     */
    public static Double sigmoidWithZoomAndIntervalMap(double x, double lowerLimit, double upperLimit, double zoom) {

        return lowerLimit + (upperLimit - lowerLimit) * sigmoidWithZoom(x, zoom);


    }


    /**
     * @param x
     * @param zoom
     * @return
     */
    public static Double sigmoidWithZoom(double x, double zoom) {
        return sigmoid(x * zoom);
    }


    /**
     * @param x
     * @return
     */
    public static Double sigmoid(double x) {
        return 1 / (1 + Math.exp(-x));
    }


    /**
     * 数据标准化
     *
     * @param value
     * @return
     */
    public static long getLongValue(Long value) {
        if (value == null) {
            return 0;
        } else {
            return value;
        }
    }

}
