package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFilterAlg {

    /**
     * 流量过滤
     *
     * @param flowFilterRequestDo
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFilterAlg.class);

    public static FlowFilterResultDo adxFlowFiltering(FlowFilterRequestDo flowFilterRequestDo) {

        FlowFilterResultDo ret = new FlowFilterResultDo();

        try {

            if (valid(flowFilterRequestDo)) {

                //【流量预过滤】
                ret = AdxFlowFiltering.getFlowFiltering(flowFilterRequestDo);
                Integer flowFilterLabel = ret.getFlowFilterLabel();
                Integer algoBidMode = flowFilterRequestDo.getAlgoBidMode();

                //【每pv发券过滤】开启:【流量预过滤】未过滤 and 选择【按cpc出价】
                if(AssertUtil.isAllNotEmpty(flowFilterLabel, algoBidMode)
                        && flowFilterLabel.equals(0) && algoBidMode.equals(2)){

                    FlowFilterResultDo launchPvRet= LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
                    ret.setFlowFilterLabel(launchPvRet.getFlowFilterLabel());
                    ret.setFilterType(launchPvRet.getFilterType());
                    ret.setPreLaunchPv(launchPvRet.getPreLaunchPv());
                }
            }

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering error:" + e);

        }

        return ret;
    }


    /**
     * 流量预过滤1.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTask(AdxFlowInfoDo flowInfo,
                                                AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTask.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTask error " + e);

        }

        return ret;
    }



    /**
     * 流量预过滤2.0定时任务
     * (根据缓存数据，调用频率：30min调用1次）
     *
     * @param flowInfo   adx流量信息
     * @param lastFilterInfo 上一次出参（定时任务）
     * @return
     */
    public static AdxFilterInfoDo adxFilterTaskPlus(AdxFlowInfoDo flowInfo,
                                                    AdxFilterInfoDo lastFilterInfo) {

        AdxFilterInfoDo ret = null;

        try {
            ret = AdxFilterTaskPlus.getFilterInfo(flowInfo, lastFilterInfo);

        } catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTaskPlus error " + e);

        }

        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param flowFilterRequestDo
     * @return
     */
    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {

        Boolean ret = true;

        if (flowFilterRequestDo == null) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }

        return ret;
    }

}
