package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.MaterialFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.alg.material.MaterialMatch.AdvertRelatedMaterialSet;

public class MaterialRcmder {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(MaterialRcmder.class);

    public static MaterialRcmdDo forkFeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map<Long, MaterialFeatureInfo> featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty(featureInfoMap)) {
            return null;
        }
        List<Long> idList = new ArrayList<>(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }

        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        // 旧版算法对应type为1
        materialRcmdDo.setType(1);
        // 获取素材id对应的特征，构建推荐结果对象
        Map<String, String> featureMap = new HashMap<>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo));
        System.out.println(featureMap.toString());
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        System.out.println(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    /**
     * DPA1.1 排序接口
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmd(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = rank(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmd fm model is null !!!");
        }

        return ret;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/10/12
     * @methodParameters: [model, materialExtractDo, materialFeatureDo]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo
     * @description: 广告利益点素材+普通素材online pk模型
     */
    public static MaterialRcmdDo rcmdMergedAd(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = rankMergedAd(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmd fm model is null !!!");
        }

        return ret;
    }

    /**
     * DPA2.0排序接口
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdNewVersion(FM model,
                                                FM secModel,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        ret = rankNewVersion(model,secModel, materialExtractDo, materialFeatureDo);
        return ret;
    }

    /**
     * DPA2.1排序接口，广告利益点素材使用模型来排序
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdNewVersion1(FM model,
                                                FM secModel,
                                                MaterialExtractDo materialExtractDo,
                                                MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        ret = rankNewVersion1(model,secModel, materialExtractDo, materialFeatureDo);
        return ret;
    }


    public static MaterialRcmdDo rank(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/10/12
     * @methodParameters: [model, materialExtractDo, materialFeatureDo]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo
     * @description: 广告利益点素材排序模型：多路召回add利益点素材
     */
    public static MaterialRcmdDo rankMergedAd(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategyWithAd(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        // 广告素材利益点区分普通素材
        if(AdvertRelatedMaterialSet.contains(reRankId)){
            resultFeatureMap.put("advertFlag","1");
            ret.setType(3);
        }else{
            ret.setType(2);
        }
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    /**
     * @return 返回值说明
     * @description 加入广告利益点素材排序
     * @date 2020/9/14
     */
    public static MaterialRcmdDo rankNewVersion(FM model,
                                                FM secModel,
                                                MaterialExtractDo materialExtractDo,
                                                MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        // 计算广告利益点素材当天及过去7天的曝光次数
        int advertCnt = calAdvertMaterialCnt(materialFeatureDo);
        // 根据用户的历史曝光次数对不同用户设置不同的投放概率
        double initScore = calUserInitScore(materialFeatureDo);

        double currScore = initScore / (advertCnt + 1);
        // 判断透出逻辑
        boolean advertModelFlag = false;
        // && secModel != null
        if (Math.random() < currScore && AssertUtil.isNotEmpty(materialExtractDo.getMaterialAdvertRelatedDoList()) ) {
            // 透出广告利益点素材，投放策略：使用模型
            advertModelFlag = true;
        }

        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }


        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = new HashSet<>();
        if (advertModelFlag) {
            // 广告利益点素材
            recallMaterialSet = materialExtractDo
                    .getMaterialAdvertRelatedDoList().stream()
                    .map(MaterialMatchDo::getMaterialId)
                    .collect(Collectors.toSet());
        } else {
            recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);
        }
        // 添加券点击侧新增的特征以及需要根据素材id和二级类目之间的映射关系，完成FeatureMap中的广告二级类目id的填充
        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);
            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        if (advertModelFlag) {
            // 随机投放
            for (Long id : recallMaterialSet) {
                preCTR.put(id, Math.random());
            }
//            preCTR = secModel.predictsNew(featureDoMap);
        } else {
            if (model != null) {
                preCTR = model.predictsNew(featureDoMap);
            } else {
                logger.warn("rcmdNewVersion first fm model is null !! ");
                return null;
            }
        }

        // 5 重排策略；包括曝光降权
        RerankMaterial rerankMaterial;
        if (advertModelFlag) {
            rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialAdvertRelatedDoList(), false);
        } else {
            rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        }
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        // 6 区分不同类型的结果展示
        if (advertModelFlag) {
            resultFeatureMap.put("advertFlag","1");
            ret.setType(3);
        } else {
            ret.setType(2);
        }
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());

        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    /**
     * @return 返回值说明
     * @description 加入广告利益点素材排序
     * @date 2020/10/12
     */
    public static MaterialRcmdDo rankNewVersion1(FM model,
                                                FM secModel,
                                                MaterialExtractDo materialExtractDo,
                                                MaterialFeatureDo materialFeatureDo) throws Exception {

        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return null;
        }

        //1 合并多路召回数据
        // 1.1 合并广告利益点素材的
        Set<Long> recallMaterialAdvertSet = new HashSet<>();
        if (AssertUtil.isNotEmpty(materialExtractDo.getMaterialAdvertRelatedDoList())) {
            recallMaterialAdvertSet = materialExtractDo
                    .getMaterialAdvertRelatedDoList().stream()
                    .map(MaterialMatchDo::getMaterialId)
                    .collect(Collectors.toSet());
        }
        // 1.2 合并传统素材的
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);
        // 添加券点击侧新增的特征以及需要根据素材id和二级类目之间的映射关系，完成FeatureMap中的广告二级类目id的填充
        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：传统素材动态特征
        Map<Long, FeatureMapDo> MaterialFeatureDoMap = new HashMap<>();
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);
            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            MaterialFeatureDoMap.put(materialId, featureMapDo);
        }

        //4 解析：广告利益点素材动态特征
        Map<Long, FeatureMapDo> MaterialAdvertFeatureDoMap = new HashMap<>();
        for (Long materialId : recallMaterialAdvertSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);
            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            MaterialAdvertFeatureDoMap.put(materialId, featureMapDo);
        }

        //5 模型预估
        Map<Long, Double> MaterialPreCTR = new HashMap<>();
        Map<Long, Double> MaterialAdvertPreCTR = new HashMap<>();
        if (model != null) {
            MaterialPreCTR = model.predictsNew(MaterialFeatureDoMap);
        } else {
            logger.warn("rcmdNewVersion1 first fm model is null !! ");
        }
        if (secModel != null) {
            MaterialAdvertPreCTR = secModel.predictsNew(MaterialAdvertFeatureDoMap);
        } else {
            logger.warn("rcmdNewVersion1 second fm model is null !! ");
        }
        if (model == null && secModel == null) {
            logger.warn("rcmdNewVersion1 first and second fm model is null !! ");
            return null;
        }

        // 5 重排策略；包括曝光降权
        RerankMaterial reRankMaterial = reRank(MaterialPreCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), false);
        RerankMaterial reRankMaterialAdvert = reRank(MaterialAdvertPreCTR, materialFeatureDo, materialExtractDo.getMaterialAdvertRelatedDoList(), false);

        MaterialRcmdDo ret = new MaterialRcmdDo();
        Long reRankId;
        // 6 判断重排后的分数，如果传统素材的大于广告利益点素材的，则出传统素材的
        if (reRankMaterial.getReRankScore() > reRankMaterialAdvert.getReRankScore()) {
            reRankId = reRankMaterial.getMaterialId();
            // 空结果情况
            if (reRankId < 0) {
                return null;
            }
            ret.setMaterialId(reRankId);
            FeatureMapDo featureMapDo = MaterialFeatureDoMap.get(reRankId);
            Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
            resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
            ret.setType(2);
            ret.setFeatureMap(resultFeatureMap);
            ret.setRid(materialFeatureDo.getRid());
            ret.setScore(reRankMaterial.getRankScore());
            ret.setDebugInfo(reRankMaterial.getDebugInfo());
        } else {
            reRankId = reRankMaterialAdvert.getMaterialId();
            // 空结果情况
            if (reRankId < 0) {
                return null;
            }
            ret.setMaterialId(reRankId);
            FeatureMapDo featureMapDo = MaterialAdvertFeatureDoMap.get(reRankId);
            Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
            resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
            resultFeatureMap.put("advertFlag","1");
            ret.setType(3);
            ret.setFeatureMap(resultFeatureMap);
            ret.setRid(materialFeatureDo.getRid());
            ret.setScore(reRankMaterialAdvert.getRankScore());
            ret.setDebugInfo(reRankMaterialAdvert.getDebugInfo());
        }
        return ret;

    }


    private static double calUserInitScore(MaterialFeatureDo materialFeatureDo) {
        UserFeature userFeature = Optional.ofNullable(materialFeatureDo.getUserFeature()).orElse(new UserFeature());
        Integer expHisCnt = userFeature.getExpHisCnt();
        if (expHisCnt != null) {
            if (expHisCnt < 10) {
                return 0.20;
            }
            return 0.30;
        }
        return 0.15;
    }

    private static int calAdvertMaterialCnt(MaterialFeatureDo materialFeatureDo) {
        int count = 0;
        UserFeature userFeature = Optional.ofNullable(materialFeatureDo.getUserFeature()).orElse(new UserFeature());
        if (userFeature.getExpDayMaterials() != null) {
            String[] exposeList = userFeature.getExpDayMaterials().split(",");
            for (String exposeId : exposeList) {
                if (AdvertRelatedMaterialSet.contains(Long.parseLong(exposeId))) {
                    count++;
                }
            }
        }

        if (userFeature.getExpWeekMaterials() != null) {
            String[] sevenExposeList = userFeature.getExpWeekMaterials().split(",");
            for (String exposeId : sevenExposeList) {
                String[] idArr = exposeId.split("-");
                if (idArr.length >= 2) {
                    if (AdvertRelatedMaterialSet.contains(Long.parseLong(idArr[1]))) {
                        count++;
                    }
                }

            }
        }
        return count;
    }

    /**
     * @return 返回值说明
     * @description merge多路召回结果
     * @date 2020/7/24
     */
    private static Set<Long> mergeMultiRecallStrategy(MaterialExtractDo materialExtractDo) {
        Set<Long> recallMaterialSet = new HashSet<>();
        materialExtractDo.getMaterialMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        List<MaterialCostMatchDo> materialCostMatchDos = materialExtractDo.getMaterialCostMatchDoList();
        if (AssertUtil.isNotEmpty(materialCostMatchDos)) {
            materialCostMatchDos.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    private static Set<Long> mergeMultiRecallStrategyWithAd(MaterialExtractDo materialExtractDo) {
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);
        List<MaterialMatchDo> materialAdvertRelatedDoList= materialExtractDo.getMaterialAdvertRelatedDoList();
        if(AssertUtil.isNotEmpty(materialAdvertRelatedDoList)){
            materialAdvertRelatedDoList.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    private static RerankMaterial reRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList, boolean oldVersionFlag) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map<Long, MaterialFeatureInfo> materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        double maxScore = -1;
        double rawScore = -1;
        int rawExposeCnt = 0;
        int weightedExposeCnt = 0;
        Long resultId = -1L;
        Long oldOrderResultId = -1L;
        double oldMaxScore = -1;
        double oldWeightedScore = -1;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }

        // 传统素材：更为缓和的曝光降权方式，尽量保持模型的排序；广告素材：相对衰减速度更快的降权方式
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            int tmpExposeCnt = 0;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId)) {
                MaterialFeatureInfo materialFeatureInfo = materialFeatureInfoMap.get(materialId);
                if (null != materialFeatureInfo) {
                    UserMaterialFeature userMaterialFeature = materialFeatureInfo.getUserMaterialFeature();
                    if (null != userMaterialFeature) {
                        Long exposeCnt = userMaterialFeature.getUExposeDayCnt();
                        // 当天曝光降权
                        if (null != exposeCnt) {
                            tmpExposeCnt = exposeCnt.intValue();
                            double weight;
                            if (oldVersionFlag) {
                                weight = Math.pow(Math.E, -0.09 * exposeCnt);
                            } else {
                                weight = 0.01;
                            }
                            score = score * weight;
                        }
                    }
                }
            }
            preCTR.put(materialId, score);
            if (score > maxScore) {
                maxScore = score;
                resultId = materialId;
                rawScore = tmpScore;
                weightedExposeCnt = tmpExposeCnt;
            }
            if (tmpScore > oldMaxScore) {
                oldMaxScore = tmpScore;
                oldOrderResultId = materialId;
                rawExposeCnt = tmpExposeCnt;
                oldWeightedScore = score;
            }
        }

        // 广告利益点素材投放
        if (!oldVersionFlag) {
            rerankMaterial.setMaterialId(resultId);
            rerankMaterial.setRankScore(rawScore);
            rerankMaterial.setReRankScore(maxScore);
            return rerankMaterial;
        }

        // 判断重排后的素材是否在top5素材的平均水平的70%，防止出现非常差的素材
        List<MaterialMatchDo> sortedList = materialMatchDoList.stream()
                .sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed())
                .collect(Collectors.toList());

        int size = Math.min(5, sortedList.size());
        boolean flag = false;
        double sum = 0.0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; i++) {
            double ctr = sortedList.get(i).getCtr();
            sb.append(String.format("%.5f",ctr) + ";") ;
            sum += ctr;
        }
        double avgCtr = sum / size;
        double faithLevel = 0.7;
        double currCtr = 0.0;
        for (MaterialMatchDo materialMatchDo : materialMatchDoList) {
            if (resultId.equals(materialMatchDo.getMaterialId())) {
                currCtr = materialMatchDo.getCtr();
                break;
            }
        }
        double judgeLevel = avgCtr * faithLevel;
        if (currCtr >= judgeLevel) {
            flag = true;
        }
        if (!flag) {
            resultId = oldOrderResultId;
            rawScore = oldMaxScore;
            maxScore = oldMaxScore;
        }
        // debug 格式：透出结果是否为原始top1 # 透出结果曝光次数 # 透出结果重排分数 # top 5 ctr信息 # 判断70%的分数 # 当前ctr分数 # （option 透出非原始top1时）原始top1 id # 原始分数 # 重排分数 # 曝光次数
        StringBuilder debugInfo = new StringBuilder();
        if (resultId.equals(oldOrderResultId)) {
            debugInfo.append("1" + "#");
            debugInfo.append(rawExposeCnt + "#");
            debugInfo.append(String.format("%.5f",oldWeightedScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f",judgeLevel) + "#");
            debugInfo.append(String.format("%.5f",currCtr));
        } else {
            debugInfo.append("0" + "#");
            debugInfo.append(weightedExposeCnt + "#");
            debugInfo.append(String.format("%.5f",maxScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f",judgeLevel) + "#");
            debugInfo.append(String.format("%.5f",currCtr) + "#");
            debugInfo.append(oldOrderResultId + "#");
            debugInfo.append(String.format("%.5f",oldMaxScore) + "#");
            debugInfo.append(String.format("%.5f",oldWeightedScore)  + "#");
            debugInfo.append(rawExposeCnt);
        }

        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        rerankMaterial.setDebugInfo(debugInfo.toString());
        return rerankMaterial;

    }


    public static void main(String[] args) {
        String string = " {\"deviceId\":\"7183214b04e218e99d43746c908b27b0\",\"materialFeatureMap\":{561:{\"bConvertWeekCnt\":2,\"clickDayCnt\":2720,\"clickWeekCnt\":1733,\"convertWeekCnt\":48,\"customization\":\"1431\",\"designHue\":\"1987\",\"exposeDayCnt\":163886,\"exposeWeekCnt\":93856,\"industry\":\"1407\",\"materialId\":561,\"rewardElement\":\"1899\",\"slotNature\":\"1443\"}},\"rid\":\"123456\",\"slotFeature\":{\"appId\":76235,\"appIndustryTagId\":\"198\",\"appIndustryTagPid\":\"196\",\"slotId\":352313,\"slotType\":9},\"slotMaterialFeatureMap\":{561:{\"slotBConvertHistCnt\":2,\"slotBConvertWeekCnt\":2,\"slotClickDayCnt\":2720,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1728,\"slotConvertHistCnt\":49,\"slotConvertWeekCnt\":48,\"slotExposeDayCnt\":163886,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":93851}},\"userFeature\":{\"age\":\"010212\",\"appList\":\"14924\",\"consumeLevel\":\"05011701\",\"expDayMaterials\":\"22099,3591,27170\",\"expWeekMaterials\":\"20200729203127-561,20200728093434-26869,20200728094320-27169,20200728094210-27170,20200723183928-27171\",\"marry\":\"01050303\",\"permanentProvince\":\"广西\",\"sex\":\"010102\"},\"userMaterialFeatureMap\":{561:{\"uExposeHistCnt\":3,\"uExposeInterval\":1,\"uExposePeriod\":5,\"uExposeWeekCnt\":3}}}";
        MaterialFeatureDo exp = JSONObject.parseObject(string, MaterialFeatureDo.class);
        MaterialRcmdDo ret = forkFeatureParse(exp);
        System.out.println(JSONObject.toJSONString(ret));
    }
}