/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.material.MaterialMatch;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialCostMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialExtractDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.material.RankMaterialInfo;
import cn.com.duiba.nezha.alg.alg.vo.material.RerankMaterial;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.MaterialFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureInfo;
import cn.com.duiba.nezha.alg.feature.vo.SlotFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserMaterialFeature;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialRcmder {
    private static final Logger logger = LoggerFactory.getLogger(MaterialRcmder.class);
    public static List<Long> lowerCtrSlotIdSet = new ArrayList<Long>(){
        {
            this.add(478L);
            this.add(355616L);
            this.add(351411L);
            this.add(352313L);
            this.add(350893L);
            this.add(356256L);
            this.add(361361L);
            this.add(342136L);
            this.add(342007L);
        }
    };

    public static MaterialRcmdDo forkFeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty((Map)featureInfoMap)) {
            return null;
        }
        ArrayList idList = new ArrayList(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = (Long)idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        materialRcmdDo.setType(1);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo));
        System.out.println(((Object)featureMap).toString());
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        System.out.println(MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    public static MaterialRcmdDo forkApiFeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty((Map)featureInfoMap)) {
            return null;
        }
        ArrayList idList = new ArrayList(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = (Long)idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        materialRcmdDo.setType(4);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.putAll(MaterialFeatureParse.generateApiFeatureMapStatic((MaterialFeatureDo)materialFeatureDo));
        logger.warn("featureMap: " + ((Object)featureMap).toString());
        featureMap.putAll(MaterialFeatureParse.generateApiFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        featureMap.put("version", "0");
        logger.warn("featureMap: " + MaterialFeatureParse.generateApiFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    public static MaterialRcmdDo forkApiAlgo25FeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty((Map)featureInfoMap)) {
            return null;
        }
        ArrayList idList = new ArrayList(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = (Long)idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        materialRcmdDo.setType(4);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.putAll(MaterialFeatureParse.generateApiFeatureMapStatic((MaterialFeatureDo)materialFeatureDo));
        logger.warn("featureMap: " + ((Object)featureMap).toString());
        featureMap.putAll(MaterialFeatureParse.generateApiFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        featureMap.put("version", "4");
        logger.warn("featureMap: " + MaterialFeatureParse.generateApiFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    public static MaterialRcmdDo rcmd(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = MaterialRcmder.rank(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmd fm model is null !!!");
        }
        return ret;
    }

    public static MaterialRcmdDo rcmdApi(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = MaterialRcmder.rankApi(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmdApi fm model is null !!!");
        }
        return ret;
    }

    public static MaterialRcmdDo rcmdMergedAd(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = MaterialRcmder.rankMergedAd(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmd fm model is null !!!");
        }
        return ret;
    }

    public static MaterialRcmdDo rcmdNewVersion(FM model, FM secModel, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        ret = MaterialRcmder.rankNewVersion(model, secModel, materialExtractDo, materialFeatureDo);
        return ret;
    }

    public static MaterialRcmdDo rcmdNewVersion1(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        ret = MaterialRcmder.rankNewVersion1(model, materialExtractDo, materialFeatureDo);
        return ret;
    }

    public static MaterialRcmdDo rcmdChangeReRank(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = MaterialRcmder.rankChangeReRank(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmdChangeReRank fm model is null !!!");
        }
        return ret;
    }

    public static MaterialRcmdDo rcmdCtrSep(FM higherModel, FM lowerModel, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        if (higherModel != null && lowerModel != null) {
            ret = MaterialRcmder.rankCtrSep(higherModel, lowerModel, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmdCtrSep fm model is null !!!");
        }
        return ret;
    }

    public static MaterialRcmdDo rank(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }
        HashMap<Long, Double> preCTR = new HashMap();
        preCTR = model.predictsNew(featureDoMap);
        RerankMaterial rerankMaterial = MaterialRcmder.reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        if (reRankId < 0L) {
            return null;
        }
        ret.setMaterialId(reRankId);
        featureMapDo = (FeatureMapDo)featureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;
    }

    public static MaterialRcmdDo rankApi(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateApiFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateApiFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }
        HashMap<Long, Double> preCTR = new HashMap();
        preCTR = model.predictsNew(featureDoMap);
        RerankMaterial rerankMaterial = MaterialRcmder.reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        if (reRankId < 0L) {
            return null;
        }
        ret.setMaterialId(reRankId);
        featureMapDo = (FeatureMapDo)featureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        resultFeatureMap.put("version", "8");
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(4);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;
    }

    public static MaterialRcmdDo rankChangeReRank(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }
        HashMap<Long, Double> preCTR = new HashMap();
        preCTR = model.predictsNew(featureDoMap);
        RerankMaterial rerankMaterial = MaterialRcmder.newReRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), materialExtractDo.getMaterialMatchDoMap());
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        if (reRankId < 0L) {
            return null;
        }
        ret.setMaterialId(reRankId);
        featureMapDo = (FeatureMapDo)featureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;
    }

    public static MaterialRcmdDo rankMergedAd(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategyWithAd(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }
        HashMap<Long, Double> preCTR = new HashMap();
        preCTR = model.predictsNew(featureDoMap);
        RerankMaterial rerankMaterial = MaterialRcmder.reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        if (reRankId < 0L) {
            return null;
        }
        ret.setMaterialId(reRankId);
        featureMapDo = (FeatureMapDo)featureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        if (MaterialMatch.AdvertRelatedMaterialSet.contains(reRankId)) {
            resultFeatureMap.put("advertFlag", "1");
            ret.setType(3);
        } else {
            ret.setType(2);
        }
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;
    }

    public static MaterialRcmdDo rankNewVersion(FM model, FM secModel, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        int advertCnt = MaterialRcmder.calAdvertMaterialCnt(materialFeatureDo);
        double initScore = MaterialRcmder.calUserInitScore(materialFeatureDo);
        double currScore = initScore / (double)(advertCnt + 1);
        boolean advertModelFlag = false;
        if (Math.random() < currScore && AssertUtil.isNotEmpty(materialExtractDo.getMaterialAdvertRelatedDoList())) {
            advertModelFlag = true;
        }
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Object, FeatureMapDo> featureDoMap = new HashMap<Object, FeatureMapDo>();
        Set<Object> recallMaterialSet = new HashSet();
        recallMaterialSet = advertModelFlag ? materialExtractDo.getMaterialAdvertRelatedDoList().stream().map(MaterialMatchDo::getMaterialId).collect(Collectors.toSet()) : MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Object materialId : recallMaterialSet) {
            Map map = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(map);
            featureDoMap.put(materialId, featureMapDo);
        }
        Map<Long, Double> preCTR = new HashMap();
        if (advertModelFlag) {
            for (Long l : recallMaterialSet) {
                preCTR.put(l, Math.random());
            }
        } else if (model != null) {
            preCTR = model.predictsNew(featureDoMap);
        } else {
            logger.warn("rcmdNewVersion first fm model is null !! ");
            return null;
        }
        RerankMaterial rerankMaterial = advertModelFlag ? MaterialRcmder.reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialAdvertRelatedDoList(), false) : MaterialRcmder.reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long l = rerankMaterial.getMaterialId();
        if (l < 0L) {
            return null;
        }
        ret.setMaterialId(l);
        featureMapDo = (FeatureMapDo)featureDoMap.get(l);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        if (advertModelFlag) {
            resultFeatureMap.put("advertFlag", "1");
            ret.setType(3);
        } else {
            ret.setType(2);
        }
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;
    }

    public static MaterialRcmdDo rankNewVersion1(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return null;
        }
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        HashMap<Long, FeatureMapDo> MaterialFeatureDoMap = new HashMap<Long, FeatureMapDo>();
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            MaterialFeatureDoMap.put(materialId, featureMapDo);
        }
        if (model == null) {
            logger.warn("rcmdNewVersion1 fm model is null !! ");
            return null;
        }
        Map MaterialPreCTR = model.predictsNew(MaterialFeatureDoMap);
        RerankMaterial reRankMaterial = MaterialRcmder.newReRank(MaterialPreCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), materialExtractDo.getMaterialMatchDoMap());
        MaterialRcmdDo ret = new MaterialRcmdDo();
        Long reRankId = reRankMaterial.getMaterialId();
        if (reRankId < 0L) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = (FeatureMapDo)MaterialFeatureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setType(2);
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setScore(reRankMaterial.getRankScore());
        ret.setDebugInfo(reRankMaterial.getDebugInfo());
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MaterialRcmdDo rankCtrSep(FM higherModel, FM lowerModel, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        SlotFeature slotFeature = Optional.ofNullable(materialFeatureDo.getSlotFeature()).orElse(new SlotFeature());
        Long slotId = slotFeature.getSlotId();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }
        HashMap<Long, Double> preCTR = new HashMap();
        if (lowerCtrSlotIdSet.contains(slotId)) {
            if (lowerModel == null) {
                logger.warn("rcmdCtrSep lowerModel is null !! ");
                return null;
            }
            preCTR = lowerModel.predictsNew(featureDoMap);
        } else {
            if (higherModel == null) {
                logger.warn("rcmdCtrSep higherModel is null !! ");
                return null;
            }
            preCTR = higherModel.predictsNew(featureDoMap);
        }
        RerankMaterial rerankMaterial = MaterialRcmder.reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        if (reRankId < 0L) {
            return null;
        }
        ret.setMaterialId(reRankId);
        featureMapDo = (FeatureMapDo)featureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;
    }

    private static double calUserInitScore(MaterialFeatureDo materialFeatureDo) {
        UserFeature userFeature = Optional.ofNullable(materialFeatureDo.getUserFeature()).orElse(new UserFeature());
        Integer expHisCnt = userFeature.getExpHisCnt();
        if (expHisCnt != null) {
            if (expHisCnt < 10) {
                return 0.2;
            }
            return 0.3;
        }
        return 0.15;
    }

    private static int calAdvertMaterialCnt(MaterialFeatureDo materialFeatureDo) {
        int count = 0;
        UserFeature userFeature = Optional.ofNullable(materialFeatureDo.getUserFeature()).orElse(new UserFeature());
        if (userFeature.getExpDayMaterials() != null) {
            String[] exposeList;
            for (String exposeId : exposeList = userFeature.getExpDayMaterials().split(",")) {
                if (!MaterialMatch.AdvertRelatedMaterialSet.contains(Long.parseLong(exposeId))) continue;
                ++count;
            }
        }
        if (userFeature.getExpWeekMaterials() != null) {
            String[] sevenExposeList;
            for (String exposeId : sevenExposeList = userFeature.getExpWeekMaterials().split(",")) {
                String[] idArr = exposeId.split("-");
                if (idArr.length < 2 || !MaterialMatch.AdvertRelatedMaterialSet.contains(Long.parseLong(idArr[1]))) continue;
                ++count;
            }
        }
        return count;
    }

    private static Set<Long> mergeMultiRecallStrategy(MaterialExtractDo materialExtractDo) {
        HashSet<Long> recallMaterialSet = new HashSet<Long>();
        materialExtractDo.getMaterialMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        List<MaterialCostMatchDo> materialCostMatchDos = materialExtractDo.getMaterialCostMatchDoList();
        if (AssertUtil.isNotEmpty(materialCostMatchDos)) {
            materialCostMatchDos.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    private static Set<Long> mergeMultiRecallStrategyWithAd(MaterialExtractDo materialExtractDo) {
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        List<MaterialMatchDo> materialAdvertRelatedDoList = materialExtractDo.getMaterialAdvertRelatedDoList();
        if (AssertUtil.isNotEmpty(materialAdvertRelatedDoList)) {
            materialAdvertRelatedDoList.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    private static RerankMaterial reRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList, boolean oldVersionFlag) {
        double judgeLevel;
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        double maxScore = -1.0;
        double rawScore = -1.0;
        int rawExposeCnt = 0;
        int weightedExposeCnt = 0;
        Long resultId = -1L;
        Long oldOrderResultId = -1L;
        double oldMaxScore = -1.0;
        double oldWeightedScore = -1.0;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            Long exposeCnt;
            UserMaterialFeature userMaterialFeature;
            MaterialFeatureInfo materialFeatureInfo;
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            int tmpExposeCnt = 0;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId) && null != (materialFeatureInfo = (MaterialFeatureInfo)materialFeatureInfoMap.get(materialId)) && null != (userMaterialFeature = materialFeatureInfo.getUserMaterialFeature()) && null != (exposeCnt = userMaterialFeature.getUExposeDayCnt())) {
                tmpExposeCnt = exposeCnt.intValue();
                double weight = oldVersionFlag ? Math.pow(Math.E, -0.09 * (double)exposeCnt.longValue()) : 0.01;
                score *= weight;
            }
            preCTR.put(materialId, score);
            if (score > maxScore) {
                maxScore = score;
                resultId = materialId;
                rawScore = tmpScore;
                weightedExposeCnt = tmpExposeCnt;
            }
            if (!(tmpScore > oldMaxScore)) continue;
            oldMaxScore = tmpScore;
            oldOrderResultId = materialId;
            rawExposeCnt = tmpExposeCnt;
            oldWeightedScore = score;
        }
        if (!oldVersionFlag) {
            rerankMaterial.setMaterialId(resultId);
            rerankMaterial.setRankScore(rawScore);
            rerankMaterial.setReRankScore(maxScore);
            return rerankMaterial;
        }
        List sortedList = materialMatchDoList.stream().sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed()).collect(Collectors.toList());
        int size = Math.min(5, sortedList.size());
        boolean flag = false;
        double sum = 0.0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            double ctr = ((MaterialMatchDo)sortedList.get(i)).getCtr();
            sb.append(String.format("%.5f", ctr) + ";");
            sum += ctr;
        }
        double avgCtr = sum / (double)size;
        double faithLevel = 0.7;
        double currCtr = 0.0;
        for (MaterialMatchDo materialMatchDo : materialMatchDoList) {
            if (!resultId.equals(materialMatchDo.getMaterialId())) continue;
            currCtr = materialMatchDo.getCtr();
            break;
        }
        if (currCtr >= (judgeLevel = avgCtr * faithLevel)) {
            flag = true;
        }
        if (!flag) {
            resultId = oldOrderResultId;
            rawScore = oldMaxScore;
            maxScore = oldMaxScore;
        }
        StringBuilder debugInfo = new StringBuilder();
        if (resultId.equals(oldOrderResultId)) {
            debugInfo.append("1#");
            debugInfo.append(rawExposeCnt + "#");
            debugInfo.append(String.format("%.5f", oldWeightedScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f", judgeLevel) + "#");
            debugInfo.append(String.format("%.5f", currCtr));
        } else {
            debugInfo.append("0#");
            debugInfo.append(weightedExposeCnt + "#");
            debugInfo.append(String.format("%.5f", maxScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f", judgeLevel) + "#");
            debugInfo.append(String.format("%.5f", currCtr) + "#");
            debugInfo.append(oldOrderResultId + "#");
            debugInfo.append(String.format("%.5f", oldMaxScore) + "#");
            debugInfo.append(String.format("%.5f", oldWeightedScore) + "#");
            debugInfo.append(rawExposeCnt);
        }
        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        rerankMaterial.setDebugInfo(debugInfo.toString());
        return rerankMaterial;
    }

    private static RerankMaterial newReRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList, Map<Long, MaterialMatchDo> materialMatchDoMap) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        Long oldOrderResultId = -1L;
        double oldMaxScore = -1.0;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }
        ArrayList<RankMaterialInfo> rankMaterialInfoList = new ArrayList<RankMaterialInfo>();
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            Long exposeCnt;
            UserMaterialFeature userMaterialFeature;
            MaterialFeatureInfo materialFeatureInfo;
            double score = entry.getValue();
            Long materialId = entry.getKey();
            long tmpExposeCnt = 0L;
            double tmpScore = score;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId) && null != (materialFeatureInfo = (MaterialFeatureInfo)materialFeatureInfoMap.get(materialId)) && null != (userMaterialFeature = materialFeatureInfo.getUserMaterialFeature()) && null != (exposeCnt = userMaterialFeature.getUExposeDayCnt())) {
                tmpExposeCnt = exposeCnt;
                double weight = Math.pow(Math.E, -0.09 * (double)exposeCnt.longValue());
                score *= weight;
            }
            if (tmpScore > oldMaxScore) {
                oldMaxScore = tmpScore;
                oldOrderResultId = materialId;
            }
            RankMaterialInfo rankMaterialInfo = new RankMaterialInfo();
            rankMaterialInfo.setMaterialId(materialId);
            rankMaterialInfo.setDayExposeCnt(tmpExposeCnt);
            rankMaterialInfo.setRankScore(tmpScore);
            rankMaterialInfo.setReRankScore(score);
            if (materialMatchDoMap.containsKey(materialId)) {
                MaterialMatchDo materialMatchDo = materialMatchDoMap.get(materialId);
                rankMaterialInfo.setCtr(materialMatchDo.getCtr());
                rankMaterialInfo.setLastExposeCnt(materialMatchDo.getExposeCnt());
            }
            rankMaterialInfoList.add(rankMaterialInfo);
        }
        List sortedMaterialList = rankMaterialInfoList.stream().sorted(Comparator.comparing(RankMaterialInfo::getReRankScore).reversed()).collect(Collectors.toList());
        List sortedList = materialMatchDoList.stream().sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed()).collect(Collectors.toList());
        int size = Math.min(5, sortedList.size());
        double sum = 0.0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            double ctr = ((MaterialMatchDo)sortedList.get(i)).getCtr();
            sb.append(String.format("%.5f", ctr) + ";");
            sum += ctr;
        }
        double avgCtr = sum / (double)size;
        double faithLevel = 0.7;
        double judgeLevel = avgCtr * faithLevel;
        Long leastExpose = 500L;
        RankMaterialInfo resultMaterial = new RankMaterialInfo();
        for (RankMaterialInfo rankMaterialInfo : sortedMaterialList) {
            Double ctr = rankMaterialInfo.getCtr();
            if (ctr == null || !(ctr >= judgeLevel) && rankMaterialInfo.getLastExposeCnt() > leastExpose) continue;
            resultMaterial = rankMaterialInfo;
            break;
        }
        StringBuilder debugInfo = new StringBuilder();
        debugInfo.append(oldOrderResultId + "#");
        debugInfo.append(String.format("%.5f", oldMaxScore) + "#");
        int cutSize = Math.min(5, sortedMaterialList.size());
        debugInfo.append(JSON.toJSONString(sortedMaterialList.stream().limit(cutSize).collect(Collectors.toList())) + "#");
        debugInfo.append(sb.toString() + "#");
        debugInfo.append(String.format("%.5f", judgeLevel));
        if (resultMaterial.getMaterialId() == null) {
            rerankMaterial.setMaterialId(-1L);
            return rerankMaterial;
        }
        rerankMaterial.setMaterialId(resultMaterial.getMaterialId());
        rerankMaterial.setRankScore(resultMaterial.getRankScore());
        rerankMaterial.setReRankScore(resultMaterial.getReRankScore());
        rerankMaterial.setDebugInfo(debugInfo.toString());
        return rerankMaterial;
    }

    public static void main(String[] args) {
        String string = " {\"deviceId\":\"7183214b04e218e99d43746c908b27b0\",\"materialFeatureMap\":{561:{\"bConvertWeekCnt\":2,\"clickDayCnt\":2720,\"clickWeekCnt\":1733,\"convertWeekCnt\":48,\"customization\":\"1431\",\"designHue\":\"1987\",\"exposeDayCnt\":163886,\"exposeWeekCnt\":93856,\"industry\":\"1407\",\"materialId\":561,\"rewardElement\":\"1899\",\"slotNature\":\"1443\"}},\"rid\":\"123456\",\"slotFeature\":{\"appId\":76235,\"appIndustryTagId\":\"198\",\"appIndustryTagPid\":\"196\",\"slotId\":352313,\"slotType\":9},\"slotMaterialFeatureMap\":{561:{\"slotBConvertHistCnt\":2,\"slotBConvertWeekCnt\":2,\"slotClickDayCnt\":2720,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1728,\"slotConvertHistCnt\":49,\"slotConvertWeekCnt\":48,\"slotExposeDayCnt\":163886,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":93851}},\"userFeature\":{\"age\":\"010212\",\"appList\":\"14924\",\"consumeLevel\":\"05011701\",\"expDayMaterials\":\"22099,3591,27170\",\"expWeekMaterials\":\"20200729203127-561,20200728093434-26869,20200728094320-27169,20200728094210-27170,20200723183928-27171\",\"marry\":\"01050303\",\"permanentProvince\":\"\u5e7f\u897f\",\"sex\":\"010102\"},\"userMaterialFeatureMap\":{561:{\"uExposeHistCnt\":3,\"uExposeInterval\":1,\"uExposePeriod\":5,\"uExposeWeekCnt\":3}}}";
        MaterialFeatureDo exp = (MaterialFeatureDo)JSONObject.parseObject((String)string, MaterialFeatureDo.class);
        MaterialRcmdDo ret = MaterialRcmder.forkApiFeatureParse(exp);
        System.out.println(JSONObject.toJSONString((Object)ret));
    }
}

