/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.FM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFiltering {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFiltering.class);
    private static double[] PRE_CTR_BUCKET = new double[]{0.002, 0.003, 0.005, 0.007, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1};

    public static FlowFilterResultDo getFlowFiltering(FlowFilterRequestDo flowFilterRequestDo) {
        FlowFilterResultDo ret = new FlowFilterResultDo();
        try {
            Integer flowFilterLabel = 0;
            Integer preInterval = null;
            Integer filterIndex = 1;
            Double filterRate = 0.0;
            boolean isConfident = false;
            Integer filterType = 0;
            Double preCtr = null;
            if (AdxFlowFiltering.valid(flowFilterRequestDo).booleanValue()) {
                FM ctrFmModel = flowFilterRequestDo.getCtrFmModel();
                AdxFeatureDo adxFeatureDo = flowFilterRequestDo.getAdxFeatureDo();
                Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
                Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)adxFeatureDo, (AdxFeatureDo)adxFeatureDo);
                HashMap featureMap = new HashMap();
                if (AssertUtil.isNotEmpty((Map)staticFeatureMap)) {
                    featureMap.putAll(staticFeatureMap);
                }
                if (AssertUtil.isNotEmpty((Map)dynamicFeatureMap)) {
                    featureMap.putAll(dynamicFeatureMap);
                }
                preCtr = ctrFmModel.predict(featureMap);
            }
            AdxFlowInfoDo flowInfo = flowFilterRequestDo.getFlowInfo();
            AdxFilterInfoDo filterInfo1 = flowFilterRequestDo.getFilterInfo1();
            AdxFilterInfoDo filterInfo2 = flowFilterRequestDo.getFilterInfo2();
            if (AssertUtil.isNotEmpty((Object)flowInfo)) {
                Map<Integer, Double> filterMap;
                AdxFilterInfoDo filterInfo;
                Map<Integer, Long> testRateMap = flowInfo.getTestRate();
                filterIndex = AdxFlowFiltering.getFilterIndex(testRateMap);
                preInterval = AdxStatData.bucket(preCtr, PRE_CTR_BUCKET);
                AdxFilterInfoDo adxFilterInfoDo = filterIndex < 2 ? null : (filterInfo = filterIndex < 3 ? filterInfo1 : filterInfo2);
                if (AssertUtil.isNotEmpty(filterInfo) && AssertUtil.isAllNotEmpty((Object[])new Object[]{preInterval, filterMap = filterInfo.getFilterMap()})) {
                    filterRate = AdxStatData.nullToDefault(filterMap.get(preInterval), 0.0);
                }
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaDayComputes.getConfident();
                double random = Math.random();
                if (isConfident) {
                    if (filterIndex.equals(2)) {
                        flowFilterLabel = random < filterRate ? 1 : 0;
                    } else if (filterIndex.equals(3)) {
                        Long imeiExp = AdxStatData.nullToDefault(flowInfo.getHistoryImeiExp(), 0L);
                        Long imeiClick = AdxStatData.nullToDefault(flowInfo.getHistoryImeiClick(), 0L);
                        flowFilterLabel = imeiExp > 20L && imeiClick < 1L ? Integer.valueOf(random < 0.99 ? 1 : 0) : (imeiExp > 10L && imeiClick < 1L ? Integer.valueOf(random < filterRate ? 1 : 0) : (imeiExp < 1L && imeiClick < 1L ? Integer.valueOf(random < filterRate * 0.7 ? 1 : 0) : Integer.valueOf(random < filterRate * 0.9 ? 1 : 0)));
                    }
                }
            }
            filterType = flowFilterLabel == 1 ? 1 : 0;
            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setPreInterval(preInterval);
            ret.setFilterIndex(filterIndex);
            ret.setPreCtr(preCtr);
            ret.setFilterType(filterType);
        }
        catch (Exception e) {
            logger.error("AdxFlowFiltering.getFlowFiltering error:" + e);
        }
        return ret;
    }

    public static Integer getFilterIndex(Map<Integer, Long> testRateMap) {
        Integer ret = 1;
        if (AssertUtil.isNotEmpty(testRateMap)) {
            ArrayList<Integer> keyList = new ArrayList<Integer>(testRateMap.keySet());
            ArrayList<Long> valueList = new ArrayList<Long>(testRateMap.values());
            Integer retIndex = AdxStatData.getFlowSplit(valueList);
            ret = (Integer)keyList.get(retIndex);
        }
        return ret;
    }

    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {
        Boolean ret = true;
        if (flowFilterRequestDo == null) {
            logger.error("AdxFlowFiltering.getFlowFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }
        if (flowFilterRequestDo.getCtrFmModel() == null) {
            logger.error("AdxFlowFiltering.getFlowFiltering() input params valid , params ctrFmModel is null");
            return false;
        }
        if (flowFilterRequestDo.getAdxFeatureDo() == null) {
            logger.error("AdxFlowFiltering.getFlowFiltering() input params valid ,params adxFeatureDo is null");
            return false;
        }
        return ret;
    }
}

