package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.MaterialFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.alg.material.MaterialMatch.AdvertRelatedMaterialSet;

public class MaterialRcmder {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(MaterialRcmder.class);

    public static List<Long> lowerCtrSlotIdSet = new ArrayList<Long>() {
        {
            add(478L);
            add(355616L);
            add(351411L);
            add(352313L);
            add(350893L);
            add(356256L);
            add(361361L);
            add(342136L);
            add(342007L);
        }
    };

    public static MaterialRcmdDo forkFeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map<Long, MaterialFeatureInfo> featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty(featureInfoMap)) {
            return null;
        }
        List<Long> idList = new ArrayList<>(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }

        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        // 旧版算法对应type为1
        materialRcmdDo.setType(1);
        // 获取素材id对应的特征，构建推荐结果对象
        Map<String, String> featureMap = new HashMap<>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo));
        System.out.println(featureMap.toString());
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        System.out.println(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }


    public static MaterialRcmdDo forkApiFeatureParse(MaterialFeatureDo materialFeatureDo) {
        Map<Long, MaterialFeatureInfo> featureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        if (AssertUtil.isEmpty(featureInfoMap)) {
            return null;
        }
        List<Long> idList = new ArrayList<>(featureInfoMap.keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }

        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        // api流量请求对应type为4
        materialRcmdDo.setType(4);
        // 获取素材id对应的特征，构建推荐结果对象
        Map<String, String> featureMap = new HashMap<>();
        featureMap.putAll(MaterialFeatureParse.generateApiFeatureMapStatic(materialFeatureDo));
//        logger.warn("featureMap: " + featureMap.toString());
        featureMap.putAll(MaterialFeatureParse.generateApiFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        if (materialFeatureDo.getFlowType() == null) {
            featureMap.put("version", "0");  // 版本号为0表示人工投放的素材流量
        } else {
            featureMap.put("version", materialFeatureDo.getFlowType());  // 版本号为4表示旧版的UCB算法的流量
        }
//        logger.warn("featureMap: " + MaterialFeatureParse.generateApiFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    /**
     * DPA1.1 排序接口
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmd(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = rank(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmd fm model is null !!!");
        }

        return ret;
    }

    /**
     * DPA-Api1.0 排序接口
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdApi(FM model,
                                         MaterialExtractDo materialExtractDo,
                                         MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = rankApi(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmdApi fm model is null !!!");
        }

        return ret;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/10/12
     * @methodParameters: [model, materialExtractDo, materialFeatureDo]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo
     * @description: 广告利益点素材+普通素材online pk模型
     */
    public static MaterialRcmdDo rcmdMergedAd(FM model,
                                              MaterialExtractDo materialExtractDo,
                                              MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = rankMergedAd(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmd fm model is null !!!");
        }

        return ret;
    }

    /**
     * DPA2.0排序接口-随机试投
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdNewVersion(FM model,
                                                FM secModel,
                                                MaterialExtractDo materialExtractDo,
                                                MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        ret = rankNewVersion(model, secModel, materialExtractDo, materialFeatureDo);
        return ret;
    }

    /**
     * DPA2.1排序接口，广告利益点素材使用模型来排序
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdNewVersion1(FM model,
                                                 MaterialExtractDo materialExtractDo,
                                                 MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        ret = rankNewVersion1(model, materialExtractDo, materialFeatureDo);
        return ret;
    }

    /**
     * DPA2.2 调整重排接口
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdChangeReRank(FM model,
                                                  MaterialExtractDo materialExtractDo,
                                                  MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = rankChangeReRank(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmdChangeReRank fm model is null !!!");
        }

        return ret;
    }

    /**
     * DPA3.0 排序接口,按CTR分模型预测
     *
     * @param higherModel       V010模型
     * @param lowerModel        低CTR模型
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo 特征
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdCtrSep(FM higherModel,
                                            FM lowerModel,
                                            MaterialExtractDo materialExtractDo,
                                            MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (higherModel != null && lowerModel != null) {
            ret = rankCtrSep(higherModel, lowerModel, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmdCtrSep fm model is null !!!");
        }

        return ret;
    }

    /**
     * DPA2.3 增加针对新用户的推荐策略
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmdSepNewAndOld(FM model,
                                                  MaterialExtractDo materialExtractDo,
                                                  MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
        if (model != null) {
            ret = rankAddNewUsrRclWay(model, materialExtractDo, materialFeatureDo);
        } else {
            logger.warn("rcmdChangeReRank fm model is null !!!");
        }

        return ret;
    }

    public static MaterialRcmdDo rank(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    public static MaterialRcmdDo rankApi(FM model,
                                         MaterialExtractDo materialExtractDo,
                                         MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateApiFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateApiFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        resultFeatureMap.put("version", materialFeatureDo.getFlowType());  // 版本号为8表示新版算法的流量
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(4);  // api流量请求对应type为4
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    public static MaterialRcmdDo rankChangeReRank(FM model,
                                                  MaterialExtractDo materialExtractDo,
                                                  MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = newReRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), materialExtractDo.getMaterialMatchDoMap());
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/10/12
     * @methodParameters: [model, materialExtractDo, materialFeatureDo]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo
     * @description: 广告利益点素材排序模型：多路召回add利益点素材
     */
    public static MaterialRcmdDo rankMergedAd(FM model,
                                              MaterialExtractDo materialExtractDo,
                                              MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategyWithAd(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        // 广告素材利益点区分普通素材
        if (AdvertRelatedMaterialSet.contains(reRankId)) {
            resultFeatureMap.put("advertFlag", "1");
            ret.setType(3);
        } else {
            ret.setType(2);
        }
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());

        return ret;
    }

    /**
     * @return 返回值说明
     * @description 加入广告利益点素材排序
     * @date 2020/10/12
     */
    public static MaterialRcmdDo rankNewVersion1(FM model,
                                                 MaterialExtractDo materialExtractDo,
                                                 MaterialFeatureDo materialFeatureDo) throws Exception {

        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return null;
        }

        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);
        // 添加券点击侧新增的特征以及需要根据素材id和二级类目之间的映射关系，完成FeatureMap中的广告二级类目id的填充
        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：传统素材动态特征
        Map<Long, FeatureMapDo> MaterialFeatureDoMap = new HashMap<>();
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);
            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            MaterialFeatureDoMap.put(materialId, featureMapDo);
        }

        //4 模型预估
        Map<Long, Double> MaterialPreCTR;
        if (model != null) {
            MaterialPreCTR = model.predictsNew(MaterialFeatureDoMap);
        } else {
            logger.warn("rcmdNewVersion1 fm model is null !! ");
            return null;
        }

        // 5 重排策略；包括曝光降权
        RerankMaterial reRankMaterial = newReRank(MaterialPreCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), materialExtractDo.getMaterialMatchDoMap());

        MaterialRcmdDo ret = new MaterialRcmdDo();
        Long reRankId = reRankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = MaterialFeatureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setType(2);
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setScore(reRankMaterial.getRankScore());
        ret.setDebugInfo(reRankMaterial.getDebugInfo());
        return ret;
    }

    /**
     * @return 返回值说明
     * @description 按照PV CTR 的值（3%）将全量的广告位分为低CTR广告位和高CTR广告位，根据CTR信息选择预测是走哪路分支
     * @date 2020/11/2
     */
    public static MaterialRcmdDo rankCtrSep(FM higherModel,
                                            FM lowerModel,
                                            MaterialExtractDo materialExtractDo,
                                            MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        //获取当前广告位ID
        SlotFeature slotFeature = Optional.ofNullable(materialFeatureDo.getSlotFeature()).orElse(new SlotFeature());
        Long slotId = slotFeature.getSlotId();

        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        if (lowerCtrSlotIdSet.contains(slotId)) {
            if (lowerModel != null) {
                preCTR = lowerModel.predictsNew(featureDoMap);
            } else {
                logger.warn("rcmdCtrSep lowerModel is null !! ");
                return null;
            }
        } else {
            if (higherModel != null) {
                preCTR = higherModel.predictsNew(featureDoMap);
            } else {
                logger.warn("rcmdCtrSep higherModel is null !! ");
                return null;
            }
        }

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    /**
     * @return 返回值说明
     * @description 增加针对新用户的推荐策略
     * @date 2020/12/03
     */
    public static MaterialRcmdDo rankAddNewUsrRclWay(FM model,
                                                     MaterialExtractDo materialExtractDo,
                                                     MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        //获取当前广告位ID
//        SlotFeature slotFeature = Optional.ofNullable(materialFeatureDo.getSlotFeature()).orElse(new SlotFeature());
//        Long slotId = slotFeature.getSlotId();
        //获取当前用户情况(是否是新用户)
        UserFeature userFeature = Optional.ofNullable(materialFeatureDo.getUserFeature()).orElse(new UserFeature());
        Integer isNewUsr = userFeature.getExpHisCnt();
        //获取当前曝光小时(对新用户推荐时在对应的小时桶号中取数)
//        MaterialContextFeature materialContextFeature = Optional.ofNullable(materialFeatureDo.getMaterialContextFeature()).orElse(new MaterialContextFeature());
//        String curHour = materialContextFeature.getExposeHour();
        // 获取对新用户召回的素材列表
        SlotFeature slotFeature = Optional.ofNullable(materialFeatureDo.getSlotFeature()).orElse(new SlotFeature());
        String recallSckSetForNewUsr = slotFeature.getRecallSckIdLstForNewUsr();

        // 判断透出逻辑
        boolean usrFlag = false;
        if (isNewUsr == null || isNewUsr == 0 ) {
            usrFlag = true;
        }

        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }

        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        Map<Long, Double> preCTR = new HashMap<>();
        List<Map<String, Object>> recallSckForNewUsrByStrategy = new ArrayList<Map<String, Object>>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = new HashSet<>();
        if (usrFlag && AssertUtil.isNotEmpty(recallSckSetForNewUsr) && JSONObject.parseObject(recallSckSetForNewUsr).size() > 1) {
            //新用户
            JSONObject jsonObject = JSONObject.parseObject(recallSckSetForNewUsr);
            for (String id : jsonObject.keySet()) {
                recallMaterialSet.add(Long.valueOf(id));
                //走策略
                preCTR.put(Long.valueOf(id), jsonObject.getDouble(id));
                Map<String, Object> curTmp = new HashMap<>();
                curTmp.put("materialId", Long.valueOf(id));
                curTmp.put("ctr", jsonObject.getDouble(id));
                recallSckForNewUsrByStrategy.add(curTmp);
            }
//            logger.warn("Recommended by strategy." + "And total recommend result: {}." , recallSckSetForNewUsr);
        } else {
            //老用户
            recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);
        }

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }

        //4 模型预估
        if (AssertUtil.isEmpty(recallMaterialSet) && model != null) {
            // 走模型
//            logger.warn("Recommended by model.");
            preCTR = model.predictsNew(featureDoMap);
        } else if(AssertUtil.isEmpty(recallSckForNewUsrByStrategy)){
            logger.warn("rcmdNewVersion first fm model is null !! ");
            return null;
        }


        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial;
        rerankMaterial = reRankSepNewAndOldUsr(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), recallSckForNewUsrByStrategy, usrFlag);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
//        // 新老用户区分
//        if(usrFlag){
//            resultFeatureMap.put("isNewUsr","1");
//        }else{
//            resultFeatureMap.put("isNewUsr","0");
//        }
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
        return ret;

    }

    /**
     * @return 返回值说明
     * @description 加入广告利益点素材排序
     * @date 2020/9/14
     */
    public static MaterialRcmdDo rankNewVersion(FM model,
                                                FM secModel,
                                                MaterialExtractDo materialExtractDo,
                                                MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        // 计算广告利益点素材当天及过去7天的曝光次数
        int advertCnt = calAdvertMaterialCnt(materialFeatureDo);
        // 根据用户的历史曝光次数对不同用户设置不同的投放概率
        double initScore = calUserInitScore(materialFeatureDo);

        double currScore = initScore / (advertCnt + 1);
        // 判断透出逻辑
        boolean advertModelFlag = false;
        // && secModel != null
        if (Math.random() < currScore && AssertUtil.isNotEmpty(materialExtractDo.getMaterialAdvertRelatedDoList())) {
            // 透出广告利益点素材，投放策略：使用模型
            advertModelFlag = true;
        }

        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }


        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = new HashSet<>();
        if (advertModelFlag) {
            // 广告利益点素材
            recallMaterialSet = materialExtractDo
                    .getMaterialAdvertRelatedDoList().stream()
                    .map(MaterialMatchDo::getMaterialId)
                    .collect(Collectors.toSet());
        } else {
            recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);
        }
        // 添加券点击侧新增的特征以及需要根据素材id和二级类目之间的映射关系，完成FeatureMap中的广告二级类目id的填充
        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);
            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        if (advertModelFlag) {
            // 随机投放
            for (Long id : recallMaterialSet) {
                preCTR.put(id, Math.random());
            }
//            preCTR = secModel.predictsNew(featureDoMap);
        } else {
            if (model != null) {
                preCTR = model.predictsNew(featureDoMap);
            } else {
                logger.warn("rcmdNewVersion first fm model is null !! ");
                return null;
            }
        }

        // 5 重排策略；包括曝光降权
        RerankMaterial rerankMaterial;
        if (advertModelFlag) {
            rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialAdvertRelatedDoList(), false);
        } else {
            rerankMaterial = reRank(preCTR, materialFeatureDo, materialExtractDo.getMaterialMatchDoList(), true);
        }
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        // 空结果情况
        if (reRankId < 0) {
            return null;
        }
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        // 6 区分不同类型的结果展示
        if (advertModelFlag) {
            resultFeatureMap.put("advertFlag", "1");
            ret.setType(3);
        } else {
            ret.setType(2);
        }
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());

        ret.setScore(rerankMaterial.getRankScore());
        ret.setDebugInfo(rerankMaterial.getDebugInfo());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }


    private static double calUserInitScore(MaterialFeatureDo materialFeatureDo) {
        UserFeature userFeature = Optional.ofNullable(materialFeatureDo.getUserFeature()).orElse(new UserFeature());
        Integer expHisCnt = userFeature.getExpHisCnt();
        if (expHisCnt != null) {
            if (expHisCnt < 10) {
                return 0.20;
            }
            return 0.30;
        }
        return 0.15;
    }

    private static int calAdvertMaterialCnt(MaterialFeatureDo materialFeatureDo) {
        int count = 0;
        UserFeature userFeature = Optional.ofNullable(materialFeatureDo.getUserFeature()).orElse(new UserFeature());
        if (userFeature.getExpDayMaterials() != null) {
            String[] exposeList = userFeature.getExpDayMaterials().split(",");
            for (String exposeId : exposeList) {
                if (AdvertRelatedMaterialSet.contains(Long.parseLong(exposeId))) {
                    count++;
                }
            }
        }

        if (userFeature.getExpWeekMaterials() != null) {
            String[] sevenExposeList = userFeature.getExpWeekMaterials().split(",");
            for (String exposeId : sevenExposeList) {
                String[] idArr = exposeId.split("-");
                if (idArr.length >= 2) {
                    if (AdvertRelatedMaterialSet.contains(Long.parseLong(idArr[1]))) {
                        count++;
                    }
                }

            }
        }
        return count;
    }

    /**
     * @return 返回值说明
     * @description merge多路召回结果
     * @date 2020/7/24
     */
    private static Set<Long> mergeMultiRecallStrategy(MaterialExtractDo materialExtractDo) {
        Set<Long> recallMaterialSet = new HashSet<>();
        materialExtractDo.getMaterialMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        List<MaterialCostMatchDo> materialCostMatchDos = materialExtractDo.getMaterialCostMatchDoList();
        if (AssertUtil.isNotEmpty(materialCostMatchDos)) {
            materialCostMatchDos.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    private static Set<Long> mergeMultiRecallStrategyWithAd(MaterialExtractDo materialExtractDo) {
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);
        List<MaterialMatchDo> materialAdvertRelatedDoList = materialExtractDo.getMaterialAdvertRelatedDoList();
        if (AssertUtil.isNotEmpty(materialAdvertRelatedDoList)) {
            materialAdvertRelatedDoList.forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        }
        return recallMaterialSet;
    }

    static class MapComparatorDesc implements Comparator<Map<String, Object>> {
        @Override
        public int compare(Map<String, Object> m1, Map<String, Object> m2) {
            Double v1 = Double.valueOf(m1.get("ctr").toString());
            Double v2 = Double.valueOf(m2.get("ctr").toString());
            if (v2 != null) {
                return v2.compareTo(v1);
            }
            return 0;
        }
    }

    private static RerankMaterial reRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList, boolean oldVersionFlag) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map<Long, MaterialFeatureInfo> materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        double maxScore = -1;
        double rawScore = -1;
        int rawExposeCnt = 0;
        int weightedExposeCnt = 0;
        Long resultId = -1L;
        Long oldOrderResultId = -1L;
        double oldMaxScore = -1;
        double oldWeightedScore = -1;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }

        // 传统素材：更为缓和的曝光降权方式，尽量保持模型的排序；广告素材：相对衰减速度更快的降权方式
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            int tmpExposeCnt = 0;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId)) {
                MaterialFeatureInfo materialFeatureInfo = materialFeatureInfoMap.get(materialId);
                if (null != materialFeatureInfo) {
                    UserMaterialFeature userMaterialFeature = materialFeatureInfo.getUserMaterialFeature();
                    if (null != userMaterialFeature) {
                        Long exposeCnt = userMaterialFeature.getUExposeDayCnt();
                        // 当天曝光降权
                        if (null != exposeCnt) {
                            tmpExposeCnt = exposeCnt.intValue();
                            double weight;
                            if (oldVersionFlag) {
                                weight = Math.pow(Math.E, -0.09 * exposeCnt);
                            } else {
                                weight = 0.01;
                            }
                            score = score * weight;
                        }
                    }
                }
            }
            preCTR.put(materialId, score);
            if (score > maxScore) {
                maxScore = score;
                resultId = materialId;
                rawScore = tmpScore;
                weightedExposeCnt = tmpExposeCnt;
            }
            if (tmpScore > oldMaxScore) {
                oldMaxScore = tmpScore;
                oldOrderResultId = materialId;
                rawExposeCnt = tmpExposeCnt;
                oldWeightedScore = score;
            }
        }

        // 广告利益点素材投放
        if (!oldVersionFlag) {
            rerankMaterial.setMaterialId(resultId);
            rerankMaterial.setRankScore(rawScore);
            rerankMaterial.setReRankScore(maxScore);
            return rerankMaterial;
        }

        // 判断重排后的素材是否在top5素材的平均水平的70%，防止出现非常差的素材
        List<MaterialMatchDo> sortedList = materialMatchDoList.stream()
                .sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed())
                .collect(Collectors.toList());

        int size = Math.min(5, sortedList.size());
        boolean flag = false;
        double sum = 0.0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; i++) {
            double ctr = sortedList.get(i).getCtr();
            sb.append(String.format("%.5f", ctr) + ";");
            sum += ctr;
        }
        double avgCtr = sum / size;
        double faithLevel = 0.7;
        double currCtr = 0.0;
        for (MaterialMatchDo materialMatchDo : materialMatchDoList) {
            if (resultId.equals(materialMatchDo.getMaterialId())) {
                currCtr = materialMatchDo.getCtr();
                break;
            }
        }
        double judgeLevel = avgCtr * faithLevel;
        if (currCtr >= judgeLevel) {
            flag = true;
        }
        if (!flag) {
            resultId = oldOrderResultId;
            rawScore = oldMaxScore;
            maxScore = oldMaxScore;
        }
        // debug 格式：透出结果是否为原始top1 # 透出结果曝光次数 # 透出结果重排分数 # top 5 ctr信息 # 判断70%的分数 # 当前ctr分数 # （option 透出非原始top1时）原始top1 id # 原始分数 # 重排分数 # 曝光次数
        StringBuilder debugInfo = new StringBuilder();
        if (resultId.equals(oldOrderResultId)) {
            debugInfo.append("1" + "#");
            debugInfo.append(rawExposeCnt + "#");
            debugInfo.append(String.format("%.5f", oldWeightedScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f", judgeLevel) + "#");
            debugInfo.append(String.format("%.5f", currCtr));
        } else {
            debugInfo.append("0" + "#");
            debugInfo.append(weightedExposeCnt + "#");
            debugInfo.append(String.format("%.5f", maxScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f", judgeLevel) + "#");
            debugInfo.append(String.format("%.5f", currCtr) + "#");
            debugInfo.append(oldOrderResultId + "#");
            debugInfo.append(String.format("%.5f", oldMaxScore) + "#");
            debugInfo.append(String.format("%.5f", oldWeightedScore) + "#");
            debugInfo.append(rawExposeCnt);
        }

        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        rerankMaterial.setDebugInfo(debugInfo.toString());
        return rerankMaterial;

    }

    private static RerankMaterial reRankSepNewAndOldUsr(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList, List<Map<String, Object>> recallSckForNewUsrByStrategy, boolean isNewUsr) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map<Long, MaterialFeatureInfo> materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();
        double maxScore = -1;
        double rawScore = -1;
        int rawExposeCnt = 0;
        int weightedExposeCnt = 0;
        Long resultId = -1L;
        Long oldOrderResultId = -1L;
        double oldMaxScore = -1;
        double oldWeightedScore = -1;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }

        // 老用户：更为缓和的曝光降权方式，尽量保持模型的排序；新用户：相对衰减速度更快的降权方式
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            int tmpExposeCnt = 0;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId)) {
                MaterialFeatureInfo materialFeatureInfo = materialFeatureInfoMap.get(materialId);
                if (null != materialFeatureInfo) {
                    UserMaterialFeature userMaterialFeature = materialFeatureInfo.getUserMaterialFeature();
                    if (null != userMaterialFeature) {
                        Long exposeCnt = userMaterialFeature.getUExposeDayCnt();
                        // 当天曝光降权
                        if (null != exposeCnt) {
                            tmpExposeCnt = exposeCnt.intValue();
                            double weight;
                            if (isNewUsr && AssertUtil.isNotEmpty(recallSckForNewUsrByStrategy) && recallSckForNewUsrByStrategy.size() > 1) {  //新用户并且召回素材非空
                                weight = Math.pow(Math.E, -0.18 * exposeCnt);
                            } else {
                                weight = Math.pow(Math.E, -0.09 * exposeCnt);
                            }
                            score = score * weight;
                        }
                    }
                }
            }
            preCTR.put(materialId, score);
            if (score > maxScore) {
                maxScore = score;
                resultId = materialId;
                rawScore = tmpScore;
                weightedExposeCnt = tmpExposeCnt;
            }
            if (tmpScore > oldMaxScore) {
                oldMaxScore = tmpScore;
                oldOrderResultId = materialId;
                rawExposeCnt = tmpExposeCnt;
                oldWeightedScore = score;
            }
        }

        // 判断重排后的素材是否在top5素材的平均水平的70%，防止出现非常差的素材
        int size;
        boolean flag = false;
        double sum = 0.0;
        StringBuilder sb = new StringBuilder();
        double avgCtr;
        double faithLevel = 0.7;
        double currCtr = 0.0;
        if (!isNewUsr || !AssertUtil.isNotEmpty(recallSckForNewUsrByStrategy) || recallSckForNewUsrByStrategy.size() <= 1) {    // 老用户或新用户召回通道中召回素材为空或当前时段中召回素材的数目为1
            List<MaterialMatchDo> sortedList = materialMatchDoList.stream()
                    .sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed())
                    .collect(Collectors.toList());
            size = Math.min(5, sortedList.size());
            for (int i = 0; i < size; i++) {
                double ctr = sortedList.get(i).getCtr();
                sb.append(String.format("%.5f", ctr) + ";");
                sum += ctr;
            }
            avgCtr = sum / size;
            for (MaterialMatchDo materialMatchDo : materialMatchDoList) {
                if (resultId.equals(materialMatchDo.getMaterialId())) {
                    currCtr = materialMatchDo.getCtr();
                    break;
                }
            }
        } else {    // 新用户且当前时段召回通道中素材数目大于等于2
            recallSckForNewUsrByStrategy.sort(new MapComparatorDesc());    // 对列表中的字典按照ctr值进行排序(降序)
            List<Map<String, Object>> sortedList = recallSckForNewUsrByStrategy;
            size = Math.min(5, sortedList.size());
            for (int i = 0; i < size; i++) {
                double ctr = (Double) sortedList.get(i).get("ctr");
                sb.append(String.format("%.5f", ctr) + ";");
                sum += ctr;
            }
            avgCtr = sum / size;
            for (Map<String, Object> item : sortedList) {
                if (resultId.equals(item.get("MaterialId"))) {
                    currCtr = (Double) item.get("ctr");
                    break;
                }
            }
        }

        double judgeLevel = avgCtr * faithLevel;
        if (currCtr >= judgeLevel) {
            flag = true;
        }
        if (!flag) {
            resultId = oldOrderResultId;
            rawScore = oldMaxScore;
            maxScore = oldMaxScore;
        }
        // debug 格式：透出结果是否为原始top1 # 透出结果曝光次数 # 透出结果重排分数 # top 5 ctr信息 # 判断70%的分数 # 当前ctr分数 # （option 透出非原始top1时）原始top1 id # 原始分数 # 重排分数 # 曝光次数
        StringBuilder debugInfo = new StringBuilder();
        if (resultId.equals(oldOrderResultId)) {
            debugInfo.append("1" + "#");
            debugInfo.append(rawExposeCnt + "#");
            debugInfo.append(String.format("%.5f", oldWeightedScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f", judgeLevel) + "#");
            debugInfo.append(String.format("%.5f", currCtr));
        } else {
            debugInfo.append("0" + "#");
            debugInfo.append(weightedExposeCnt + "#");
            debugInfo.append(String.format("%.5f", maxScore) + "#");
            debugInfo.append(sb.toString() + "#");
            debugInfo.append(String.format("%.5f", judgeLevel) + "#");
            debugInfo.append(String.format("%.5f", currCtr) + "#");
            debugInfo.append(oldOrderResultId + "#");
            debugInfo.append(String.format("%.5f", oldMaxScore) + "#");
            debugInfo.append(String.format("%.5f", oldWeightedScore) + "#");
            debugInfo.append(rawExposeCnt);
        }

        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        rerankMaterial.setDebugInfo(debugInfo.toString());
        return rerankMaterial;

    }

    private static RerankMaterial newReRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo, List<MaterialMatchDo> materialMatchDoList, Map<Long, MaterialMatchDo> materialMatchDoMap) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map<Long, MaterialFeatureInfo> materialFeatureInfoMap = materialFeatureDo.getMaterialFeatureInfoMap();

        Long oldOrderResultId = -1L;
        double oldMaxScore = -1;
        boolean userFlag = false;
        if (null != materialFeatureInfoMap) {
            userFlag = true;
        }

        // 传统素材：更为缓和的曝光降权方式，尽量保持模型的排序
        List<RankMaterialInfo> rankMaterialInfoList = new ArrayList<>();
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            double score = entry.getValue();
            Long materialId = entry.getKey();
            long tmpExposeCnt = 0;
            double tmpScore = score;
            if (userFlag && materialFeatureInfoMap.containsKey(materialId)) {
                MaterialFeatureInfo materialFeatureInfo = materialFeatureInfoMap.get(materialId);
                if (null != materialFeatureInfo) {
                    UserMaterialFeature userMaterialFeature = materialFeatureInfo.getUserMaterialFeature();
                    if (null != userMaterialFeature) {
                        Long exposeCnt = userMaterialFeature.getUExposeDayCnt();
                        // 当天曝光降权
                        if (null != exposeCnt) {
                            tmpExposeCnt = exposeCnt;
                            double weight = Math.pow(Math.E, -0.09 * exposeCnt);
                            score = score * weight;
                        }
                    }
                }
            }
            if (tmpScore > oldMaxScore) {
                oldMaxScore = tmpScore;
                oldOrderResultId = materialId;
            }
            RankMaterialInfo rankMaterialInfo = new RankMaterialInfo();
            rankMaterialInfo.setMaterialId(materialId);
            rankMaterialInfo.setDayExposeCnt(tmpExposeCnt);
            rankMaterialInfo.setRankScore(tmpScore);
            rankMaterialInfo.setReRankScore(score);
            // 获取ctr及过去3天的曝光次数
            if (materialMatchDoMap.containsKey(materialId)) {
                MaterialMatchDo materialMatchDo = materialMatchDoMap.get(materialId);
                rankMaterialInfo.setCtr(materialMatchDo.getCtr());
                rankMaterialInfo.setLastExposeCnt(materialMatchDo.getExposeCnt());
            }
            rankMaterialInfoList.add(rankMaterialInfo);
        }

        List<RankMaterialInfo> sortedMaterialList = rankMaterialInfoList.stream()
                .sorted(Comparator.comparing(RankMaterialInfo::getReRankScore).reversed())
                .collect(Collectors.toList());

        // 利用ctr top5素材的平均水平的70%，从重排过滤低质素材
        List<MaterialMatchDo> sortedList = materialMatchDoList.stream()
                .sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed())
                .collect(Collectors.toList());
        int size = Math.min(5, sortedList.size());
        double sum = 0.0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; i++) {
            double ctr = sortedList.get(i).getCtr();
            sb.append(String.format("%.5f", ctr) + ";");
            sum += ctr;
        }
        double avgCtr = sum / size;
        double faithLevel = 0.7;
        double judgeLevel = avgCtr * faithLevel;
        Long leastExpose = 500L;

        RankMaterialInfo resultMaterial = new RankMaterialInfo();
        for (RankMaterialInfo rankMaterialInfo : sortedMaterialList) {
            Double ctr = rankMaterialInfo.getCtr();
            if (ctr != null && (ctr >= judgeLevel || rankMaterialInfo.getLastExposeCnt() <= leastExpose)) {
                resultMaterial = rankMaterialInfo;
                break;
            }
        }


        // debug 格式：原始top1 id # 原始top1 id原始分数 #  重排后top5排序对象信息 # top 5 ctr信息 # 判断70%的分数
        StringBuilder debugInfo = new StringBuilder();
        debugInfo.append(oldOrderResultId + "#");
        debugInfo.append(String.format("%.5f", oldMaxScore) + "#");
        int cutSize = Math.min(5, sortedMaterialList.size());
        debugInfo.append(JSON.toJSONString(sortedMaterialList.stream().limit(cutSize).collect(Collectors.toList())) + "#");
        debugInfo.append(sb.toString() + "#");
        debugInfo.append(String.format("%.5f", judgeLevel));

        if (resultMaterial.getMaterialId() == null) {
            rerankMaterial.setMaterialId(-1L);
            return rerankMaterial;
        }

        rerankMaterial.setMaterialId(resultMaterial.getMaterialId());
        rerankMaterial.setRankScore(resultMaterial.getRankScore());
        rerankMaterial.setReRankScore(resultMaterial.getReRankScore());
        rerankMaterial.setDebugInfo(debugInfo.toString());
        return rerankMaterial;

    }


//    public static void main(String[] args) {
//        String string = " {\"deviceId\":\"7183214b04e218e99d43746c908b27b0\",\"materialFeatureMap\":{561:{\"bConvertWeekCnt\":2,\"clickDayCnt\":2720,\"clickWeekCnt\":1733,\"convertWeekCnt\":48,\"customization\":\"1431\",\"designHue\":\"1987\",\"exposeDayCnt\":163886,\"exposeWeekCnt\":93856,\"industry\":\"1407\",\"materialId\":561,\"rewardElement\":\"1899\",\"slotNature\":\"1443\"}},\"rid\":\"123456\",\"slotFeature\":{\"appId\":76235,\"appIndustryTagId\":\"198\",\"appIndustryTagPid\":\"196\",\"slotId\":352313,\"slotType\":9},\"slotMaterialFeatureMap\":{561:{\"slotBConvertHistCnt\":2,\"slotBConvertWeekCnt\":2,\"slotClickDayCnt\":2720,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1728,\"slotConvertHistCnt\":49,\"slotConvertWeekCnt\":48,\"slotExposeDayCnt\":163886,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":93851}},\"userFeature\":{\"age\":\"010212\",\"appList\":\"14924\",\"consumeLevel\":\"05011701\",\"expDayMaterials\":\"22099,3591,27170\",\"expWeekMaterials\":\"20200729203127-561,20200728093434-26869,20200728094320-27169,20200728094210-27170,20200723183928-27171\",\"marry\":\"01050303\",\"permanentProvince\":\"广西\",\"sex\":\"010102\"},\"userMaterialFeatureMap\":{561:{\"uExposeHistCnt\":3,\"uExposeInterval\":1,\"uExposePeriod\":5,\"uExposeWeekCnt\":3}}}";
//        MaterialFeatureDo exp = JSONObject.parseObject(string, MaterialFeatureDo.class);
//        MaterialRcmdDo ret = forkApiFeatureParse(exp);
//        System.out.println(JSONObject.toJSONString(ret));
//    }

    public static void main(String[] args) throws Exception {
        String string = " {\"appFeature\":{\"appId\":69662,\"appIndustryTagId\":\"384\",\"appIndustryTagPid\":\"40\",\"appToActSkinMap\":{},\"appToMatTagMap\":{\"190\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":14,\"hisExpCnt\":836,\"id\":\"190\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"191\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":1,\"hisExpCnt\":155,\"id\":\"191\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"170\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":13,\"hisExpCnt\":989,\"id\":\"170\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"171\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":3,\"hisExpCnt\":262,\"id\":\"171\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"230\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":15,\"hisExpCnt\":1097,\"id\":\"230\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"231\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":6,\"hisExpCnt\":821,\"id\":\"231\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"232\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":36,\"hisExpCnt\":1735,\"id\":\"232\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"211\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":1,\"id\":\"211\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"233\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":9,\"hisExpCnt\":639,\"id\":\"233\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"213\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":1,\"hisExpCnt\":37,\"id\":\"213\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"215\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":30,\"hisExpCnt\":1741,\"id\":\"215\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"216\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":7,\"id\":\"216\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"219\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":1,\"hisExpCnt\":91,\"id\":\"219\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"181\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":1,\"id\":\"181\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"161\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":36,\"id\":\"161\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"162\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":64,\"id\":\"162\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"187\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":8,\"hisExpCnt\":545,\"id\":\"187\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"220\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":17,\"hisExpCnt\":888,\"id\":\"220\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"221\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":7,\"id\":\"221\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"167\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":50,\"id\":\"167\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"189\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":1,\"id\":\"189\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"200\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":114,\"id\":\"200\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"168\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":30,\"hisExpCnt\":1549,\"id\":\"168\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"201\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":7,\"hisExpCnt\":413,\"id\":\"201\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"223\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":30,\"hisExpCnt\":1380,\"id\":\"223\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"169\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":42,\"hisExpCnt\":2473,\"id\":\"169\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"205\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":30,\"hisExpCnt\":1481,\"id\":\"205\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"227\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":56,\"id\":\"227\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"228\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":33,\"hisExpCnt\":1787,\"id\":\"228\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"208\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":3,\"hisExpCnt\":337,\"id\":\"208\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"84\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":63,\"hisExpCnt\":4387,\"id\":\"84\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"86\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":86,\"id\":\"86\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0}},\"appToRewardTagMap\":{}},\"deviceId\":\"0ace1d1b0928b6f910c9f4e3c2f70710\",\"materialFeatureInfoMap\":{28288:{\"materialFeature\":{\"bConvertWeekCnt\":43,\"clickDayCnt\":225,\"clickWeekCnt\":3529,\"convertWeekCnt\":675,\"customization\":\"2\",\"designHue\":\"230\",\"designType\":\"170\",\"exposeDayCnt\":11360,\"exposeWeekCnt\":182529,\"materialId\":28288,\"sckClkUV14D\":6433,\"sckClkUV3D\":2107,\"sckClkUV7D\":3118,\"sckExpUV14D\":89160,\"sckExpUV3D\":33268,\"sckExpUV7D\":45917,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":299,\"slotBConvertWeekCnt\":42,\"slotClickPeriod\":5,\"slotClickWeekCnt\":3275,\"slotConvertHistCnt\":3600,\"slotConvertWeekCnt\":653,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":161670,\"slotSckClkUV14D\":6168,\"slotSckClkUV3D\":1966,\"slotSckClkUV7D\":2899,\"slotSckExpUV14D\":77492,\"slotSckExpUV3D\":28384,\"slotSckExpUV7D\":39079}},21249:{\"materialFeature\":{\"bConvertWeekCnt\":2,\"clickDayCnt\":54,\"clickWeekCnt\":471,\"convertWeekCnt\":40,\"customization\":\"2\",\"designHue\":\"233\",\"designType\":\"170\",\"exposeDayCnt\":4948,\"exposeWeekCnt\":45093,\"materialId\":21249,\"rewardElement\":\"190\",\"sckClkUV14D\":2414,\"sckClkUV3D\":222,\"sckClkUV7D\":402,\"sckExpUV14D\":32141,\"sckExpUV3D\":7931,\"sckExpUV7D\":10784,\"slotNature\":\"84\",\"strategy\":\"220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":80,\"slotBConvertWeekCnt\":2,\"slotClickPeriod\":5,\"slotClickWeekCnt\":271,\"slotConvertHistCnt\":1097,\"slotConvertWeekCnt\":23,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":17263,\"slotSckClkUV14D\":1550,\"slotSckClkUV3D\":135,\"slotSckClkUV7D\":243,\"slotSckExpUV14D\":18793,\"slotSckExpUV3D\":4290,\"slotSckExpUV7D\":6080}},28289:{\"materialFeature\":{\"bConvertWeekCnt\":27,\"clickDayCnt\":94,\"clickWeekCnt\":1236,\"convertWeekCnt\":246,\"customization\":\"2\",\"designHue\":\"233\",\"exposeDayCnt\":8136,\"exposeWeekCnt\":107001,\"materialId\":28289,\"sckClkUV14D\":2698,\"sckClkUV3D\":597,\"sckClkUV7D\":1122,\"sckExpUV14D\":58467,\"sckExpUV3D\":15194,\"sckExpUV7D\":27018,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":153,\"slotBConvertWeekCnt\":22,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1067,\"slotConvertHistCnt\":1423,\"slotConvertWeekCnt\":216,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":99444,\"slotSckClkUV14D\":2477,\"slotSckClkUV3D\":481,\"slotSckClkUV7D\":983,\"slotSckExpUV14D\":50981,\"slotSckExpUV3D\":13823,\"slotSckExpUV7D\":24679}},28290:{\"materialFeature\":{\"bConvertWeekCnt\":18,\"clickDayCnt\":119,\"clickWeekCnt\":1730,\"convertWeekCnt\":206,\"customization\":\"2\",\"designHue\":\"231\",\"designType\":\"169\",\"exposeDayCnt\":10025,\"exposeWeekCnt\":125711,\"materialId\":28290,\"rewardElement\":\"190\",\"sckClkUV14D\":3185,\"sckClkUV3D\":746,\"sckClkUV7D\":1479,\"sckExpUV14D\":60658,\"sckExpUV3D\":17710,\"sckExpUV7D\":30360,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":97,\"slotBConvertWeekCnt\":18,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1683,\"slotConvertHistCnt\":1188,\"slotConvertWeekCnt\":204,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":116704,\"slotSckClkUV14D\":2839,\"slotSckClkUV3D\":727,\"slotSckClkUV7D\":1440,\"slotSckExpUV14D\":49215,\"slotSckExpUV3D\":16149,\"slotSckExpUV7D\":27495}},2562:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"231\",\"designType\":\"170\",\"exposeDayCnt\":1,\"exposeWeekCnt\":99,\"materialId\":2562,\"rewardElement\":\"191\",\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":367,\"sckExpUV3D\":23,\"sckExpUV7D\":70,\"slotNature\":\"84\",\"strategy\":\"205\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":72,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":324,\"slotSckExpUV3D\":21,\"slotSckExpUV7D\":57}},28291:{\"materialFeature\":{\"bConvertWeekCnt\":14,\"clickDayCnt\":82,\"clickWeekCnt\":1129,\"convertWeekCnt\":230,\"customization\":\"2\",\"designHue\":\"233\",\"exposeDayCnt\":10528,\"exposeWeekCnt\":110643,\"materialId\":28291,\"sckClkUV14D\":2031,\"sckClkUV3D\":615,\"sckClkUV7D\":1034,\"sckExpUV14D\":56125,\"sckExpUV3D\":17908,\"sckExpUV7D\":29805,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":93,\"slotBConvertWeekCnt\":10,\"slotClickPeriod\":5,\"slotClickWeekCnt\":835,\"slotConvertHistCnt\":1020,\"slotConvertWeekCnt\":162,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":102242,\"slotSckClkUV14D\":1711,\"slotSckClkUV3D\":382,\"slotSckClkUV7D\":761,\"slotSckExpUV14D\":47356,\"slotSckExpUV3D\":15085,\"slotSckExpUV7D\":25951}},27524:{\"materialFeature\":{\"bConvertWeekCnt\":255,\"clickDayCnt\":809,\"clickWeekCnt\":12905,\"convertWeekCnt\":2895,\"customization\":\"2\",\"designHue\":\"228\",\"designType\":\"170\",\"exposeDayCnt\":31715,\"exposeWeekCnt\":513086,\"materialId\":27524,\"sckClkUV14D\":20863,\"sckClkUV3D\":5019,\"sckClkUV7D\":10987,\"sckExpUV14D\":186926,\"sckExpUV3D\":57044,\"sckExpUV7D\":104218,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":1164,\"slotBConvertWeekCnt\":254,\"slotClickPeriod\":5,\"slotClickWeekCnt\":12752,\"slotConvertHistCnt\":11866,\"slotConvertWeekCnt\":2880,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":496268,\"slotSckClkUV14D\":20591,\"slotSckClkUV3D\":4980,\"slotSckClkUV7D\":10856,\"slotSckExpUV14D\":176454,\"slotSckExpUV3D\":54955,\"slotSckExpUV7D\":99899}},22023:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":21,\"clickWeekCnt\":387,\"convertWeekCnt\":11,\"customization\":\"2\",\"designHue\":\"228\",\"designType\":\"161\",\"exposeDayCnt\":200,\"exposeWeekCnt\":7161,\"materialId\":22023,\"sckClkUV14D\":1655,\"sckClkUV3D\":179,\"sckClkUV7D\":371,\"sckExpUV14D\":16712,\"sckExpUV3D\":1841,\"sckExpUV7D\":4390,\"slotNature\":\"86\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":6,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":14,\"slotConvertHistCnt\":100,\"slotConvertWeekCnt\":2,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":1597,\"slotSckClkUV14D\":89,\"slotSckClkUV3D\":1,\"slotSckClkUV7D\":14,\"slotSckExpUV14D\":4399,\"slotSckExpUV3D\":28,\"slotSckExpUV7D\":1001}},3848:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"232\",\"exposeDayCnt\":1,\"exposeWeekCnt\":20,\"materialId\":3848,\"rewardElement\":\"191\",\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":47,\"sckExpUV3D\":8,\"sckExpUV7D\":16,\"slotNature\":\"84\",\"strategy\":\"213,219\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":12,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":38,\"slotSckExpUV3D\":3,\"slotSckExpUV7D\":11}},17806:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":10,\"clickDayCnt\":45,\"clickWeekCnt\":1549,\"convertWeekCnt\":154,\"customization\":\"2\",\"designHue\":\"224\",\"designType\":\"171\",\"exposeDayCnt\":1071,\"exposeWeekCnt\":27891,\"materialId\":17806,\"sckClkUV14D\":2177,\"sckClkUV3D\":926,\"sckClkUV7D\":1352,\"sckExpUV14D\":17567,\"sckExpUV3D\":7910,\"sckExpUV7D\":12478,\"slotNature\":\"84\",\"strategy\":\"216\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":2,\"slotClickWeekCnt\":11,\"slotConvertHistCnt\":1,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":1954,\"slotSckClkUV14D\":11,\"slotSckClkUV3D\":6,\"slotSckClkUV7D\":9,\"slotSckExpUV14D\":1335,\"slotSckExpUV3D\":542,\"slotSckExpUV7D\":1297}},27672:{\"materialFeature\":{\"bConvertWeekCnt\":65,\"clickDayCnt\":69,\"clickWeekCnt\":4832,\"convertWeekCnt\":867,\"customization\":\"2\",\"designHue\":\"230\",\"designType\":\"169\",\"exposeDayCnt\":3514,\"exposeWeekCnt\":165797,\"materialId\":27672,\"rewardElement\":\"191\",\"sckClkUV14D\":5093,\"sckClkUV3D\":4122,\"sckClkUV7D\":4303,\"sckExpUV14D\":52470,\"sckExpUV3D\":36462,\"sckExpUV7D\":38674,\"slotNature\":\"84\",\"strategy\":\"205\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":67,\"slotBConvertWeekCnt\":61,\"slotClickPeriod\":5,\"slotClickWeekCnt\":3799,\"slotConvertHistCnt\":937,\"slotConvertWeekCnt\":774,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":135604,\"slotSckClkUV14D\":3801,\"slotSckClkUV3D\":3276,\"slotSckClkUV7D\":3338,\"slotSckExpUV14D\":36234,\"slotSckExpUV3D\":29390,\"slotSckExpUV7D\":30299}},18585:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":77,\"clickDayCnt\":330,\"clickWeekCnt\":6125,\"convertWeekCnt\":1040,\"customization\":\"2\",\"designHue\":\"230\",\"designType\":\"169\",\"exposeDayCnt\":14395,\"exposeWeekCnt\":224870,\"materialId\":18585,\"rewardElement\":\"190\",\"sckClkUV14D\":10791,\"sckClkUV3D\":2595,\"sckClkUV7D\":5374,\"sckExpUV14D\":146007,\"sckExpUV3D\":41676,\"sckExpUV7D\":73981,\"slotNature\":\"84\",\"strategy\":\"201,220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":444,\"slotBConvertWeekCnt\":57,\"slotClickPeriod\":5,\"slotClickWeekCnt\":4059,\"slotConvertHistCnt\":5006,\"slotConvertWeekCnt\":753,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":181702,\"slotSckClkUV14D\":7765,\"slotSckClkUV3D\":1780,\"slotSckClkUV7D\":3571,\"slotSckExpUV14D\":111897,\"slotSckExpUV3D\":31737,\"slotSckExpUV7D\":57002}},3113:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"228\",\"exposeDayCnt\":1,\"exposeWeekCnt\":48,\"materialId\":3113,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":84,\"sckExpUV3D\":1,\"sckExpUV7D\":28,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":2,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":1,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":18,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":69,\"slotSckExpUV3D\":1,\"slotSckExpUV7D\":17}},3114:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":1,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"230\",\"exposeDayCnt\":1,\"exposeWeekCnt\":14,\"materialId\":3114,\"rewardElement\":\"189\",\"sckClkUV14D\":1,\"sckClkUV3D\":0,\"sckClkUV7D\":1,\"sckExpUV14D\":43,\"sckExpUV3D\":0,\"sckExpUV7D\":13,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":7,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":37,\"slotSckExpUV3D\":0,\"slotSckExpUV7D\":7}},1337:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":69,\"convertWeekCnt\":2,\"customization\":\"2\",\"designHue\":\"231\",\"exposeDayCnt\":102,\"exposeWeekCnt\":2375,\"materialId\":1337,\"rewardElement\":\"191\",\"sckClkUV14D\":106,\"sckClkUV3D\":26,\"sckClkUV7D\":62,\"sckExpUV14D\":2255,\"sckExpUV3D\":517,\"sckExpUV7D\":1378,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":4,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":7,\"slotConvertHistCnt\":17,\"slotConvertWeekCnt\":2,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":1153,\"slotSckClkUV14D\":7,\"slotSckClkUV3D\":2,\"slotSckClkUV7D\":7,\"slotSckExpUV14D\":772,\"slotSckExpUV3D\":128,\"slotSckExpUV7D\":637}},14525:{\"materialFeature\":{\"bConvertWeekCnt\":51,\"clickDayCnt\":263,\"clickWeekCnt\":4207,\"convertWeekCnt\":692,\"customization\":\"2\",\"designHue\":\"230\",\"exposeDayCnt\":11408,\"exposeWeekCnt\":182003,\"materialId\":14525,\"sckClkUV14D\":7413,\"sckClkUV3D\":1954,\"sckClkUV7D\":3699,\"sckExpUV14D\":84866,\"sckExpUV3D\":25873,\"sckExpUV7D\":44133,\"slotNature\":\"84\",\"strategy\":\"215\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":374,\"slotBConvertWeekCnt\":48,\"slotClickPeriod\":5,\"slotClickWeekCnt\":3440,\"slotConvertHistCnt\":3707,\"slotConvertWeekCnt\":627,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":151010,\"slotSckClkUV14D\":6196,\"slotSckClkUV3D\":1571,\"slotSckClkUV7D\":3051,\"slotSckExpUV14D\":70626,\"slotSckExpUV3D\":22282,\"slotSckExpUV7D\":37916}},14013:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":12,\"clickDayCnt\":98,\"clickWeekCnt\":2774,\"convertWeekCnt\":247,\"customization\":\"2\",\"designHue\":\"231\",\"designType\":\"168,169\",\"exposeDayCnt\":2003,\"exposeWeekCnt\":62308,\"materialId\":14013,\"rewardElement\":\"187,191\",\"sckClkUV14D\":5181,\"sckClkUV3D\":1075,\"sckClkUV7D\":2428,\"sckExpUV14D\":57714,\"sckExpUV3D\":13619,\"sckExpUV7D\":27554,\"slotNature\":\"84\",\"strategy\":\"201,215\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":25,\"slotBConvertWeekCnt\":4,\"slotClickPeriod\":5,\"slotClickWeekCnt\":561,\"slotConvertHistCnt\":386,\"slotConvertWeekCnt\":70,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":27454,\"slotSckClkUV14D\":1211,\"slotSckClkUV3D\":151,\"slotSckClkUV7D\":476,\"slotSckExpUV14D\":22991,\"slotSckExpUV3D\":4204,\"slotSckExpUV7D\":9886}},4038:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"232\",\"exposeDayCnt\":140,\"exposeWeekCnt\":44,\"materialId\":4038,\"rewardElement\":\"190,191\",\"sckClkUV14D\":1,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":106,\"sckExpUV3D\":24,\"sckExpUV7D\":36,\"slotNature\":\"84\",\"strategy\":\"201\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":44,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":103,\"slotSckExpUV3D\":24,\"slotSckExpUV7D\":36}},23755:{\"materialFeature\":{\"bConvertWeekCnt\":431,\"clickDayCnt\":3423,\"clickWeekCnt\":43735,\"convertWeekCnt\":5438,\"customization\":\"2\",\"designHue\":\"231\",\"designType\":\"169\",\"exposeDayCnt\":20141,\"exposeWeekCnt\":273160,\"materialId\":23755,\"sckClkUV14D\":57176,\"sckClkUV3D\":21021,\"sckClkUV7D\":34409,\"sckExpUV14D\":184474,\"sckExpUV3D\":58855,\"sckExpUV7D\":98472,\"slotNature\":\"84\",\"strategy\":\"208\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":600,\"slotBConvertWeekCnt\":58,\"slotClickPeriod\":5,\"slotClickWeekCnt\":3073,\"slotConvertHistCnt\":5650,\"slotConvertWeekCnt\":574,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":135929,\"slotSckClkUV14D\":7659,\"slotSckClkUV3D\":1335,\"slotSckClkUV7D\":2753,\"slotSckExpUV14D\":81044,\"slotSckExpUV3D\":20738,\"slotSckExpUV7D\":37175}},3151:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"233\",\"exposeDayCnt\":43,\"exposeWeekCnt\":38,\"materialId\":3151,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":79,\"sckExpUV3D\":2,\"sckExpUV7D\":28,\"slotNature\":\"84\",\"strategy\":\"220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":4,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":26,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":73,\"slotSckExpUV3D\":2,\"slotSckExpUV7D\":24}},5456:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"232\",\"designType\":\"170\",\"exposeDayCnt\":60,\"exposeWeekCnt\":19,\"materialId\":5456,\"rewardElement\":\"189\",\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":37,\"sckExpUV3D\":11,\"sckExpUV7D\":18,\"slotNature\":\"84\",\"strategy\":\"209\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":19,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":37,\"slotSckExpUV3D\":11,\"slotSckExpUV7D\":18}},5457:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":41,\"convertWeekCnt\":6,\"exposeDayCnt\":1,\"exposeWeekCnt\":29226,\"materialId\":5457,\"sckClkUV14D\":69,\"sckClkUV3D\":6,\"sckClkUV7D\":25,\"sckExpUV14D\":5163,\"sckExpUV3D\":1880,\"sckExpUV7D\":3507},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":1,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":12,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":66,\"slotSckExpUV3D\":12,\"slotSckExpUV7D\":12}},1362:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":1,\"clickWeekCnt\":94,\"convertWeekCnt\":2,\"customization\":\"2\",\"designHue\":\"233\",\"exposeDayCnt\":49,\"exposeWeekCnt\":3331,\"materialId\":1362,\"sckClkUV14D\":247,\"sckClkUV3D\":26,\"sckClkUV7D\":83,\"sckExpUV14D\":2697,\"sckExpUV3D\":405,\"sckExpUV7D\":1343,\"slotNature\":\"84\",\"strategy\":\"204,216,220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":1,\"slotConvertHistCnt\":1,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":4,\"slotExposeWeekCnt\":797,\"slotSckClkUV14D\":2,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":1,\"slotSckExpUV14D\":798,\"slotSckExpUV3D\":100,\"slotSckExpUV7D\":549}},3794:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"232\",\"exposeDayCnt\":136,\"exposeWeekCnt\":47,\"materialId\":3794,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":86,\"sckExpUV3D\":21,\"sckExpUV7D\":36,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":30,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":74,\"slotSckExpUV3D\":14,\"slotSckExpUV7D\":28}},5458:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"227\",\"designType\":\"171\",\"exposeDayCnt\":1,\"exposeWeekCnt\":4,\"materialId\":5458,\"rewardElement\":\"191\",\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":73,\"sckExpUV3D\":3,\"sckExpUV7D\":3,\"slotNature\":\"84\",\"strategy\":\"204,219\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":1,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":68,\"slotSckExpUV3D\":1,\"slotSckExpUV7D\":1}},4947:{\"materialFeature\":{\"bConvertWeekCnt\":1,\"clickDayCnt\":4,\"clickWeekCnt\":40,\"convertWeekCnt\":5,\"customization\":\"2\",\"designHue\":\"230\",\"exposeDayCnt\":238,\"exposeWeekCnt\":3585,\"materialId\":4947,\"sckClkUV14D\":38,\"sckClkUV3D\":7,\"sckClkUV7D\":22,\"sckExpUV14D\":1447,\"sckExpUV3D\":153,\"sckExpUV7D\":1094,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":6,\"slotConvertHistCnt\":10,\"slotConvertWeekCnt\":2,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":1453,\"slotSckClkUV14D\":10,\"slotSckClkUV3D\":1,\"slotSckClkUV7D\":6,\"slotSckExpUV14D\":1352,\"slotSckExpUV3D\":125,\"slotSckExpUV7D\":1041}},5460:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":9,\"clickWeekCnt\":178,\"convertWeekCnt\":1,\"customization\":\"2\",\"designHue\":\"231\",\"designType\":\"168\",\"exposeDayCnt\":211,\"exposeWeekCnt\":2289,\"materialId\":5460,\"rewardElement\":\"191\",\"sckClkUV14D\":326,\"sckClkUV3D\":87,\"sckClkUV7D\":167,\"sckExpUV14D\":2942,\"sckExpUV3D\":962,\"sckExpUV7D\":1606,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":114,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":109,\"slotSckExpUV3D\":102,\"slotSckExpUV7D\":109}},4949:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":1,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"231\",\"exposeDayCnt\":134,\"exposeWeekCnt\":145,\"materialId\":4949,\"rewardElement\":\"191\",\"sckClkUV14D\":1,\"sckClkUV3D\":0,\"sckClkUV7D\":1,\"sckExpUV14D\":159,\"sckExpUV3D\":102,\"sckExpUV7D\":136,\"slotNature\":\"84\",\"strategy\":\"213\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":2,\"slotClickWeekCnt\":1,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":142,\"slotSckClkUV14D\":1,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":1,\"slotSckExpUV14D\":148,\"slotSckExpUV3D\":102,\"slotSckExpUV7D\":135}},5462:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":5,\"clickDayCnt\":647,\"clickWeekCnt\":17412,\"convertWeekCnt\":244,\"customization\":\"2\",\"designHue\":\"233\",\"designType\":\"171\",\"exposeDayCnt\":6844,\"exposeWeekCnt\":161804,\"materialId\":5462,\"sckClkUV14D\":15256,\"sckClkUV3D\":5535,\"sckClkUV7D\":8852,\"sckExpUV14D\":41753,\"sckExpUV3D\":13411,\"sckExpUV7D\":22029,\"slotNature\":\"84\",\"strategy\":\"204,220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":6,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":1839,\"slotSckClkUV14D\":6,\"slotSckClkUV3D\":6,\"slotSckClkUV7D\":6,\"slotSckExpUV14D\":1051,\"slotSckExpUV3D\":1048,\"slotSckExpUV7D\":1051}},5334:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":1,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"224\",\"designType\":\"171\",\"exposeDayCnt\":146,\"exposeWeekCnt\":55,\"materialId\":5334,\"sckClkUV14D\":1,\"sckClkUV3D\":1,\"sckClkUV7D\":1,\"sckExpUV14D\":66,\"sckExpUV3D\":17,\"sckExpUV7D\":31,\"slotNature\":\"84\",\"strategy\":\"213\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":1,\"slotClickWeekCnt\":1,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":30,\"slotSckClkUV14D\":1,\"slotSckClkUV3D\":1,\"slotSckClkUV7D\":1,\"slotSckExpUV14D\":59,\"slotSckExpUV3D\":17,\"slotSckExpUV7D\":24}},4951:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"227\",\"exposeDayCnt\":1,\"exposeWeekCnt\":27,\"materialId\":4951,\"sckClkUV14D\":4,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":418,\"sckExpUV3D\":9,\"sckExpUV7D\":22,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":6,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":2,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":15,\"slotSckClkUV14D\":4,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":411,\"slotSckExpUV3D\":6,\"slotSckExpUV7D\":15}},4952:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"231\",\"exposeDayCnt\":1,\"exposeWeekCnt\":26,\"materialId\":4952,\"rewardElement\":\"191\",\"sckClkUV14D\":2,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":198,\"sckExpUV3D\":12,\"sckExpUV7D\":25,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":2,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":25,\"slotSckClkUV14D\":2,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":187,\"slotSckExpUV3D\":11,\"slotSckExpUV7D\":24}},5340:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"exposeDayCnt\":2,\"exposeWeekCnt\":268,\"materialId\":5340,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":201,\"sckExpUV3D\":115,\"sckExpUV7D\":151},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":4,\"slotExposeWeekCnt\":68,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":44,\"slotSckExpUV3D\":0,\"slotSckExpUV7D\":35}},28126:{\"materialFeature\":{\"bConvertWeekCnt\":713,\"clickDayCnt\":3520,\"clickWeekCnt\":41726,\"convertWeekCnt\":8642,\"customization\":\"2\",\"designHue\":\"223,228,232\",\"designType\":\"168,169\",\"exposeDayCnt\":339020,\"exposeWeekCnt\":3766028,\"materialId\":28126,\"sckClkUV14D\":86832,\"sckClkUV3D\":17999,\"sckClkUV7D\":34041,\"sckExpUV14D\":620224,\"sckExpUV3D\":175199,\"sckExpUV7D\":320632,\"slotNature\":\"84\",\"strategy\":\"205,215\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":5166,\"slotBConvertWeekCnt\":593,\"slotClickPeriod\":5,\"slotClickWeekCnt\":23442,\"slotConvertHistCnt\":54649,\"slotConvertWeekCnt\":6768,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":669336,\"slotSckClkUV14D\":55499,\"slotSckClkUV3D\":10019,\"slotSckClkUV7D\":19475,\"slotSckExpUV14D\":281550,\"slotSckExpUV3D\":66375,\"slotSckExpUV7D\":119274}},3551:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"exposeDayCnt\":1,\"exposeWeekCnt\":4,\"materialId\":3551,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":51,\"sckExpUV3D\":0,\"sckExpUV7D\":4},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":2,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":2,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":4,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":50,\"slotSckExpUV3D\":0,\"slotSckExpUV7D\":4}},3552:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"exposeDayCnt\":94,\"exposeWeekCnt\":185,\"materialId\":3552,\"sckClkUV14D\":3,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":656,\"sckExpUV3D\":84,\"sckExpUV7D\":135},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":2,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":36,\"slotSckClkUV14D\":2,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":427,\"slotSckExpUV3D\":21,\"slotSckExpUV7D\":33}},4328:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"221\",\"designType\":\"168,171\",\"exposeDayCnt\":2,\"exposeWeekCnt\":33,\"materialId\":4328,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":28,\"sckExpUV3D\":10,\"sckExpUV7D\":18,\"slotNature\":\"84\",\"strategy\":\"215,220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":12,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":21,\"slotSckExpUV3D\":10,\"slotSckExpUV7D\":11}},14314:{\"appMaterialFeature\":{\"appSckClkPV14D\":0,\"appSckClkPV3D\":0,\"appSckClkPV7D\":0,\"appSckClkUV14D\":0,\"appSckClkUV3D\":0,\"appSckClkUV7D\":0,\"appSckExpPV14D\":0,\"appSckExpPV3D\":0,\"appSckExpPV7D\":0,\"appSckExpUV14D\":0,\"appSckExpUV3D\":0,\"appSckExpUV7D\":0},\"materialFeature\":{\"bConvertWeekCnt\":138,\"clickDayCnt\":1061,\"clickWeekCnt\":11849,\"convertWeekCnt\":1652,\"customization\":\"2\",\"designHue\":\"230,232\",\"exposeDayCnt\":31669,\"exposeWeekCnt\":337575,\"materialId\":14314,\"rewardElement\":\"187\",\"sckClkUV14D\":22171,\"sckClkUV3D\":3891,\"sckClkUV7D\":9162,\"sckExpUV14D\":168261,\"sckExpUV3D\":38054,\"sckExpUV7D\":81451,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":1079,\"slotBConvertWeekCnt\":134,\"slotClickPeriod\":5,\"slotClickWeekCnt\":7892,\"slotConvertHistCnt\":11181,\"slotConvertWeekCnt\":1445,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":267373,\"slotSckClkUV14D\":15664,\"slotSckClkUV3D\":2653,\"slotSckClkUV7D\":6477,\"slotSckExpUV14D\":121417,\"slotSckExpUV3D\":26814,\"slotSckExpUV7D\":57182}},23402:{\"materialFeature\":{\"bConvertWeekCnt\":58,\"clickDayCnt\":535,\"clickWeekCnt\":4554,\"convertWeekCnt\":767,\"customization\":\"2\",\"designHue\":\"231\",\"designType\":\"169,171\",\"exposeDayCnt\":22053,\"exposeWeekCnt\":181550,\"materialId\":23402,\"rewardElement\":\"187\",\"sckClkUV14D\":8161,\"sckClkUV3D\":2134,\"sckClkUV7D\":3894,\"sckExpUV14D\":94323,\"sckExpUV3D\":30990,\"sckExpUV7D\":50044,\"slotNature\":\"84\",\"strategy\":\"220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":384,\"slotBConvertWeekCnt\":58,\"slotClickPeriod\":5,\"slotClickWeekCnt\":4234,\"slotConvertHistCnt\":4040,\"slotConvertWeekCnt\":735,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":153894,\"slotSckClkUV14D\":7695,\"slotSckClkUV3D\":2066,\"slotSckClkUV7D\":3629,\"slotSckExpUV14D\":82029,\"slotSckExpUV3D\":27707,\"slotSckExpUV7D\":43543}},2539:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"233\",\"designType\":\"170\",\"exposeDayCnt\":1,\"exposeWeekCnt\":56,\"materialId\":2539,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":175,\"sckExpUV3D\":13,\"sckExpUV7D\":30,\"slotNature\":\"84\",\"strategy\":\"204,216,220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":11,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":103,\"slotSckExpUV3D\":4,\"slotSckExpUV7D\":11}},4975:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"227\",\"designType\":\"171\",\"exposeDayCnt\":12,\"exposeWeekCnt\":17,\"materialId\":4975,\"rewardElement\":\"191\",\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":56,\"sckExpUV3D\":3,\"sckExpUV7D\":14,\"slotNature\":\"84\",\"strategy\":\"193,213,216,219\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":10,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":46,\"slotSckExpUV3D\":2,\"slotSckExpUV7D\":10}},3953:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"221\",\"exposeDayCnt\":41,\"exposeWeekCnt\":71,\"materialId\":3953,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":112,\"sckExpUV3D\":27,\"sckExpUV7D\":57,\"slotNature\":\"84\",\"strategy\":\"216\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":3,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":63,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":107,\"slotSckExpUV3D\":22,\"slotSckExpUV7D\":52}},3954:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"233\",\"exposeWeekCnt\":12,\"materialId\":3954,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":10,\"sckExpUV3D\":2,\"sckExpUV7D\":10,\"slotNature\":\"84\",\"strategy\":\"204,216,220\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":4,\"slotExposeWeekCnt\":12,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":10,\"slotSckExpUV3D\":2,\"slotSckExpUV7D\":10}},3958:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"228\",\"exposeDayCnt\":1,\"exposeWeekCnt\":35,\"materialId\":3958,\"rewardElement\":\"181,191\",\"sckClkUV14D\":6,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":423,\"sckExpUV3D\":12,\"sckExpUV7D\":35,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":2,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":35,\"slotSckClkUV14D\":6,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":422,\"slotSckExpUV3D\":12,\"slotSckExpUV7D\":35}},3577:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"227\",\"exposeDayCnt\":1,\"exposeWeekCnt\":23,\"materialId\":3577,\"sckClkUV14D\":1,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":339,\"sckExpUV3D\":1,\"sckExpUV7D\":15,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":1,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":11,\"slotSckClkUV14D\":1,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":335,\"slotSckExpUV3D\":1,\"slotSckExpUV7D\":11}},3579:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":10,\"convertWeekCnt\":1,\"customization\":\"2\",\"designHue\":\"228\",\"exposeDayCnt\":11,\"exposeWeekCnt\":171,\"materialId\":3579,\"sckClkUV14D\":15,\"sckClkUV3D\":8,\"sckClkUV7D\":10,\"sckExpUV14D\":592,\"sckExpUV3D\":130,\"sckExpUV7D\":154,\"slotNature\":\"84\",\"strategy\":\"211\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":5,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":3,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":5,\"slotExposeWeekCnt\":49,\"slotSckClkUV14D\":5,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":479,\"slotSckExpUV3D\":26,\"slotSckExpUV7D\":47}},3581:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"228\",\"exposeDayCnt\":3,\"exposeWeekCnt\":15,\"materialId\":3581,\"rewardElement\":\"172\",\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":28,\"sckExpUV3D\":11,\"sckExpUV7D\":14,\"slotNature\":\"84\",\"strategy\":\"201\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":5,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":16,\"slotSckExpUV3D\":1,\"slotSckExpUV7D\":4}},5629:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"228\",\"designType\":\"170\",\"exposeDayCnt\":1,\"exposeWeekCnt\":2,\"materialId\":5629,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":4,\"sckExpUV3D\":2,\"sckExpUV7D\":2,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":2,\"slotExposeWeekCnt\":1,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":1,\"slotSckExpUV3D\":1,\"slotSckExpUV7D\":1}},3582:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":2,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"exposeDayCnt\":126,\"exposeWeekCnt\":118,\"materialId\":3582,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":245,\"sckExpUV3D\":62,\"sckExpUV7D\":73},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickPeriod\":1,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":1,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":0,\"slotExposeWeekCnt\":38,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":82,\"slotSckExpUV3D\":22,\"slotSckExpUV7D\":33}},5630:{\"materialFeature\":{\"bConvertWeekCnt\":0,\"clickDayCnt\":0,\"clickWeekCnt\":0,\"convertWeekCnt\":0,\"customization\":\"2\",\"designHue\":\"228\",\"designType\":\"163\",\"exposeDayCnt\":1,\"exposeWeekCnt\":8,\"materialId\":5630,\"sckClkUV14D\":0,\"sckClkUV3D\":0,\"sckClkUV7D\":0,\"sckExpUV14D\":10,\"sckExpUV3D\":1,\"sckExpUV7D\":7,\"slotNature\":\"84\"},\"slotMaterialFeature\":{\"slotBConvertHistCnt\":0,\"slotBConvertWeekCnt\":0,\"slotClickWeekCnt\":0,\"slotConvertHistCnt\":0,\"slotConvertWeekCnt\":0,\"slotExposePeriod\":1,\"slotExposeWeekCnt\":2,\"slotSckClkUV14D\":0,\"slotSckClkUV3D\":0,\"slotSckClkUV7D\":0,\"slotSckExpUV14D\":1,\"slotSckExpUV3D\":1,\"slotSckExpUV7D\":1}}},\"rid\":\"1\",\"slotFeature\":{\"recallSckIdLstForNewUsr\":\"{\\\"28126\\\":0.084051,\\\"14525\\\":0.073047,\\\"23755\\\":0.068765,\\\"14314\\\":0.066616,\\\"27672\\\":0.064851}\",\"slotId\":325603,\"slotToActSkinMap\":{\"2\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":1,\"id\":\"2\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"28\":{\"currDayClickCnt\":16291,\"currDayExpCnt\":17099,\"hisClickCnt\":926943,\"hisExpCnt\":1211065,\"id\":\"28\",\"lastSevenDaysClickCnt\":144580,\"lastSevenDaysExpCnt\":157451},\"6\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":1,\"hisExpCnt\":1,\"id\":\"6\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"8\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":8,\"hisExpCnt\":2,\"id\":\"8\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"21\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":22,\"hisExpCnt\":13,\"id\":\"21\",\"lastSevenDaysClickCnt\":8,\"lastSevenDaysExpCnt\":1}},\"slotToMatTagMap\":{\"190\":{\"currDayClickCnt\":416,\"currDayExpCnt\":25169,\"hisClickCnt\":51922,\"hisExpCnt\":2277441,\"id\":\"190\",\"lastSevenDaysClickCnt\":6069,\"lastSevenDaysExpCnt\":319224},\"191\":{\"currDayClickCnt\":57,\"currDayExpCnt\":2923,\"hisClickCnt\":11418,\"hisExpCnt\":516820,\"id\":\"191\",\"lastSevenDaysClickCnt\":4394,\"lastSevenDaysExpCnt\":166403},\"193\":{\"currDayExpCnt\":3,\"hisClickCnt\":0,\"hisExpCnt\":165,\"id\":\"193\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":14},\"196\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":2,\"id\":\"196\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"230\":{\"currDayClickCnt\":1568,\"currDayExpCnt\":60742,\"hisClickCnt\":135257,\"hisExpCnt\":4632320,\"id\":\"230\",\"lastSevenDaysClickCnt\":22478,\"lastSevenDaysExpCnt\":899614},\"197\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":3,\"id\":\"197\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"231\":{\"currDayClickCnt\":872,\"currDayExpCnt\":39012,\"hisClickCnt\":73776,\"hisExpCnt\":2573330,\"id\":\"231\",\"lastSevenDaysClickCnt\":9587,\"lastSevenDaysExpCnt\":437696},\"232\":{\"currDayClickCnt\":2862,\"currDayExpCnt\":86800,\"hisClickCnt\":248044,\"hisExpCnt\":5392233,\"id\":\"232\",\"lastSevenDaysClickCnt\":31359,\"lastSevenDaysExpCnt\":939850},\"156\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":3,\"id\":\"156\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":1},\"233\":{\"currDayClickCnt\":208,\"currDayExpCnt\":20510,\"hisClickCnt\":24970,\"hisExpCnt\":1453414,\"id\":\"233\",\"lastSevenDaysClickCnt\":2180,\"lastSevenDaysExpCnt\":221638},\"160\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":7,\"hisExpCnt\":1702,\"id\":\"160\",\"lastSevenDaysClickCnt\":2,\"lastSevenDaysExpCnt\":468},\"161\":{\"currDayClickCnt\":1,\"currDayExpCnt\":17,\"hisClickCnt\":1016,\"hisExpCnt\":53958,\"id\":\"161\",\"lastSevenDaysClickCnt\":14,\"lastSevenDaysExpCnt\":1597},\"162\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":1070,\"hisExpCnt\":64013,\"id\":\"162\",\"lastSevenDaysClickCnt\":25,\"lastSevenDaysExpCnt\":3031},\"163\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":14,\"id\":\"163\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":2},\"164\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":1,\"id\":\"164\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"166\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":11,\"id\":\"166\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"167\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":2399,\"hisExpCnt\":125142,\"id\":\"167\",\"lastSevenDaysClickCnt\":7,\"lastSevenDaysExpCnt\":793},\"200\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":3476,\"hisExpCnt\":190849,\"id\":\"200\",\"lastSevenDaysClickCnt\":34,\"lastSevenDaysExpCnt\":4287},\"168\":{\"currDayClickCnt\":2039,\"currDayExpCnt\":60535,\"hisClickCnt\":191316,\"hisExpCnt\":3970980,\"id\":\"168\",\"lastSevenDaysClickCnt\":24035,\"lastSevenDaysExpCnt\":700737},\"201\":{\"currDayClickCnt\":263,\"currDayExpCnt\":12996,\"hisClickCnt\":29890,\"hisExpCnt\":1305133,\"id\":\"201\",\"lastSevenDaysClickCnt\":4620,\"lastSevenDaysExpCnt\":209209},\"169\":{\"currDayClickCnt\":3210,\"currDayExpCnt\":112637,\"hisClickCnt\":287044,\"hisExpCnt\":7366380,\"id\":\"169\",\"lastSevenDaysClickCnt\":40851,\"lastSevenDaysExpCnt\":1420637},\"202\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":7,\"id\":\"202\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"203\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":11,\"id\":\"203\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"204\":{\"currDayExpCnt\":302,\"hisClickCnt\":21,\"hisExpCnt\":5370,\"id\":\"204\",\"lastSevenDaysClickCnt\":7,\"lastSevenDaysExpCnt\":2660},\"205\":{\"currDayClickCnt\":2082,\"currDayExpCnt\":61685,\"hisClickCnt\":195810,\"hisExpCnt\":4136519,\"id\":\"205\",\"lastSevenDaysClickCnt\":27324,\"lastSevenDaysExpCnt\":810678},\"206\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":16,\"hisExpCnt\":1540,\"id\":\"206\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"208\":{\"currDayClickCnt\":227,\"currDayExpCnt\":9601,\"hisClickCnt\":35222,\"hisExpCnt\":1010402,\"id\":\"208\",\"lastSevenDaysClickCnt\":3098,\"lastSevenDaysExpCnt\":137606},\"209\":{\"currDayExpCnt\":60,\"hisClickCnt\":0,\"hisExpCnt\":78,\"id\":\"209\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":19},\"170\":{\"currDayClickCnt\":1062,\"currDayExpCnt\":44544,\"hisClickCnt\":95428,\"hisExpCnt\":3336140,\"id\":\"170\",\"lastSevenDaysClickCnt\":16382,\"lastSevenDaysExpCnt\":681022},\"171\":{\"currDayClickCnt\":523,\"currDayExpCnt\":19455,\"hisClickCnt\":26203,\"hisExpCnt\":850304,\"id\":\"171\",\"lastSevenDaysClickCnt\":4253,\"lastSevenDaysExpCnt\":157807},\"172\":{\"currDayExpCnt\":3,\"hisClickCnt\":0,\"hisExpCnt\":63,\"id\":\"172\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":5},\"210\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":7,\"id\":\"210\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"178\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":1,\"id\":\"178\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":1},\"211\":{\"currDayExpCnt\":11,\"hisClickCnt\":13,\"hisExpCnt\":2468,\"id\":\"211\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":49},\"213\":{\"currDayExpCnt\":273,\"hisClickCnt\":1354,\"hisExpCnt\":70397,\"id\":\"213\",\"lastSevenDaysClickCnt\":3,\"lastSevenDaysExpCnt\":245},\"214\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":14,\"id\":\"214\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":4},\"215\":{\"currDayClickCnt\":2258,\"currDayExpCnt\":70062,\"hisClickCnt\":211264,\"hisExpCnt\":4678055,\"id\":\"215\",\"lastSevenDaysClickCnt\":27475,\"lastSevenDaysExpCnt\":851633},\"216\":{\"currDayExpCnt\":111,\"hisClickCnt\":47,\"hisExpCnt\":7600,\"id\":\"216\",\"lastSevenDaysClickCnt\":12,\"lastSevenDaysExpCnt\":2859},\"218\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":4,\"id\":\"218\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"219\":{\"currDayExpCnt\":5,\"hisClickCnt\":6240,\"hisExpCnt\":325762,\"id\":\"219\",\"lastSevenDaysClickCnt\":57,\"lastSevenDaysExpCnt\":3588},\"181\":{\"currDayExpCnt\":1,\"hisClickCnt\":26,\"hisExpCnt\":3544,\"id\":\"181\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":35},\"182\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":7,\"hisExpCnt\":1698,\"id\":\"182\",\"lastSevenDaysClickCnt\":2,\"lastSevenDaysExpCnt\":468},\"183\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":9,\"id\":\"183\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"187\":{\"currDayClickCnt\":1360,\"currDayExpCnt\":46220,\"hisClickCnt\":89909,\"hisExpCnt\":2602937,\"id\":\"187\",\"lastSevenDaysClickCnt\":12687,\"lastSevenDaysExpCnt\":448727},\"220\":{\"currDayClickCnt\":824,\"currDayExpCnt\":34820,\"hisClickCnt\":64392,\"hisExpCnt\":2336146,\"id\":\"220\",\"lastSevenDaysClickCnt\":8572,\"lastSevenDaysExpCnt\":355614},\"221\":{\"currDayExpCnt\":43,\"hisClickCnt\":10,\"hisExpCnt\":1486,\"id\":\"221\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":87},\"188\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":8,\"id\":\"188\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"189\":{\"currDayExpCnt\":61,\"hisClickCnt\":3,\"hisExpCnt\":716,\"id\":\"189\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":26},\"222\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":33,\"id\":\"222\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"223\":{\"currDayClickCnt\":2032,\"currDayExpCnt\":59819,\"hisClickCnt\":184499,\"hisExpCnt\":3619145,\"id\":\"223\",\"lastSevenDaysClickCnt\":23442,\"lastSevenDaysExpCnt\":669341},\"224\":{\"currDayExpCnt\":189,\"hisClickCnt\":23,\"hisExpCnt\":2694,\"id\":\"224\",\"lastSevenDaysClickCnt\":12,\"lastSevenDaysExpCnt\":1984},\"227\":{\"currDayExpCnt\":6,\"hisClickCnt\":4860,\"hisExpCnt\":257849,\"id\":\"227\",\"lastSevenDaysClickCnt\":56,\"lastSevenDaysExpCnt\":3549},\"228\":{\"currDayClickCnt\":2838,\"currDayExpCnt\":90785,\"hisClickCnt\":242357,\"hisExpCnt\":5480733,\"id\":\"228\",\"lastSevenDaysClickCnt\":36208,\"lastSevenDaysExpCnt\":1167311},\"84\":{\"currDayClickCnt\":5485,\"currDayExpCnt\":211591,\"hisClickCnt\":478931,\"hisExpCnt\":14289463,\"id\":\"84\",\"lastSevenDaysClickCnt\":70525,\"lastSevenDaysExpCnt\":2732634},\"85\":{\"currDayClickCnt\":0,\"currDayExpCnt\":0,\"hisClickCnt\":0,\"hisExpCnt\":5,\"id\":\"85\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":0},\"86\":{\"currDayClickCnt\":1,\"currDayExpCnt\":17,\"hisClickCnt\":3415,\"hisExpCnt\":179090,\"id\":\"86\",\"lastSevenDaysClickCnt\":21,\"lastSevenDaysExpCnt\":2390}},\"slotToRewardTagMap\":{\"34\":{\"currDayClickCnt\":12,\"currDayExpCnt\":17,\"hisClickCnt\":6240,\"hisExpCnt\":11059,\"id\":\"34\",\"lastSevenDaysClickCnt\":4503,\"lastSevenDaysExpCnt\":8362},\"38\":{\"currDayClickCnt\":83,\"currDayExpCnt\":96,\"hisClickCnt\":50572,\"hisExpCnt\":87426,\"id\":\"38\",\"lastSevenDaysClickCnt\":2543,\"lastSevenDaysExpCnt\":6539},\"39\":{\"currDayClickCnt\":15006,\"currDayExpCnt\":19617,\"hisClickCnt\":978781,\"hisExpCnt\":1429920,\"id\":\"39\",\"lastSevenDaysClickCnt\":141525,\"lastSevenDaysExpCnt\":179265},\"40\":{\"currDayClickCnt\":280,\"currDayExpCnt\":249,\"hisClickCnt\":101049,\"hisExpCnt\":119793,\"id\":\"40\",\"lastSevenDaysClickCnt\":11101,\"lastSevenDaysExpCnt\":10248},\"30\":{\"currDayClickCnt\":0,\"currDayExpCnt\":10,\"hisClickCnt\":0,\"hisExpCnt\":4895,\"id\":\"30\",\"lastSevenDaysClickCnt\":0,\"lastSevenDaysExpCnt\":206},\"31\":{\"currDayClickCnt\":398,\"currDayExpCnt\":408,\"hisClickCnt\":10007,\"hisExpCnt\":9262,\"id\":\"31\",\"lastSevenDaysClickCnt\":10007,\"lastSevenDaysExpCnt\":9262},\"42\":{\"currDayClickCnt\":398,\"currDayExpCnt\":418,\"hisClickCnt\":10124,\"hisExpCnt\":17413,\"id\":\"42\",\"lastSevenDaysClickCnt\":10091,\"lastSevenDaysExpCnt\":10388},\"43\":{\"currDayClickCnt\":8830,\"currDayExpCnt\":12129,\"hisClickCnt\":573941,\"hisExpCnt\":974795,\"id\":\"43\",\"lastSevenDaysClickCnt\":109145,\"lastSevenDaysExpCnt\":146402}},\"slotType\":9,\"weekCvrTrade\":\"{\\\"1\\\":0.831522,\\\"3\\\":0.002008,\\\"4\\\":0.017544,\\\"9\\\":0.085208,\\\"10\\\":0.965654,\\\"11\\\":0.722772,\\\"15\\\":0.208391,\\\"16\\\":0.039264,\\\"21\\\":0.035423}\"},\"userFeature\":{}}";
        MaterialFeatureDo exp = JSONObject.parseObject(string, MaterialFeatureDo.class);
        String a = "{\"materialAdvertRelatedDoList\":[],\"materialCostMatchDoList\":[{\"cost\":0.021786,\"materialId\":5462},{\"cost\":0.621245,\"materialId\":14013},{\"cost\":1.449374,\"materialId\":18585},{\"cost\":1.840578,\"materialId\":27524},{\"cost\":1.614238,\"materialId\":23402},{\"cost\":1.349045,\"materialId\":23755},{\"cost\":0.530684,\"materialId\":21249},{\"cost\":0.209337,\"materialId\":17806},{\"cost\":2.379331,\"materialId\":28126},{\"cost\":1.583571,\"materialId\":27672},{\"cost\":1.399082,\"materialId\":28288},{\"cost\":0.852345,\"materialId\":28289},{\"cost\":2.064047,\"materialId\":14314},{\"cost\":0.74171,\"materialId\":28290},{\"cost\":0.547748,\"materialId\":28291},{\"cost\":1.437614,\"materialId\":14525}],\"materialExposeDoList\":[1337,1362,2539,2562,3113,3114,3151,3551,3552,3577,3579,3581,3582,3794,3848,3953,3954,3958,4038,4328,4947,4949,4951,4952,4975,5334,5340,5456,5457,5458,5460,5629,5630,6344,6462,6797,8208,8209,8210,8801,8802,9711,9712,9740,9741,9742,10322,10325,13355,13356,14374,14588,14835,15251,15252,15255,15652,15653,17153,17187,17621,17622,17648,17676,17744,17859,17860,17877,17878,17909,17957,18056,18057,18058,18065,18074,18075,18076,18118,18119,18327,18363,18366,18367,18394,18399,18400,18401,18421,18422,18424,18505,18623,18625,18627,18628,18629,18660,18670,18671,18672,18673,18674,18676,18679,18704,18705,18966,18967,18974,18976,19013,19028,19034,19035,19042,19053,19100,19101,19103,19106,19112,19119,19120,19231,19234,19235,19236,19237,19276,19278,19279,19280,19376,19378,19379,19380,19381,19382,19383,19384,19385,19386,19387,19480,19506,19507,19508,19509,19510,19618,19624,19629,19920,19921,19922,19991,19998,20000,20001,20004,20116,20127,20131,20196,20197,20198,20199,20232,20236,20237,20248,20290,20292,20310,20477,20478,20479,20488,20489,20496,20497,20564,20567,20571,20574,20636,20639,21125,21197,21198,21250,21251,21252,21253,21254,21381,21427,21428,21429,21482,21484,21486,21488,21591,21593,21595,21596,21597,21681,21682,21683,21684,21685,21686,21687,21688,21689,21690,21691,21692,21693,21694,21728,21735,21772,21773,21774,21926,21930,21932,21933,21934,21937,21943,21944,21945,21946,21947,21950,22023,22089,22090,22177,22272,22275,22340,22433,22434,22435,22436,22452,22453,22454,22457,22590,22607,22608,22732,22733,22749,22751,22752,22886,22905,22926,23009,23027,23031,23032,23034,23041,23139,23141,23142,23143,23212,23234,23236,23306,23307,23403,23718,23740,23742,23825,23901,23905,23913,23915,23921,23925,23927,23936,23939,24114,24116,24280,24281,24285,24287,24288,24309,24476,24490,24491,24492,24502,24503,24758,24759,24766,24767,24780,24781,24786,24915,24957,25342,25343,25344,25345,25346,25347,25348,25350,25351,25352,25353,25354,25355,25356,25357,25383,25384,25388,25611,25926,25931,25946,26132,26133,26295,26297,26311,26845,26959,27133,27137,27221,27223,27224,27225,27226,27525,27526,27527,27590,27598,27601,27679,27728,27734,28130,28133,28137,28390,28400,28404,28406,28407,28408],\"materialMatchDoList\":[{\"clickCnt\":10236,\"ctr\":0.03441067666011039,\"exposeCnt\":292751,\"materialId\":28126},{\"clickCnt\":3412,\"ctr\":0.03217265744288125,\"exposeCnt\":103155,\"materialId\":14314},{\"clickCnt\":2177,\"ctr\":0.027520056481296018,\"exposeCnt\":76403,\"materialId\":23402},{\"clickCnt\":1731,\"ctr\":0.027443549068628496,\"exposeCnt\":60663,\"materialId\":27672},{\"clickCnt\":4040,\"ctr\":0.026784557707307,\"exposeCnt\":147031,\"materialId\":27524},{\"clickCnt\":1288,\"ctr\":0.02541910691609478,\"exposeCnt\":48429,\"materialId\":14525},{\"clickCnt\":1184,\"ctr\":0.022892481055692915,\"exposeCnt\":49333,\"materialId\":23755},{\"clickCnt\":1442,\"ctr\":0.022865930767412772,\"exposeCnt\":60420,\"materialId\":18585},{\"clickCnt\":1324,\"ctr\":0.021039024874223662,\"exposeCnt\":60178,\"materialId\":28288},{\"clickCnt\":2,\"ctr\":0.017570843134015423,\"exposeCnt\":38,\"materialId\":22023},{\"clickCnt\":161,\"ctr\":0.014943402629925615,\"exposeCnt\":9474,\"materialId\":14013},{\"clickCnt\":682,\"ctr\":0.014012288696456364,\"exposeCnt\":45721,\"materialId\":28290},{\"clickCnt\":186,\"ctr\":0.012125980046648893,\"exposeCnt\":13607,\"materialId\":21249},{\"clickCnt\":427,\"ctr\":0.010819297220052985,\"exposeCnt\":36463,\"materialId\":28289},{\"clickCnt\":349,\"ctr\":0.007573647086197027,\"exposeCnt\":42212,\"materialId\":28291},{\"clickCnt\":2,\"ctr\":0.004842356799281692,\"exposeCnt\":137,\"materialId\":3582},{\"clickCnt\":6,\"ctr\":0.004413173650038826,\"exposeCnt\":704,\"materialId\":17806},{\"clickCnt\":1,\"ctr\":0.0021899781950027544,\"exposeCnt\":102,\"materialId\":4947},{\"clickCnt\":6,\"ctr\":0.0014641294166768727,\"exposeCnt\":2120,\"materialId\":5462},{\"clickCnt\":1,\"ctr\":0.0014220936541879772,\"exposeCnt\":157,\"materialId\":5334},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":151,\"materialId\":1337},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":86,\"materialId\":1362},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":5,\"materialId\":2539},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":24,\"materialId\":2562},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":2,\"materialId\":3113},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":1,\"materialId\":3114},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":44,\"materialId\":3151},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":1,\"materialId\":3551},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":113,\"materialId\":3552},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":2,\"materialId\":3577},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":42,\"materialId\":3579},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":4,\"materialId\":3581},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":153,\"materialId\":3794},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":4,\"materialId\":3848},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":67,\"materialId\":3953},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":2,\"materialId\":3954},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":13,\"materialId\":3958},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":171,\"materialId\":4038},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":13,\"materialId\":4328},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":239,\"materialId\":4949},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":7,\"materialId\":4951},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":13,\"materialId\":4952},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":3,\"materialId\":4975},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":5340},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":73,\"materialId\":5456},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":13,\"materialId\":5457},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":2,\"materialId\":5458},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":209,\"materialId\":5460},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":2,\"materialId\":5629},{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":2,\"materialId\":5630}],\"materialMatchDoMap\":{20488:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20488},20489:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20489},25611:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25611},8208:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":8208},20496:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20496},8209:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":8209},20497:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20497},8210:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":8210},19480:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19480},27672:{\"$ref\":\"$.materialMatchDoList[3]\"},27679:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27679},14374:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":14374},3113:{\"$ref\":\"$.materialMatchDoList[24]\"},3114:{\"$ref\":\"$.materialMatchDoList[25]\"},13355:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":13355},13356:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":13356},19506:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19506},19507:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19507},19508:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19508},19509:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19509},19510:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19510},22590:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22590},18505:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18505},3151:{\"$ref\":\"$.materialMatchDoList[26]\"},22607:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22607},22608:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22608},27728:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27728},10322:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":10322},20564:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20564},10325:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":10325},27734:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27734},20567:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20567},21591:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21591},21593:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21593},20571:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20571},21595:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21595},21596:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21596},21597:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21597},20574:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20574},18585:{\"$ref\":\"$.materialMatchDoList[7]\"},20636:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20636},20639:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":1,\"materialId\":20639},19618:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19618},23718:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23718},19624:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19624},19629:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19629},21681:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21681},21682:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21682},21683:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21683},21684:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21684},21685:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21685},21686:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21686},24758:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24758},21687:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21687},24759:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24759},21688:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21688},21689:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21689},21690:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21690},21691:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21691},21692:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21692},23740:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23740},14525:{\"$ref\":\"$.materialMatchDoList[5]\"},21693:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21693},21694:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21694},23742:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23742},24766:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24766},18623:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18623},24767:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24767},18625:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18625},18627:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18627},18628:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18628},18629:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18629},6344:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":10,\"materialId\":6344},23755:{\"$ref\":\"$.materialMatchDoList[6]\"},22732:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22732},24780:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24780},22733:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22733},24781:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24781},24786:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24786},17621:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17621},5334:{\"$ref\":\"$.materialMatchDoList[19]\"},17622:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17622},5340:{\"$ref\":\"$.materialMatchDoList[43]\"},22749:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22749},26845:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":26845},22751:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22751},21728:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21728},22752:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22752},18660:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18660},21735:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21735},4328:{\"$ref\":\"$.materialMatchDoList[38]\"},18670:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18670},18671:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18671},17648:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17648},18672:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18672},18673:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18673},18674:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18674},18676:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18676},18679:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18679},14588:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":14588},17676:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17676},21772:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21772},21773:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21773},21774:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21774},18704:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18704},18705:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18705},23825:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23825},15652:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":15652},15653:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":15653},1337:{\"$ref\":\"$.materialMatchDoList[20]\"},6462:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":6462},25926:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25926},25931:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25931},26959:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":26959},5456:{\"$ref\":\"$.materialMatchDoList[44]\"},17744:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17744},5457:{\"$ref\":\"$.materialMatchDoList[45]\"},1362:{\"$ref\":\"$.materialMatchDoList[21]\"},5458:{\"$ref\":\"$.materialMatchDoList[46]\"},24915:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24915},5460:{\"$ref\":\"$.materialMatchDoList[47]\"},5462:{\"$ref\":\"$.materialMatchDoList[18]\"},25946:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25946},23901:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23901},23905:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23905},22886:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22886},23913:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23913},23915:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23915},23921:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23921},23925:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23925},23927:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23927},22905:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22905},24957:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24957},23936:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23936},23939:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23939},17806:{\"$ref\":\"$.materialMatchDoList[16]\"},22926:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22926},21926:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21926},21930:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21930},21932:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21932},21933:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21933},21934:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21934},21937:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21937},21943:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21943},21944:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21944},21945:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21945},21946:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21946},21947:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21947},21950:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21950},17859:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17859},17860:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17860},19920:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19920},19921:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19921},19922:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":2,\"materialId\":19922},17877:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17877},17878:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17878},28126:{\"$ref\":\"$.materialMatchDoList[0]\"},3551:{\"$ref\":\"$.materialMatchDoList[27]\"},3552:{\"$ref\":\"$.materialMatchDoList[28]\"},23009:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23009},28130:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28130},28133:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28133},28137:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28137},2539:{\"$ref\":\"$.materialMatchDoList[22]\"},9711:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":9711},9712:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":9712},14835:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":14835},23027:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23027},17909:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":4,\"materialId\":17909},23031:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23031},23032:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23032},3577:{\"$ref\":\"$.materialMatchDoList[29]\"},23034:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23034},3579:{\"$ref\":\"$.materialMatchDoList[30]\"},3581:{\"$ref\":\"$.materialMatchDoList[31]\"},5629:{\"$ref\":\"$.materialMatchDoList[48]\"},27133:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27133},3582:{\"$ref\":\"$.materialMatchDoList[15]\"},5630:{\"$ref\":\"$.materialMatchDoList[49]\"},23041:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23041},27137:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27137},2562:{\"$ref\":\"$.materialMatchDoList[23]\"},22023:{\"$ref\":\"$.materialMatchDoList[9]\"},9740:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":9740},9741:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":9741},9742:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":9742},26132:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":26132},26133:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":26133},18966:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18966},18967:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18967},19991:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19991},18974:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18974},19998:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":1,\"materialId\":19998},18976:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18976},20000:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20000},20001:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20001},20004:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20004},17957:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17957},24114:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24114},24116:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24116},19013:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19013},22089:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22089},22090:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22090},19028:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19028},27221:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27221},27223:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27223},27224:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27224},27225:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27225},19034:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19034},27226:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27226},19035:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19035},8801:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":8801},8802:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":8802},19042:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19042},23139:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23139},23141:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23141},23142:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23142},23143:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23143},19053:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":5,\"materialId\":19053},28288:{\"$ref\":\"$.materialMatchDoList[8]\"},28289:{\"$ref\":\"$.materialMatchDoList[13]\"},28290:{\"$ref\":\"$.materialMatchDoList[11]\"},28291:{\"$ref\":\"$.materialMatchDoList[14]\"},21125:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21125},18056:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18056},18057:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18057},18058:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18058},6797:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":6797},18065:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18065},20116:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20116},18074:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18074},18075:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18075},18076:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18076},19100:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19100},19101:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19101},19103:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19103},20127:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20127},22177:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22177},19106:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19106},20131:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20131},19112:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19112},23212:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23212},19119:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19119},19120:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19120},26295:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":26295},26297:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":26297},14013:{\"$ref\":\"$.materialMatchDoList[10]\"},23234:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23234},23236:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23236},18118:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18118},18119:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18119},26311:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":26311},21197:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21197},21198:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21198},3794:{\"$ref\":\"$.materialMatchDoList[32]\"},24280:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24280},24281:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24281},24285:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24285},24287:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24287},24288:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":4,\"materialId\":24288},20196:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20196},20197:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20197},20198:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20198},28390:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28390},20199:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20199},28400:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28400},28404:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28404},24309:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24309},28406:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28406},28407:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28407},28408:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":28408},25342:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25342},25343:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25343},22272:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22272},25344:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25344},17153:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":48,\"materialId\":17153},21249:{\"$ref\":\"$.materialMatchDoList[12]\"},25345:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25345},21250:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21250},25346:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25346},21251:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21251},22275:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22275},25347:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25347},21252:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21252},25348:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25348},21253:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21253},21254:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21254},25350:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25350},25351:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25351},3848:{\"$ref\":\"$.materialMatchDoList[33]\"},20232:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20232},25352:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25352},25353:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25353},23306:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23306},25354:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25354},23307:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23307},25355:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25355},20236:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20236},25356:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25356},20237:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20237},25357:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25357},20248:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20248},19231:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19231},19234:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19234},17187:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":17187},19235:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19235},19236:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19236},19237:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19237},25383:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25383},25384:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25384},25388:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":25388},20290:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20290},20292:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20292},22340:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":4,\"materialId\":22340},19276:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19276},19278:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19278},19279:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19279},19280:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19280},4947:{\"$ref\":\"$.materialMatchDoList[17]\"},4949:{\"$ref\":\"$.materialMatchDoList[39]\"},20310:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20310},4951:{\"$ref\":\"$.materialMatchDoList[40]\"},4952:{\"$ref\":\"$.materialMatchDoList[41]\"},23402:{\"$ref\":\"$.materialMatchDoList[2]\"},23403:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":23403},4975:{\"$ref\":\"$.materialMatchDoList[42]\"},3953:{\"$ref\":\"$.materialMatchDoList[34]\"},3954:{\"$ref\":\"$.materialMatchDoList[35]\"},3958:{\"$ref\":\"$.materialMatchDoList[36]\"},27524:{\"$ref\":\"$.materialMatchDoList[4]\"},21381:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21381},27525:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27525},27526:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27526},27527:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27527},15251:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":15251},15252:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":15252},15255:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":15255},18327:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18327},24476:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24476},22433:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22433},22434:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22434},22435:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22435},22436:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22436},24490:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24490},24491:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24491},24492:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24492},19376:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19376},19378:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19378},19379:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19379},21427:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21427},19380:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19380},21428:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21428},22452:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":1,\"materialId\":22452},19381:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19381},21429:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21429},22453:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22453},19382:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19382},22454:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22454},24502:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24502},19383:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19383},24503:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":24503},19384:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19384},19385:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19385},22457:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":22457},19386:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19386},18363:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18363},19387:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":19387},18366:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18366},18367:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18367},4038:{\"$ref\":\"$.materialMatchDoList[37]\"},27590:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27590},27598:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":11,\"materialId\":27598},27601:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":27601},18394:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18394},18399:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18399},18400:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18400},18401:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18401},14314:{\"$ref\":\"$.materialMatchDoList[1]\"},21482:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21482},21484:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21484},21486:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21486},21488:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":21488},18421:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18421},18422:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18422},18424:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":18424},20477:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20477},20478:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20478},20479:{\"clickCnt\":0,\"ctr\":0.0,\"exposeCnt\":0,\"materialId\":20479}}}";
        MaterialExtractDo materialExtractDo = JSONObject.parseObject(a, MaterialExtractDo.class);
        MaterialRcmdDo ret =  rankAddNewUsrRclWay(null, materialExtractDo, exp);
        System.out.println(JSONObject.toJSONString(ret));
    }

}