/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxBid;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.FeatureIndex;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.Model;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRecommend {
    private static final Logger logger = LoggerFactory.getLogger(AdxRecommend.class);

    public static void needPreIdeaId(List<AdIdeaDo> adIdeaDos, Map<Long, AdxRecallDo> recallDoMap, Map<Long, AdxRecallDo> dpaRecallDoMap) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adIdeaDos, recallDoMap, dpaRecallDoMap})) {
            logger.warn("AdxRecommend.needPreIdeaId params not valid");
            return;
        }
        for (AdIdeaDo adIdeaDo : adIdeaDos) {
            if (adIdeaDo == null || adIdeaDo.getUnitPutType() == 1) continue;
            Long styleId = adIdeaDo.getStyleId();
            AdxRecallDo adxRecallDo = adIdeaDo.isDpa() ? dpaRecallDoMap.get(styleId) : recallDoMap.get(styleId);
            Set<Long> recallSet = AdxRecallDo.getRecallSet(adxRecallDo);
            List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos().stream().filter(s -> recallSet.contains(s.getIdeaUnitId())).collect(Collectors.toList());
            adIdeaDo.setIdeaUnitDos(ideaUnitDos);
        }
    }

    public static Map<FeatureIndex, FeatureMapDo> getFeatureMap(List<AdxIdeaFeatureDo> adxIdeaFeatureDos, AdxFeatureDo adxFeatureDo) {
        HashMap<FeatureIndex, FeatureMapDo> featureMap = new HashMap<FeatureIndex, FeatureMapDo>();
        Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
        if (AssertUtil.isEmpty(adxIdeaFeatureDos)) {
            return featureMap;
        }
        for (AdxIdeaFeatureDo ideaDo : adxIdeaFeatureDos) {
            Long ideaId = ideaDo.getIdeaId();
            Long ideaUnitId = ideaDo.getIdeaUnitId();
            Long materialId = AdxStatData.nullToDefault(ideaDo.getMaterialId(), -1L);
            FeatureIndex featureIndex = new FeatureIndex(ideaId, ideaUnitId);
            AdxFeatureDo dynamicDo = new AdxFeatureDo();
            dynamicDo.setIdeaId(ideaId);
            dynamicDo.setButtonText(ideaDo.getButtonText());
            dynamicDo.setIconH(ideaDo.getIconH());
            dynamicDo.setIconW(ideaDo.getIconW());
            dynamicDo.setMjPicType(ideaDo.getMjPicType());
            dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1());
            dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1());
            dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2());
            dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2());
            dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3());
            dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3());
            dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum());
            dynamicDo.setStyleStandard(ideaDo.getStyleStandard());
            dynamicDo.setIdeaType(ideaDo.getIdeaType());
            dynamicDo.setPictureType(ideaDo.getPictureType());
            dynamicDo.setMaterialId(materialId);
            dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo());
            dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo());
            dynamicDo.setIdeaActAccCntDay(ideaDo.getIdeaActAccCntDay());
            dynamicDo.setIdeaActJoinCntDay(ideaDo.getIdeaActJoinCntDay());
            dynamicDo.setIdeaActAccCntWeek(ideaDo.getIdeaActAccCntWeek());
            dynamicDo.setIdeaActJoinCntWeek(ideaDo.getIdeaActJoinCntWeek());
            dynamicDo.setActIdeaActAccCntDay(ideaDo.getActIdeaActAccCntDay());
            dynamicDo.setActIdeaActJoinCntDay(ideaDo.getActIdeaActJoinCntDay());
            dynamicDo.setActIdeaActAccCntWeek(ideaDo.getActIdeaActAccCntWeek());
            dynamicDo.setActIdeaActJoinCntWeek(ideaDo.getActIdeaActJoinCntWeek());
            Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)dynamicDo, (AdxFeatureDo)adxFeatureDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(featureIndex, featureMapDo);
        }
        return featureMap;
    }

    public static Map<FeatureIndex, Double> predict(Map<FeatureIndex, FeatureMapDo> featureMap, Model model, PredictType predictType) throws Exception {
        Map<FeatureIndex, Double> ret = new HashMap<FeatureIndex, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureMap, model, predictType})) {
            logger.warn("AdxRecommend.predict params is not valid");
            return ret;
        }
        if (predictType == PredictType.CTR) {
            ret = model.predictCtr(featureMap);
        } else if (predictType == PredictType.PVLAUNCH) {
            ret = model.predictLaunchPv(featureMap);
        }
        return ret;
    }

    public static void rawRank(List<AdIdeaDo> adIdeaDos, Map<FeatureIndex, Double> preCtrMap, Integer limitSize) {
        try {
            for (AdIdeaDo adIdeaDo : adIdeaDos) {
                Long adIdeaId = adIdeaDo.getIdeaId();
                List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos().stream().sorted(Comparator.comparing(ideaUnitDo -> {
                    Long ideaUnitId = ((IdeaUnitDo)ideaUnitDo).getIdeaUnitId();
                    FeatureIndex featureIndex = new FeatureIndex(adIdeaId, ideaUnitId);
                    Double preCtr = preCtrMap.getOrDefault(featureIndex, 0.0);
                    return preCtr;
                }).reversed()).limit(limitSize.intValue()).collect(Collectors.toList());
                adIdeaDo.setIdeaUnitDos(ideaUnitDos);
            }
        }
        catch (Exception e) {
            logger.error("AdxRecommend.rawRank error", (Throwable)e);
        }
    }

    public static List<AdxBidRet> bidding(List<AdIdeaDo> adIdeaDos, AdxFactorDo adxFactorDo, String appId) {
        List adxBidRets = null;
        try {
            adxBidRets = adIdeaDos.stream().map(adIdeaDo -> {
                Long ideaId = adIdeaDo.getIdeaId();
                Long resId = adIdeaDo.getResId();
                AdxFactorBaseDo factorBaseDo = adxFactorDo.getFactorBaseDo(resId, ideaId, appId);
                return AdxBid.buildAdxBidReq(adIdeaDo, factorBaseDo, appId);
            }).flatMap(Collection::stream).map(AdxBid::bid).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("AdxRecommend.bidding", (Throwable)e);
        }
        return adxBidRets;
    }

    public static List<AdxBidRet> fineRank(List<AdxBidRet> adxBidRets) {
        return adxBidRets.stream().sorted(Comparator.comparing(AdxBidRet::getAdxAlgoPrice).reversed()).collect(Collectors.toList());
    }
}

